/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.features.AbstractFeatureGrapher;
import fiji.plugin.trackmate.features.ModelDataset;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.awt.Frame;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.scijava.plugin.Plugin;

public class PlotNSpotsVsTimeAction
extends AbstractTMAction {
    public static final String NAME = "Plot N spots vs time";
    public static final String KEY = "PLOT_NSPOTS_VS_TIME";
    public static final String INFO_TEXT = "<html>Plot the number of spots in each frame as a function <br>of time. Only the filtered spots are taken into account. </html>";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        Model model = trackmate.getModel();
        Settings settings = trackmate.getSettings();
        SpotCollection spots = model.getSpots();
        int maxFrame = spots.keySet().stream().mapToInt(Integer::intValue).max().getAsInt();
        int[] nSpots = new int[maxFrame + 1];
        double[] time = new double[maxFrame + 1];
        for (int frame = 0; frame <= maxFrame; ++frame) {
            nSpots[frame] = spots.getNSpots(frame, true);
            time[frame] = (double)frame * settings.dt;
        }
        NSpotPerFrameDataset dataset = new NSpotPerFrameDataset(model, selectionModel, displaySettings, time, nSpots);
        String yFeature = "N spots";
        HashMap<String, Dimension> dimMap = new HashMap<String, Dimension>(2);
        dimMap.put("N spots", Dimension.NONE);
        dimMap.put("POSITION_T", Dimension.TIME);
        HashMap<String, String> nameMap = new HashMap<String, String>(2);
        nameMap.put("N spots", "N spots");
        nameMap.put("POSITION_T", "T");
        NSpotPerFrameGrapher grapher = new NSpotPerFrameGrapher("POSITION_T", Collections.singletonList("N spots"), Dimension.TIME, dimMap, nameMap, model.getSpaceUnits(), model.getTimeUnits(), dataset);
        JFrame frame = grapher.render();
        frame.setIconImage(Icons.PLOT_ICON.getImage());
        frame.setTitle("N spots per time-point");
        GuiUtils.positionWindow(frame, SwingUtilities.getWindowAncestor(parent));
        frame.setVisible(true);
    }

    private static class NSpotPerFrameDataset
    extends ModelDataset {
        private static final long serialVersionUID = 1L;
        private final double[] time;
        private final int[] nspots;

        public NSpotPerFrameDataset(Model model, SelectionModel selectionModel, DisplaySettings ds, double[] time, int[] nspots) {
            super(model, selectionModel, ds, "POSITION_T", Collections.singletonList("N spots"));
            this.time = time;
            this.nspots = nspots;
        }

        public int getItemCount(int series) {
            return this.nspots.length;
        }

        public Number getX(int series, int item) {
            return this.time[item];
        }

        public Number getY(int series, int item) {
            return (double)this.nspots[item];
        }

        public String getSeriesKey(int series) {
            return (String)this.yFeatures.get(series);
        }

        @Override
        public String getItemLabel(int item) {
            return "" + item;
        }

        @Override
        public void setItemLabel(int item, String label) {
        }

        @Override
        public XYItemRenderer getRenderer() {
            return new XYLineAndShapeRenderer(true, true);
        }
    }

    private static class NSpotPerFrameGrapher
    extends AbstractFeatureGrapher {
        private final NSpotPerFrameDataset dataset;

        public NSpotPerFrameGrapher(String xFeature, List<String> yFeatures, Dimension xDimension, Map<String, Dimension> yDimensions, Map<String, String> featureNames, String spaceUnits, String timeUnits, NSpotPerFrameDataset dataset) {
            super(xFeature, yFeatures, xDimension, yDimensions, featureNames, spaceUnits, timeUnits);
            this.dataset = dataset;
        }

        @Override
        protected ModelDataset buildMainDataSet(List<String> targetYFeatures) {
            return this.dataset;
        }
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return PlotNSpotsVsTimeAction.INFO_TEXT;
        }

        @Override
        public String getName() {
            return PlotNSpotsVsTimeAction.NAME;
        }

        @Override
        public String getKey() {
            return PlotNSpotsVsTimeAction.KEY;
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.PLOT_ICON;
        }

        @Override
        public TrackMateAction create() {
            return new PlotNSpotsVsTimeAction();
        }
    }
}

