/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.awt.Frame;
import java.util.Iterator;
import java.util.NavigableSet;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class ResetSpotTimeFeatureAction
extends AbstractTMAction {
    public static final String NAME = "Reset spot time";
    public static final String INFO_TEXT = "<html>Reset the time feature of all spots: it is set to the frame number times the frame interval. </html>";
    private static final String KEY = "RESET_SPOT_TIME";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        this.logger.log("Reset spot time.\n");
        double dt = trackmate.getSettings().dt;
        if (dt == 0.0) {
            dt = 1.0;
        }
        SpotCollection spots = trackmate.getModel().getSpots();
        NavigableSet<Integer> frames = spots.keySet();
        Iterator iterator = frames.iterator();
        while (iterator.hasNext()) {
            int frame = (Integer)iterator.next();
            Iterator<Spot> iterator2 = spots.iterator(frame, true);
            while (iterator2.hasNext()) {
                iterator2.next().putFeature("POSITION_T", (double)frame * dt);
            }
            this.logger.setProgress((double)(frame + 1) / (double)frames.size());
        }
        this.logger.log("Done.\n");
        this.logger.setProgress(0.0);
    }

    @Plugin(type=TrackMateActionFactory.class, visible=false)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return ResetSpotTimeFeatureAction.INFO_TEXT;
        }

        @Override
        public String getName() {
            return ResetSpotTimeFeatureAction.NAME;
        }

        @Override
        public String getKey() {
            return ResetSpotTimeFeatureAction.KEY;
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.TIME_ICON;
        }

        @Override
        public TrackMateAction create() {
            return new ResetSpotTimeFeatureAction();
        }
    }
}

