/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.autonaming;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.action.autonaming.AutoNamingRule;
import java.util.Collection;

public class CopyTrackNameNamingRule
implements AutoNamingRule {
    private static final String INFO_TEXT = "All the spots receive the name of the track they belong to.";

    @Override
    public void nameRoot(Spot root, TrackModel model) {
        Integer id = model.trackIDOf(root);
        String trackName = model.name(id);
        root.setName(trackName);
    }

    @Override
    public void nameBranches(Spot mother, Collection<Spot> siblings) {
        for (Spot spot : siblings) {
            spot.setName(mother.getName());
        }
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    public String toString() {
        return "Copy track name";
    }
}

