/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.closegaps;

import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.action.closegaps.CloseGapsController;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.awt.Frame;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class CloseGapsAction
extends AbstractTMAction {
    public static final String NAME = "Close gaps by introducing new spots";
    public static final String KEY = "CLOSE_GAPS";
    public static final String INFO_TEXT = "<html>This action proposes several methods to close gaps in tracks.<p>Gaps are part of tracks where spots are missing in one or several consecutive frames. The listed methods can introduce new spots in such gaps, depending on possibly the other spots in tracks and/or the image data.<p>They are useful to fix missed detection when a uninterrupted list of position is required for track analysis. For instance in FRAP experiments, where you need to measure signal intensity changing during time, even if the spot is not visible.</html>";
    public static final ImageIcon ICON = Icons.ORANGE_ASTERISK_ICON;
    public static final String DOC_URL = "https://imagej.net/plugins/trackmate/actions/close-gaps-action";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        CloseGapsController controller = new CloseGapsController(trackmate, this.logger);
        controller.show();
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return CloseGapsAction.INFO_TEXT;
        }

        @Override
        public String getKey() {
            return CloseGapsAction.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new CloseGapsAction();
        }

        @Override
        public ImageIcon getIcon() {
            return ICON;
        }

        @Override
        public String getName() {
            return CloseGapsAction.NAME;
        }

        @Override
        public String getUrl() {
            return CloseGapsAction.DOC_URL;
        }
    }
}

