/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.closegaps;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.closegaps.CloseGapsAction;
import fiji.plugin.trackmate.action.closegaps.CloseGapsByDetection;
import fiji.plugin.trackmate.action.closegaps.CloseGapsByLinearInterpolation;
import fiji.plugin.trackmate.action.closegaps.CloseGapsPanel;
import fiji.plugin.trackmate.action.closegaps.GapClosingMethod;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.util.EverythingDisablerAndReenabler;
import fiji.plugin.trackmate.util.Threads;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class CloseGapsController {
    private final TrackMate trackmate;
    private final Logger logger;
    private final CloseGapsPanel gui;

    public CloseGapsController(TrackMate trackmate, Logger logger) {
        this.trackmate = trackmate;
        this.logger = logger;
        ArrayList<GapClosingMethod> gapClosingMethods = new ArrayList<GapClosingMethod>(2);
        gapClosingMethods.add(new CloseGapsByLinearInterpolation());
        gapClosingMethods.add(new CloseGapsByDetection());
        this.gui = new CloseGapsPanel(gapClosingMethods);
        this.gui.btnRun.addActionListener(e -> this.run((GapClosingMethod)this.gui.cmbboxMethod.getSelectedItem()));
    }

    private void run(GapClosingMethod gapClosingMethod) {
        EverythingDisablerAndReenabler disabler = new EverythingDisablerAndReenabler(this.gui, new Class[]{JLabel.class});
        disabler.disable();
        Threads.run("TrackMateGapClosingThread", () -> {
            try {
                this.logger.log("Applying gap-closing method: " + gapClosingMethod.toString() + ".\n");
                this.logger.setStatus("Gap-closing");
                gapClosingMethod.execute(this.trackmate, this.logger);
                this.logger.log("Gap-closing done.\n");
            }
            finally {
                disabler.reenable();
            }
        });
    }

    public void show() {
        if (this.gui.getParent() != null && this.gui.getParent().isVisible()) {
            return;
        }
        JFrame frame = new JFrame("TrackMate gap-closing");
        frame.setIconImage(CloseGapsAction.ICON.getImage());
        frame.setSize(300, 500);
        frame.getContentPane().add(this.gui);
        GuiUtils.positionWindow(frame, (Component)this.trackmate.getSettings().imp.getCanvas());
        frame.setVisible(true);
    }
}

