/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.detector.ManualDetectorConfigurationPanel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class ManualDetectorFactory<T extends RealType<T> & NativeType<T>>
implements SpotDetectorFactory<T> {
    public static final String DETECTOR_KEY = "MANUAL_DETECTOR";
    public static final String NAME = "Manual annotation";
    public static final String INFO_TEXT = "<html>Selecting this will skip the automatic detection phase, and jump directly <br>to manual segmentation. A default spot size will be used. </html>";
    public static final ImageIcon ICON = new ImageIcon(Icons.class.getResource("images/ManualEditor-icon-64px.png"));

    @Override
    public boolean has2Dsegmentation() {
        return true;
    }

    @Override
    public ConfigurationPanel getDetectorConfigurationPanel(Settings settings, Model model) {
        return new ManualDetectorConfigurationPanel(INFO_TEXT, NAME);
    }

    @Override
    public SpotDetector<T> getDetector(ImgPlus<T> img, Map<String, Object> settings, Interval interval, int frame) {
        return new SpotDetector<T>(this){

            public List<Spot> getResult() {
                return Collections.emptyList();
            }

            public boolean checkInput() {
                return true;
            }

            public boolean process() {
                return true;
            }

            public String getErrorMessage() {
                return null;
            }

            public long getProcessingTime() {
                return 0L;
            }
        };
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> lSettings = new HashMap<String, Object>();
        lSettings.put("RADIUS", 5.0);
        return lSettings;
    }
}

