/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.detector;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.LabelImageDetectorFactory;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.gui.components.detector.ThresholdDetectorConfigurationPanel;
import java.util.Map;

public class LabelImageDetectorConfigurationPanel
extends ThresholdDetectorConfigurationPanel {
    private static final long serialVersionUID = 1L;

    public LabelImageDetectorConfigurationPanel(Settings settings, Model model) {
        super(settings, model, "<html>This detector creates spots by importing regions from a label image.<p>A label image is an image where the pixel values are integers. Each object in a label image is represented by a single common pixel value (the label) that is unique to the object.<p>This detector reads such an image and create spots from each object. In 2D the contour of a label is imported. In 3D, spherical spots of the same volume that the label are created.<p>The spot quality stores the object area or volume in pixels.</html>", "Label image detector", "https://imagej.net/plugins/trackmate/detectors/trackmate-label-image-detector");
        this.ftfIntensityThreshold.setVisible(false);
        this.btnAutoThreshold.setVisible(false);
        this.lblIntensityThreshold.setVisible(false);
    }

    @Override
    public Map<String, Object> getSettings() {
        Map<String, Object> lSettings = super.getSettings();
        lSettings.remove("INTENSITY_THRESHOLD");
        return lSettings;
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.sliderChannel.setValue((Integer)settings.get("TARGET_CHANNEL"));
        this.chkboxSimplify.setSelected((Boolean)settings.get("SIMPLIFY_CONTOURS"));
    }

    @Override
    protected SpotDetectorFactory<?> getDetectorFactory() {
        return new LabelImageDetectorFactory();
    }
}

