/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard;

import fiji.plugin.trackmate.gui.wizard.AbstractAnimator;
import fiji.plugin.trackmate.util.ImageHelper;
import java.awt.Component;
import java.awt.image.BufferedImage;

public class TransitionAnimator
extends AbstractAnimator {
    private final BufferedImage combined;
    private final int width;
    private final int height;
    private final Direction direction;

    public TransitionAnimator(Component from, Component to, Direction direction, long duration) {
        super(duration);
        this.direction = direction;
        switch (direction.ordinal()) {
            default: {
                this.combined = ImageHelper.combineImages(ImageHelper.captureComponent(to), ImageHelper.captureComponent(from), 0);
                break;
            }
            case 1: {
                this.combined = ImageHelper.combineImages(ImageHelper.captureComponent(from), ImageHelper.captureComponent(to), 0);
                break;
            }
            case 3: {
                this.combined = ImageHelper.combineImages(ImageHelper.captureComponent(to), ImageHelper.captureComponent(from), 1);
                break;
            }
            case 2: {
                this.combined = ImageHelper.combineImages(ImageHelper.captureComponent(from), ImageHelper.captureComponent(to), 1);
            }
        }
        this.width = from.getWidth();
        this.height = from.getHeight();
    }

    public BufferedImage getCurrent(long time) {
        this.setTime(time);
        return this.get(this.ratioComplete());
    }

    public BufferedImage get(double t) {
        int x;
        return this.combined.getSubimage(x, switch (this.direction.ordinal()) {
            default -> {
                x = this.width - (int)Math.round(t * (double)this.width);
                yield 0;
            }
            case 1 -> {
                x = (int)Math.round(t * (double)this.width);
                yield 0;
            }
            case 3 -> {
                x = 0;
                yield this.height - (int)Math.round(t * (double)this.height);
            }
            case 2 -> {
                x = 0;
                yield (int)Math.round(t * (double)this.height);
            }
        }, this.width, this.height);
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

