/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.view.mxGraph;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import java.util.HashMap;
import java.util.Set;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.DefaultWeightedEdge;

public class JGraphXAdapter
extends mxGraph
implements GraphListener<Spot, DefaultWeightedEdge> {
    private final HashMap<Spot, mxCell> vertexToCellMap = new HashMap();
    private final HashMap<DefaultWeightedEdge, mxCell> edgeToCellMap = new HashMap();
    private final HashMap<mxCell, Spot> cellToVertexMap = new HashMap();
    private final HashMap<mxCell, DefaultWeightedEdge> cellToEdgeMap = new HashMap();
    private final Model tmm;

    public JGraphXAdapter(Model tmm) {
        this.tmm = tmm;
        this.insertTrackCollection(tmm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellLabelChanged(Object cell, Object value, boolean autoSize) {
        this.model.beginUpdate();
        try {
            Spot spot = this.cellToVertexMap.get(cell);
            if (null == spot) {
                return;
            }
            String str = (String)value;
            spot.setName(str);
            this.getModel().setValue(cell, (Object)str);
            if (autoSize) {
                this.cellSizeUpdated(cell, false);
            }
        }
        finally {
            this.model.endUpdate();
        }
    }

    public mxCell addJGraphTVertex(Spot vertex) {
        if (this.vertexToCellMap.containsKey(vertex)) {
            return this.vertexToCellMap.get(vertex);
        }
        mxCell cell = null;
        this.getModel().beginUpdate();
        try {
            cell = new mxCell((Object)vertex, new mxGeometry(), "");
            cell.setVertex(true);
            cell.setId(null);
            cell.setValue((Object)vertex.getName());
            this.addCell(cell, this.defaultParent);
            this.vertexToCellMap.put(vertex, cell);
            this.cellToVertexMap.put(cell, vertex);
        }
        finally {
            this.getModel().endUpdate();
        }
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public mxCell addJGraphTEdge(DefaultWeightedEdge edge) {
        if (this.edgeToCellMap.containsKey(edge)) {
            return this.edgeToCellMap.get(edge);
        }
        mxCell cell = null;
        this.getModel().beginUpdate();
        try {
            Spot source = this.tmm.getTrackModel().getEdgeSource(edge);
            Spot target = this.tmm.getTrackModel().getEdgeTarget(edge);
            cell = new mxCell((Object)edge);
            cell.setEdge(true);
            cell.setId(null);
            cell.setValue((Object)String.format("%.1f", this.tmm.getTrackModel().getEdgeWeight(edge)));
            cell.setGeometry(new mxGeometry());
            cell.getGeometry().setRelative(true);
            this.addEdge(cell, this.defaultParent, this.vertexToCellMap.get(source), this.vertexToCellMap.get(target), null);
            this.edgeToCellMap.put(edge, cell);
            this.cellToEdgeMap.put(cell, edge);
        }
        finally {
            this.getModel().endUpdate();
        }
        return cell;
    }

    public void mapEdgeToCell(DefaultWeightedEdge edge, mxCell cell) {
        this.cellToEdgeMap.put(cell, edge);
        this.edgeToCellMap.put(edge, cell);
    }

    public Spot getSpotFor(mxICell cell) {
        return this.cellToVertexMap.get(cell);
    }

    public DefaultWeightedEdge getEdgeFor(mxICell cell) {
        return this.cellToEdgeMap.get(cell);
    }

    public mxCell getCellFor(Spot spot) {
        return this.vertexToCellMap.get(spot);
    }

    public mxCell getCellFor(DefaultWeightedEdge edge) {
        return this.edgeToCellMap.get(edge);
    }

    public Set<mxCell> getVertexCells() {
        return this.cellToVertexMap.keySet();
    }

    public Set<mxCell> getEdgeCells() {
        return this.cellToEdgeMap.keySet();
    }

    public void removeMapping(Spot spot) {
        mxICell cell = (mxICell)this.vertexToCellMap.remove(spot);
        this.cellToVertexMap.remove(cell);
    }

    public void removeMapping(DefaultWeightedEdge edge) {
        mxICell cell = (mxICell)this.edgeToCellMap.remove(edge);
        this.cellToEdgeMap.remove(cell);
    }

    public void vertexAdded(GraphVertexChangeEvent<Spot> e) {
        this.addJGraphTVertex((Spot)e.getVertex());
    }

    public void vertexRemoved(GraphVertexChangeEvent<Spot> e) {
        mxCell cell = this.vertexToCellMap.remove(e.getVertex());
        this.removeCells(new Object[]{cell});
    }

    public void edgeAdded(GraphEdgeChangeEvent<Spot, DefaultWeightedEdge> e) {
        this.addJGraphTEdge((DefaultWeightedEdge)e.getEdge());
    }

    public void edgeRemoved(GraphEdgeChangeEvent<Spot, DefaultWeightedEdge> e) {
        mxICell cell = (mxICell)this.edgeToCellMap.remove(e.getEdge());
        this.removeCells(new Object[]{cell});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTrackCollection(Model lTmm) {
        this.model.beginUpdate();
        try {
            for (Integer trackID : lTmm.getTrackModel().trackIDs(true)) {
                for (Spot vertex : lTmm.getTrackModel().trackSpots(trackID)) {
                    this.addJGraphTVertex(vertex);
                }
                for (DefaultWeightedEdge edge : lTmm.getTrackModel().trackEdges(trackID)) {
                    this.addJGraphTEdge(edge);
                }
            }
        }
        finally {
            this.model.endUpdate();
        }
    }
}

