/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import bunwarpj.BSplineModel;
import bunwarpj.FinalAction;
import bunwarpj.MainDialog;
import bunwarpj.Mask;
import bunwarpj.MiscTools;
import bunwarpj.Param;
import bunwarpj.PointHandler;
import bunwarpj.Transformation;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.util.Stack;

public class bUnwarpJ_
implements PlugIn {
    private ImagePlus sourceImp;
    private ImagePlus targetImp;
    private static int min_scale_deformation = 0;
    private static int max_scale_deformation = 2;
    private static int mode = MainDialog.ACCURATE_MODE;
    private static int maxImageSubsamplingFactor = 0;
    private static double divWeight = 0.0;
    private static double curlWeight = 0.0;
    private static double landmarkWeight = 0.0;
    private static double imageWeight = 1.0;
    private static double consistencyWeight = 10.0;
    private static boolean richOutput = false;
    private static boolean saveTransformation = false;
    private int min_scale_image = 0;
    private static double stopThreshold = 0.01;
    private static boolean debug = false;

    public void run(String commandLine) {
        Runtime.getRuntime().gc();
        ImagePlus[] imageList = this.createImageList();
        if (imageList.length < 2) {
            IJ.error((String)"At least two (8, 16, 32-bit or RGB Color) images are required");
            return;
        }
        MainDialog dialog = new MainDialog((Frame)IJ.getInstance(), imageList, mode, maxImageSubsamplingFactor, min_scale_deformation, max_scale_deformation, divWeight, curlWeight, landmarkWeight, imageWeight, consistencyWeight, stopThreshold, richOutput, saveTransformation);
        dialog.showDialog();
        if (dialog.wasCanceled()) {
            dialog.dispose();
            dialog.restoreAll();
            return;
        }
        dialog.dispose();
        this.sourceImp = imageList[dialog.getNextChoiceIndex()];
        this.targetImp = imageList[dialog.getNextChoiceIndex()];
        mode = dialog.getNextChoiceIndex();
        maxImageSubsamplingFactor = (int)dialog.getNextNumber();
        min_scale_deformation = dialog.getNextChoiceIndex();
        max_scale_deformation = dialog.getNextChoiceIndex();
        divWeight = dialog.getNextNumber();
        curlWeight = dialog.getNextNumber();
        landmarkWeight = dialog.getNextNumber();
        imageWeight = dialog.getNextNumber();
        consistencyWeight = dialog.getNextNumber();
        stopThreshold = dialog.getNextNumber();
        richOutput = dialog.getNextBoolean();
        saveTransformation = dialog.getNextBoolean();
        dialog.setSaveTransformation(saveTransformation);
        int outputLevel = 1;
        boolean showMarquardtOptim = false;
        if (richOutput) {
            ++outputLevel;
            showMarquardtOptim = true;
        }
        FinalAction finalAction = new FinalAction(dialog);
        finalAction.setup(this.sourceImp, this.targetImp, dialog.getSource(), dialog.getTarget(), dialog.getSourcePh(), dialog.getTargetPh(), dialog.getSourceMsk(), dialog.getTargetMsk(), dialog.getSourceAffineMatrix(), dialog.getTargetAffineMatrix(), min_scale_deformation, max_scale_deformation, this.min_scale_image, divWeight, curlWeight, landmarkWeight, imageWeight, consistencyWeight, stopThreshold, outputLevel, showMarquardtOptim, mode);
        dialog.setFinalActionLaunched(true);
        dialog.setToolbarAllUp();
        dialog.repaintToolbar();
        Thread fa = finalAction.getThread();
        fa.start();
        try {
            fa.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static Transformation computeTransformationBatch(ImagePlus targetImp, ImagePlus sourceImp, ImageProcessor targetMskIP, ImageProcessor sourceMskIP, int mode, int img_subsamp_fact, int min_scale_deformation, int max_scale_deformation, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold) {
        int imagePyramidDepth = max_scale_deformation - min_scale_deformation + 1;
        boolean min_scale_image = false;
        int outputLevel = -1;
        boolean showMarquardtOptim = false;
        BSplineModel target = new BSplineModel(targetImp.getProcessor(), true, (int)Math.pow(2.0, img_subsamp_fact));
        target.setPyramidDepth(imagePyramidDepth + 0);
        target.startPyramids();
        Mask targetMsk = targetMskIP != null ? new Mask(targetMskIP, true) : new Mask(targetImp.getProcessor(), false);
        PointHandler targetPh = null;
        boolean bIsReverse = true;
        BSplineModel source = new BSplineModel(sourceImp.getProcessor(), bIsReverse, (int)Math.pow(2.0, img_subsamp_fact));
        source.setPyramidDepth(imagePyramidDepth + 0);
        source.startPyramids();
        Mask sourceMsk = sourceMskIP != null ? new Mask(sourceMskIP, true) : new Mask(sourceImp.getProcessor(), false);
        PointHandler sourcePh = null;
        Stack<Point> sourceStack = new Stack<Point>();
        Stack<Point> targetStack = new Stack<Point>();
        MiscTools.loadPointRoiAsLandmarks(sourceImp, targetImp, sourceStack, targetStack);
        sourcePh = new PointHandler(sourceImp);
        targetPh = new PointHandler(targetImp);
        while (!sourceStack.empty() && !targetStack.empty()) {
            Point sourcePoint = sourceStack.pop();
            Point targetPoint = targetStack.pop();
            sourcePh.addPoint(sourcePoint.x, sourcePoint.y);
            targetPh.addPoint(targetPoint.x, targetPoint.y);
        }
        double[][] sourceAffineMatrix = null;
        double[][] targetAffineMatrix = null;
        try {
            source.getThread().join();
            target.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception " + e));
        }
        ImagePlus[] output_ip = new ImagePlus[]{null, null};
        MainDialog dialog = null;
        ImageProcessor originalSourceIP = sourceImp.getProcessor();
        ImageProcessor originalTargetIP = targetImp.getProcessor();
        Transformation warp = new Transformation(sourceImp, targetImp, source, target, sourcePh, targetPh, sourceMsk, targetMsk, sourceAffineMatrix, targetAffineMatrix, min_scale_deformation, max_scale_deformation, 0, divWeight, curlWeight, landmarkWeight, imageWeight, consistencyWeight, stopThreshold, -1, false, mode, null, null, output_ip[0], output_ip[1], dialog, originalSourceIP, originalTargetIP);
        IJ.log((String)"\nRegistering...\n");
        long start = System.currentTimeMillis();
        if (mode == MainDialog.MONO_MODE) {
            warp.doUnidirectionalRegistration();
        } else {
            warp.doBidirectionalRegistration();
        }
        long stop = System.currentTimeMillis();
        IJ.log((String)("bUnwarpJ is done! Registration time: " + (stop - start) + "ms"));
        return warp;
    }

    public static Transformation computeTransformationBatch(ImagePlus targetImp, ImagePlus sourceImp, ImageProcessor targetMskIP, ImageProcessor sourceMskIP, Param parameter) {
        if (targetImp == null || sourceImp == null || parameter == null) {
            IJ.error((String)"Missing parameters to compute transformation!");
            return null;
        }
        if (debug) {
            IJ.log((String)("\n--- bUnwarpJ parameters ---\n\nSource image: " + sourceImp.getTitle() + "\nTarget image: " + targetImp.getTitle() + "\n" + parameter.toString() + "\n"));
        }
        int imagePyramidDepth = parameter.max_scale_deformation - parameter.min_scale_deformation + 1;
        boolean min_scale_image = false;
        int outputLevel = -1;
        boolean showMarquardtOptim = false;
        BSplineModel target = new BSplineModel(targetImp.getProcessor(), true, (int)Math.pow(2.0, parameter.img_subsamp_fact));
        target.setPyramidDepth(imagePyramidDepth + 0);
        target.startPyramids();
        Mask targetMsk = targetMskIP != null ? new Mask(targetMskIP, true) : new Mask(targetImp.getProcessor(), false);
        PointHandler targetPh = null;
        boolean bIsReverse = true;
        BSplineModel source = new BSplineModel(sourceImp.getProcessor(), bIsReverse, (int)Math.pow(2.0, parameter.img_subsamp_fact));
        source.setPyramidDepth(imagePyramidDepth + 0);
        source.startPyramids();
        Mask sourceMsk = sourceMskIP != null ? new Mask(sourceMskIP, true) : new Mask(sourceImp.getProcessor(), false);
        PointHandler sourcePh = null;
        Stack<Point> sourceStack = new Stack<Point>();
        Stack<Point> targetStack = new Stack<Point>();
        MiscTools.loadPointRoiAsLandmarks(sourceImp, targetImp, sourceStack, targetStack);
        sourcePh = new PointHandler(sourceImp);
        targetPh = new PointHandler(targetImp);
        while (!sourceStack.empty() && !targetStack.empty()) {
            Point sourcePoint = sourceStack.pop();
            Point targetPoint = targetStack.pop();
            sourcePh.addPoint(sourcePoint.x, sourcePoint.y);
            targetPh.addPoint(targetPoint.x, targetPoint.y);
        }
        double[][] sourceAffineMatrix = null;
        double[][] targetAffineMatrix = null;
        try {
            source.getThread().join();
            target.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception " + e));
        }
        ImagePlus[] output_ip = new ImagePlus[]{null, null};
        MainDialog dialog = null;
        ImageProcessor originalSourceIP = sourceImp.getProcessor();
        ImageProcessor originalTargetIP = targetImp.getProcessor();
        Transformation warp = new Transformation(sourceImp, targetImp, source, target, sourcePh, targetPh, sourceMsk, targetMsk, sourceAffineMatrix, targetAffineMatrix, parameter.min_scale_deformation, parameter.max_scale_deformation, 0, parameter.divWeight, parameter.curlWeight, parameter.landmarkWeight, parameter.imageWeight, parameter.consistencyWeight, parameter.stopThreshold, -1, false, parameter.mode, null, null, output_ip[0], output_ip[1], dialog, originalSourceIP, originalTargetIP);
        warp.setAnisotropyCorrection(parameter.getAnisotropyCorrection());
        warp.setScaleCorrection(parameter.getScaleCorrection());
        warp.setShearCorrection(parameter.getShearCorrection());
        IJ.log((String)"\nRegistering...\n");
        long start = System.currentTimeMillis();
        if (parameter.mode == MainDialog.MONO_MODE) {
            warp.doUnidirectionalRegistration();
        } else {
            warp.doBidirectionalRegistration();
        }
        long stop = System.currentTimeMillis();
        IJ.log((String)("bUnwarpJ is done! Registration time: " + (stop - start) + "ms"));
        return warp;
    }

    public static Transformation computeTransformationBatch(ImagePlus targetImp, ImagePlus sourceImp, ImageProcessor targetMskIP, ImageProcessor sourceMskIP, AffineTransform targetAffineTransf, AffineTransform sourceAffineTransf, Param parameter) {
        Object targetAffineMatrix;
        Object sourceAffineMatrix;
        if (targetImp == null || sourceImp == null || parameter == null) {
            IJ.error((String)"Missing parameters to compute transformation!");
            return null;
        }
        int imagePyramidDepth = parameter.max_scale_deformation - parameter.min_scale_deformation + 1;
        boolean min_scale_image = false;
        int outputLevel = -1;
        boolean showMarquardtOptim = false;
        BSplineModel target = new BSplineModel(targetImp.getProcessor(), true, (int)Math.pow(2.0, parameter.img_subsamp_fact));
        target.setPyramidDepth(imagePyramidDepth + 0);
        target.startPyramids();
        Mask targetMsk = targetMskIP != null ? new Mask(targetMskIP, true) : new Mask(targetImp.getProcessor(), false);
        PointHandler targetPh = null;
        boolean bIsReverse = true;
        BSplineModel source = new BSplineModel(sourceImp.getProcessor(), bIsReverse, (int)Math.pow(2.0, parameter.img_subsamp_fact));
        source.setPyramidDepth(imagePyramidDepth + 0);
        source.startPyramids();
        Mask sourceMsk = sourceMskIP != null ? new Mask(sourceMskIP, true) : new Mask(sourceImp.getProcessor(), false);
        PointHandler sourcePh = null;
        Stack<Point> sourceStack = new Stack<Point>();
        Stack<Point> targetStack = new Stack<Point>();
        MiscTools.loadPointRoiAsLandmarks(sourceImp, targetImp, sourceStack, targetStack);
        sourcePh = new PointHandler(sourceImp);
        targetPh = new PointHandler(targetImp);
        while (!sourceStack.empty() && !targetStack.empty()) {
            Point sourcePoint = sourceStack.pop();
            Point targetPoint = targetStack.pop();
            sourcePh.addPoint(sourcePoint.x, sourcePoint.y);
            targetPh.addPoint(targetPoint.x, targetPoint.y);
        }
        try {
            source.getThread().join();
            target.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception " + e));
        }
        ImagePlus[] output_ip = new ImagePlus[]{null, null};
        MainDialog dialog = null;
        ImageProcessor originalSourceIP = sourceImp.getProcessor();
        ImageProcessor originalTargetIP = targetImp.getProcessor();
        if (sourceAffineTransf != null && targetAffineTransf != null) {
            double[] flatMat = new double[6];
            sourceAffineTransf.getMatrix(flatMat);
            sourceAffineMatrix = new double[][]{{flatMat[0], flatMat[2], flatMat[4]}, {flatMat[1], flatMat[3], flatMat[5]}};
            targetAffineTransf.getMatrix(flatMat);
            targetAffineMatrix = new double[][]{{flatMat[0], flatMat[2], flatMat[4]}, {flatMat[1], flatMat[3], flatMat[5]}};
        } else {
            sourceAffineMatrix = null;
            targetAffineMatrix = null;
        }
        Transformation warp = new Transformation(sourceImp, targetImp, source, target, sourcePh, targetPh, sourceMsk, targetMsk, (double[][])sourceAffineMatrix, (double[][])targetAffineMatrix, parameter.min_scale_deformation, parameter.max_scale_deformation, 0, parameter.divWeight, parameter.curlWeight, parameter.landmarkWeight, parameter.imageWeight, parameter.consistencyWeight, parameter.stopThreshold, -1, false, parameter.mode, null, null, output_ip[0], output_ip[1], dialog, originalSourceIP, originalTargetIP);
        IJ.log((String)"\nRegistering...\n");
        long start = System.currentTimeMillis();
        if (parameter.mode == MainDialog.MONO_MODE) {
            warp.doUnidirectionalRegistration();
        } else {
            warp.doBidirectionalRegistration();
        }
        long stop = System.currentTimeMillis();
        IJ.log((String)("bUnwarpJ is done! Registration time: " + (stop - start) + "ms"));
        return warp;
    }

    public static Transformation computeTransformationBatch(int sourceWidth, int sourceHeight, int targetWidth, int targetHeight, Stack<Point> sourcePoints, Stack<Point> targetPoints, Param parameter) {
        if (sourcePoints == null || targetPoints == null || parameter == null) {
            IJ.error((String)"Missing parameters to compute transformation!");
            return null;
        }
        int imagePyramidDepth = parameter.max_scale_deformation - parameter.min_scale_deformation + 1;
        boolean min_scale_image = false;
        int outputLevel = -1;
        boolean showMarquardtOptim = false;
        BSplineModel target = new BSplineModel(targetWidth, targetHeight, (int)Math.pow(2.0, parameter.img_subsamp_fact));
        target.setPyramidDepth(imagePyramidDepth + 0);
        target.startPyramids();
        Mask targetMsk = new Mask(targetWidth, targetHeight);
        BSplineModel source = new BSplineModel(sourceWidth, sourceHeight, (int)Math.pow(2.0, parameter.img_subsamp_fact));
        source.setPyramidDepth(imagePyramidDepth + 0);
        source.startPyramids();
        Mask sourceMsk = new Mask(sourceWidth, sourceHeight);
        PointHandler sourcePh = new PointHandler(sourceWidth, sourceHeight);
        PointHandler targetPh = new PointHandler(targetWidth, targetHeight);
        while (!sourcePoints.empty() && !targetPoints.empty()) {
            Point sourcePoint = sourcePoints.pop();
            Point targetPoint = targetPoints.pop();
            sourcePh.addPoint(sourcePoint.x, sourcePoint.y);
            targetPh.addPoint(targetPoint.x, targetPoint.y);
        }
        double[][] sourceAffineMatrix = null;
        double[][] targetAffineMatrix = null;
        try {
            source.getThread().join();
            target.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception " + e));
        }
        ImagePlus[] output_ip = new ImagePlus[]{null, null};
        MainDialog dialog = null;
        ImageProcessor originalSourceIP = null;
        ImageProcessor originalTargetIP = null;
        Transformation warp = new Transformation(null, null, source, target, sourcePh, targetPh, sourceMsk, targetMsk, sourceAffineMatrix, targetAffineMatrix, parameter.min_scale_deformation, parameter.max_scale_deformation, 0, parameter.divWeight, parameter.curlWeight, parameter.landmarkWeight, parameter.imageWeight, parameter.consistencyWeight, parameter.stopThreshold, -1, false, parameter.mode, null, null, output_ip[0], output_ip[1], dialog, originalSourceIP, originalTargetIP);
        IJ.log((String)"\nRegistering...\n");
        long start = System.currentTimeMillis();
        if (parameter.mode == MainDialog.MONO_MODE) {
            warp.doUnidirectionalRegistration();
        } else {
            warp.doBidirectionalRegistration();
        }
        long stop = System.currentTimeMillis();
        IJ.log((String)("bUnwarpJ is done! Registration time: " + (stop - start) + "ms"));
        return warp;
    }

    public static ImagePlus[] alignImagesBatch(ImagePlus targetImp, ImagePlus sourceImp, ImageProcessor targetMskIP, ImageProcessor sourceMskIP, int mode, int img_subsamp_fact, int min_scale_deformation, int max_scale_deformation, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold) {
        Transformation warp = bUnwarpJ_.computeTransformationBatch(targetImp, sourceImp, targetMskIP, sourceMskIP, mode, img_subsamp_fact, min_scale_deformation, max_scale_deformation, divWeight, curlWeight, landmarkWeight, imageWeight, consistencyWeight, stopThreshold);
        ImagePlus[] output_ip = new ImagePlus[]{warp.getDirectResults(), warp.getInverseResults()};
        return output_ip;
    }

    public static ImagePlus[] alignImagesBatch(ImagePlus targetImp, ImagePlus sourceImp, ImageProcessor targetMskIP, ImageProcessor sourceMskIP, Param parameter) {
        Transformation warp = bUnwarpJ_.computeTransformationBatch(targetImp, sourceImp, targetMskIP, sourceMskIP, parameter);
        ImagePlus[] output_ip = new ImagePlus[]{warp.getDirectResults(), warp.getInverseResults()};
        return output_ip;
    }

    public static ImagePlus[] alignImagesBatch(ImagePlus targetImp, ImagePlus sourceImp, ImageProcessor targetMskIP, ImageProcessor sourceMskIP, int mode, int img_subsamp_fact, int min_scale_deformation, int max_scale_deformation, double divWeight, double curlWeight, double landmarkWeight, double imageWeight, double consistencyWeight, double stopThreshold, double xScale, double yScale) {
        ImageProcessor fullTargetIP = targetImp.getProcessor();
        fullTargetIP.setInterpolate(true);
        ImageProcessor scaledTargetIP = fullTargetIP.resize((int)(xScale * (double)targetImp.getWidth()), (int)(yScale * (double)targetImp.getHeight()));
        ImageProcessor fullSourceIP = sourceImp.getProcessor();
        fullSourceIP.setInterpolate(true);
        ImageProcessor scaledSourceIP = fullSourceIP.resize((int)(xScale * (double)sourceImp.getWidth()), (int)(yScale * (double)sourceImp.getHeight()));
        int imagePyramidDepth = max_scale_deformation - min_scale_deformation + 1;
        boolean min_scale_image = false;
        int outputLevel = -1;
        boolean showMarquardtOptim = false;
        BSplineModel target = new BSplineModel(scaledTargetIP, true, (int)Math.pow(2.0, img_subsamp_fact));
        target.setPyramidDepth(imagePyramidDepth + 0);
        target.startPyramids();
        Mask targetMsk = targetMskIP != null ? new Mask(targetMskIP, true) : new Mask(targetImp.getProcessor(), false);
        PointHandler targetPh = null;
        boolean bIsReverse = true;
        BSplineModel source = new BSplineModel(scaledSourceIP, bIsReverse, (int)Math.pow(2.0, img_subsamp_fact));
        source.setPyramidDepth(imagePyramidDepth + 0);
        source.startPyramids();
        Mask sourceMsk = sourceMskIP != null ? new Mask(sourceMskIP, true) : new Mask(sourceImp.getProcessor(), false);
        PointHandler sourcePh = null;
        if (landmarkWeight != 0.0) {
            Stack<Point> sourceStack = new Stack<Point>();
            Stack<Point> targetStack = new Stack<Point>();
            MiscTools.loadPointRoiAsLandmarks(sourceImp, targetImp, sourceStack, targetStack);
            sourcePh = new PointHandler(sourceImp);
            targetPh = new PointHandler(targetImp);
            while (!sourceStack.empty() && !targetStack.empty()) {
                Point sourcePoint = sourceStack.pop();
                Point targetPoint = targetStack.pop();
                sourcePh.addPoint(sourcePoint.x, sourcePoint.y);
                targetPh.addPoint(targetPoint.x, targetPoint.y);
            }
        }
        double[][] sourceAffineMatrix = null;
        double[][] targetAffineMatrix = null;
        try {
            source.getThread().join();
            target.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception " + e));
        }
        ImagePlus[] output_ip = new ImagePlus[]{new ImagePlus(), new ImagePlus()};
        MainDialog dialog = null;
        ImageProcessor originalSourceIP = sourceImp.getProcessor();
        ImageProcessor originalTargetIP = targetImp.getProcessor();
        Transformation warp = new Transformation(sourceImp, targetImp, source, target, sourcePh, targetPh, sourceMsk, targetMsk, sourceAffineMatrix, targetAffineMatrix, min_scale_deformation, max_scale_deformation, 0, divWeight, curlWeight, landmarkWeight, imageWeight, consistencyWeight, stopThreshold, -1, false, mode, null, null, output_ip[0], output_ip[1], dialog, originalSourceIP, originalTargetIP);
        IJ.log((String)"\nRegistering...\n");
        long start = System.currentTimeMillis();
        if (mode == MainDialog.MONO_MODE) {
            warp.doUnidirectionalRegistration();
        } else {
            warp.doBidirectionalRegistration();
        }
        long stop = System.currentTimeMillis();
        IJ.log((String)("bUnwarpJ is done! Registration time: " + (stop - start) + "ms"));
        int intervals = warp.getIntervals();
        double[][] cx_direct = warp.getDirectDeformationCoefficientsX();
        double[][] cy_direct = warp.getDirectDeformationCoefficientsY();
        MiscTools.adaptCoefficients(1.0 / xScale, 1.0 / yScale, intervals, cx_direct, cy_direct);
        BSplineModel fullSource = null;
        fullSource = new BSplineModel(fullSourceIP, false, 1);
        fullSource.setPyramidDepth(0);
        fullSource.startPyramids();
        MiscTools.applyTransformationToSourceMT(sourceImp, targetImp, fullSource, intervals, cx_direct, cy_direct);
        output_ip[0] = sourceImp;
        if (mode != MainDialog.MONO_MODE) {
            double[][] cx_inverse = warp.getInverseDeformationCoefficientsX();
            double[][] cy_inverse = warp.getInverseDeformationCoefficientsY();
            MiscTools.adaptCoefficients(1.0 / xScale, 1.0 / yScale, intervals, cx_inverse, cy_inverse);
            BSplineModel fullTarget = null;
            fullTarget = new BSplineModel(fullTargetIP, false, 1);
            fullTarget.setPyramidDepth(0);
            fullTarget.startPyramids();
            MiscTools.applyTransformationToSourceMT(targetImp, sourceImp, fullTarget, intervals, cx_inverse, cy_inverse);
            output_ip[1] = targetImp;
        }
        return output_ip;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            bUnwarpJ_.dumpSyntax();
            System.exit(1);
        } else if (args[0].equals("-help")) {
            bUnwarpJ_.dumpSyntax();
        } else if (args[0].equals("-align")) {
            bUnwarpJ_.alignImagesCommandLine(args);
        } else if (args[0].equals("-elastic_transform")) {
            bUnwarpJ_.elasticTransformImageCommandLine(args);
        } else if (args[0].equals("-raw_transform")) {
            bUnwarpJ_.rawTransformImageCommandLine(args);
        } else if (args[0].equals("-compare_elastic")) {
            bUnwarpJ_.compareElasticTransformationsCommandLine(args);
        } else if (args[0].equals("-compare_elastic_raw")) {
            bUnwarpJ_.compareElasticRawTransformationsCommandLine(args);
        } else if (args[0].equals("-compare_raw")) {
            bUnwarpJ_.compareRawTransformationsCommandLine(args);
        } else if (args[0].equals("-convert_to_raw")) {
            bUnwarpJ_.convertToRawTransformationCommandLine(args);
        } else if (args[0].equals("-compose_elastic")) {
            bUnwarpJ_.composeElasticTransformationsCommandLine(args);
        } else if (args[0].equals("-compose_raw")) {
            bUnwarpJ_.composeRawTransformationsCommandLine(args);
        } else if (args[0].equals("-compose_raw_elastic")) {
            bUnwarpJ_.composeRawElasticTransformationsCommandLine(args);
        } else if (args[0].equals("-adapt_transform")) {
            bUnwarpJ_.adaptCoefficientsCommandLine(args);
        } else {
            bUnwarpJ_.dumpSyntax();
        }
        System.exit(0);
    }

    private static void alignImagesCommandLine(String[] args) {
        if (args.length < 14) {
            bUnwarpJ_.dumpSyntax();
            System.exit(0);
        }
        String fn_target = args[1];
        String fn_target_mask = args[2];
        String fn_source = args[3];
        String fn_source_mask = args[4];
        int min_scale_deformation = new Integer(args[5]);
        int max_scale_deformation = new Integer(args[6]);
        int max_subsamp_fact = new Integer(args[7]);
        double divWeight = new Double(args[8]);
        double curlWeight = new Double(args[9]);
        double imageWeight = new Double(args[10]);
        int accurate_mode = MainDialog.ACCURATE_MODE;
        boolean save_transformation = false;
        double consistencyWeight = new Double(args[11]);
        String fn_out_1 = args[12];
        String fn_out_2 = args[13];
        double landmarkWeight = 0.0;
        String fn_landmark = "";
        String fn_affine_1 = "";
        String fn_affine_2 = "";
        if (args.length == 17) {
            if (args[14].equals("-landmark")) {
                landmarkWeight = new Double(args[15]);
                fn_landmark = args[16];
            } else if (args[14].equals("-affine")) {
                fn_affine_1 = args[15];
                fn_affine_2 = args[16];
            }
        } else if (args.length == 15 || args.length == 16) {
            if (args[14].equalsIgnoreCase("-mono")) {
                accurate_mode = MainDialog.MONO_MODE;
                fn_out_2 = "NULL (Mono mode)";
            } else if (args[14].equalsIgnoreCase("-save_transformation")) {
                save_transformation = true;
            } else {
                bUnwarpJ_.dumpSyntax();
                System.exit(0);
            }
            if (args.length == 16) {
                if (args[15].equalsIgnoreCase("-mono")) {
                    accurate_mode = MainDialog.MONO_MODE;
                    fn_out_2 = "NULL (Mono mode)";
                } else if (args[15].equalsIgnoreCase("-save_transformation")) {
                    save_transformation = true;
                } else {
                    bUnwarpJ_.dumpSyntax();
                    System.exit(0);
                }
            }
        }
        IJ.log((String)("Target image           : " + fn_target));
        IJ.log((String)("Target mask            : " + fn_target_mask));
        IJ.log((String)("Source image           : " + fn_source));
        IJ.log((String)("Source mask            : " + fn_source_mask));
        IJ.log((String)("Min. Scale Deformation : " + min_scale_deformation));
        IJ.log((String)("Max. Scale Deformation : " + max_scale_deformation));
        IJ.log((String)("Max. Subsampling factor: " + max_subsamp_fact));
        IJ.log((String)("Div. Weight            : " + divWeight));
        IJ.log((String)("Curl Weight            : " + curlWeight));
        IJ.log((String)("Image Weight           : " + imageWeight));
        IJ.log((String)("Consistency Weight     : " + consistencyWeight));
        IJ.log((String)("Output 1               : " + fn_out_1));
        IJ.log((String)("Output 2               : " + fn_out_2));
        IJ.log((String)("Landmark Weight        : " + landmarkWeight));
        IJ.log((String)("Landmark file          : " + fn_landmark));
        IJ.log((String)("Affine matrix file 1   : " + fn_affine_1));
        IJ.log((String)("Affine matrix file 2   : " + fn_affine_2));
        String sMode = accurate_mode == MainDialog.MONO_MODE ? "Mono" : "Accurate";
        IJ.log((String)("Registration mode      : " + sMode));
        int imagePyramidDepth = max_scale_deformation - min_scale_deformation + 1;
        int min_scale_image = 0;
        double stopThreshold = 0.01;
        int outputLevel = -1;
        boolean showMarquardtOptim = false;
        String fn_tnf_1 = "";
        int dot = fn_out_1.lastIndexOf(46);
        fn_tnf_1 = dot == -1 ? fn_out_1 + "_transf.txt" : fn_out_1.substring(0, dot) + "_transf.txt";
        String fn_tnf_2 = "";
        dot = fn_out_2.lastIndexOf(46);
        fn_tnf_2 = dot == -1 ? fn_out_2 + "_transf.txt" : fn_out_2.substring(0, dot) + "_transf.txt";
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        BSplineModel target = new BSplineModel(targetImp.getProcessor(), true, (int)Math.pow(2.0, max_subsamp_fact));
        target.setPyramidDepth(imagePyramidDepth + min_scale_image);
        target.startPyramids();
        Mask targetMsk = new Mask(targetImp.getProcessor(), false);
        if (!fn_target_mask.equalsIgnoreCase(new String("NULL"))) {
            targetMsk.readFile(fn_target_mask);
        }
        PointHandler targetPh = null;
        boolean bIsReverse = true;
        ImagePlus sourceImp = opener.openImage(fn_source);
        BSplineModel source = new BSplineModel(sourceImp.getProcessor(), bIsReverse, (int)Math.pow(2.0, max_subsamp_fact));
        source.setPyramidDepth(imagePyramidDepth + min_scale_image);
        source.startPyramids();
        Mask sourceMsk = new Mask(sourceImp.getProcessor(), false);
        if (!fn_source_mask.equalsIgnoreCase(new String("NULL"))) {
            sourceMsk.readFile(fn_source_mask);
        }
        PointHandler sourcePh = null;
        if (!fn_landmark.equals("")) {
            Stack<Point> sourceStack = new Stack<Point>();
            Stack<Point> targetStack = new Stack<Point>();
            MiscTools.loadPoints(fn_landmark, sourceStack, targetStack);
            sourcePh = new PointHandler(sourceImp);
            targetPh = new PointHandler(targetImp);
            while (!sourceStack.empty() && !targetStack.empty()) {
                Point sourcePoint = sourceStack.pop();
                Point targetPoint = targetStack.pop();
                sourcePh.addPoint(sourcePoint.x, sourcePoint.y);
                targetPh.addPoint(targetPoint.x, targetPoint.y);
            }
        }
        double[][] sourceAffineMatrix = null;
        if (!fn_affine_1.equals("") && !fn_affine_1.equalsIgnoreCase(new String("NULL"))) {
            sourceAffineMatrix = new double[2][3];
            MiscTools.loadAffineMatrix(fn_affine_1, sourceAffineMatrix);
        }
        double[][] targetAffineMatrix = null;
        if (!fn_affine_2.equals("") && !fn_affine_2.equalsIgnoreCase(new String("NULL"))) {
            targetAffineMatrix = new double[2][3];
            MiscTools.loadAffineMatrix(fn_affine_2, targetAffineMatrix);
        }
        try {
            source.getThread().join();
            target.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception " + e));
        }
        ImagePlus output_ip_1 = null;
        ImagePlus output_ip_2 = null;
        MainDialog dialog = null;
        ImageProcessor originalSourceIP = sourceImp.getProcessor();
        ImageProcessor originalTargetIP = targetImp.getProcessor();
        Transformation warp = new Transformation(sourceImp, targetImp, source, target, sourcePh, targetPh, sourceMsk, targetMsk, sourceAffineMatrix, targetAffineMatrix, min_scale_deformation, max_scale_deformation, min_scale_image, divWeight, curlWeight, landmarkWeight, imageWeight, consistencyWeight, stopThreshold, outputLevel, showMarquardtOptim, accurate_mode, fn_tnf_1, fn_tnf_2, output_ip_1, output_ip_2, dialog, originalSourceIP, originalTargetIP);
        IJ.log((String)"\nRegistering...\n");
        long start = System.currentTimeMillis();
        if (accurate_mode == MainDialog.MONO_MODE) {
            warp.doUnidirectionalRegistration();
        } else {
            warp.doBidirectionalRegistration();
        }
        if (save_transformation) {
            IJ.log((String)("Saving direct transformation as " + fn_tnf_1 + "..."));
            warp.saveDirectTransformation();
            if (accurate_mode != MainDialog.MONO_MODE) {
                IJ.log((String)("Saving inverse transformation as " + fn_tnf_2 + "..."));
                warp.saveInverseTransformation();
            }
        }
        long stop = System.currentTimeMillis();
        IJ.log((String)("Registration time: " + (stop - start) + "ms"));
        output_ip_1 = warp.getDirectResults();
        output_ip_1.getStack().deleteLastSlice();
        output_ip_1.getStack().deleteLastSlice();
        FileSaver fs = new FileSaver(output_ip_1);
        fs.saveAsTiff(fn_out_1);
        if (accurate_mode != MainDialog.MONO_MODE) {
            output_ip_2 = warp.getInverseResults();
            output_ip_2.getStack().deleteLastSlice();
            output_ip_2.getStack().deleteLastSlice();
            fs = new FileSaver(output_ip_2);
            fs.saveAsTiff(fn_out_2);
        }
    }

    private ImagePlus[] createImageList() {
        int[] windowList = WindowManager.getIDList();
        Stack<ImagePlus> stack = new Stack<ImagePlus>();
        for (int k = 0; windowList != null && k < windowList.length; ++k) {
            ImagePlus imp = WindowManager.getImage((int)windowList[k]);
            int inputType = imp.getType();
            if (imp.getStackSize() != 1 && inputType != 0 && inputType != 1 && inputType != 2 && inputType != 4) continue;
            stack.push(imp);
        }
        ImagePlus[] imageList = new ImagePlus[stack.size()];
        int k = 0;
        while (!stack.isEmpty()) {
            imageList[k++] = (ImagePlus)stack.pop();
        }
        return imageList;
    }

    private static void dumpSyntax() {
        IJ.log((String)"Purpose: Consistent and elastic registration of two images.");
        IJ.log((String)" ");
        IJ.log((String)"Usage: bUnwarpj_ ");
        IJ.log((String)"  -help                       : SHOW THIS MESSAGE");
        IJ.log((String)"");
        IJ.log((String)"  -align                      : ALIGN TWO IMAGES");
        IJ.log((String)"          target_image        : In any image format");
        IJ.log((String)"          target_mask         : In any image format");
        IJ.log((String)"          source_image        : In any image format");
        IJ.log((String)"          source_mask         : In any image format");
        IJ.log((String)"          min_scale_def       : Scale of the coarsest deformation");
        IJ.log((String)"                                0 is the coarsest possible");
        IJ.log((String)"          max_scale_def       : Scale of the finest deformation");
        IJ.log((String)"          max_subsamp_fact    : Maximum subsampling factor (power of 2: [0, 1, 2 ... 7]");
        IJ.log((String)"          Div_weight          : Weight of the divergence term");
        IJ.log((String)"          Curl_weight         : Weight of the curl term");
        IJ.log((String)"          Image_weight        : Weight of the image term");
        IJ.log((String)"          Consistency_weight  : Weight of the deformation consistency");
        IJ.log((String)"          Output image 1      : Output result 1 in TIFF");
        IJ.log((String)"          Output image 2      : Output result 2 in TIFF");
        IJ.log((String)"          Optional parameters :");
        IJ.log((String)"             -landmarks        ");
        IJ.log((String)"                   Landmark_weight  : Weight of the landmarks");
        IJ.log((String)"                   Landmark_file    : Landmark file");
        IJ.log((String)"             OR -affine        ");
        IJ.log((String)"                   Affine_file_1    : Initial source affine matrix transformation");
        IJ.log((String)"                   Affine_file_2    : Initial target affine matrix transformation");
        IJ.log((String)"             OR -mono    : Unidirectional registration (source to target)");
        IJ.log((String)"             OR -save_transformation    : Save calculated transformation to file");
        IJ.log((String)"");
        IJ.log((String)"  -elastic_transform          : TRANSFORM A SOURCE IMAGE WITH A GIVEN ELASTIC DEFORMATION");
        IJ.log((String)"          target_image        : In any image format");
        IJ.log((String)"          source_image        : In any image format");
        IJ.log((String)"          transformation_file : As saved by bUnwarpJ in elastic format");
        IJ.log((String)"          Output image        : Output result in TIFF");
        IJ.log((String)"");
        IJ.log((String)"  -raw_transform              : TRANSFORM A SOURCE IMAGE WITH A GIVEN RAW DEFORMATION");
        IJ.log((String)"          target_image        : In any image format");
        IJ.log((String)"          source_image        : In any image format");
        IJ.log((String)"          transformation_file : As saved by bUnwarpJ in raw format");
        IJ.log((String)"          Output image        : Output result in TIFF");
        IJ.log((String)"");
        IJ.log((String)"  -compare_elastic                   : COMPARE 2 OPPOSITE ELASTIC DEFORMATIONS (BY WARPING INDEX)");
        IJ.log((String)"          target_image               : In any image format");
        IJ.log((String)"          source_image               : In any image format");
        IJ.log((String)"          target_transformation_file : As saved by bUnwarpJ");
        IJ.log((String)"          source_transformation_file : As saved by bUnwarpJ");
        IJ.log((String)"");
        IJ.log((String)"  -compare_elastic_raw                : COMPARE AN ELASTIC DEFORMATION WITH A RAW DEFORMATION (BY WARPING INDEX)");
        IJ.log((String)"          target_image                : In any image format");
        IJ.log((String)"          source_image                : In any image format");
        IJ.log((String)"          Elastic Transformation File : As saved by bUnwarpJ in elastic format");
        IJ.log((String)"          Raw Transformation File     : As saved by bUnwarpJ in raw format");
        IJ.log((String)"");
        IJ.log((String)"  -compare_raw                       : COMPARE 2 ELASTIC DEFORMATIONS (BY WARPING INDEX)");
        IJ.log((String)"          target_image               : In any image format");
        IJ.log((String)"          source_image               : In any image format");
        IJ.log((String)"          Raw Transformation File 1  : As saved by bUnwarpJ in raw format");
        IJ.log((String)"          Raw Transformation File 2  : As saved by bUnwarpJ in raw format");
        IJ.log((String)"");
        IJ.log((String)"  -convert_to_raw                           : CONVERT AN ELASTIC DEFORMATION INTO RAW FORMAT");
        IJ.log((String)"          target_image                      : In any image format");
        IJ.log((String)"          source_image                      : In any image format");
        IJ.log((String)"          Input Elastic Transformation File : As saved by bUnwarpJ in elastic format");
        IJ.log((String)"          Output Raw Transformation File    : As saved by bUnwarpJ in raw format");
        IJ.log((String)"");
        IJ.log((String)"  -compose_elastic                          : COMPOSE TWO ELASTIC DEFORMATIONS");
        IJ.log((String)"          target_image                      : In any image format");
        IJ.log((String)"          source_image                      : In any image format");
        IJ.log((String)"          Elastic Transformation File 1     : As saved by bUnwarpJ in elastic format");
        IJ.log((String)"          Elastic Transformation File 2     : As saved by bUnwarpJ in elastic format");
        IJ.log((String)"          Output Raw Transformation File    : As saved by bUnwarpJ in raw format");
        IJ.log((String)"");
        IJ.log((String)"  -compose_raw                              : COMPOSE TWO RAW DEFORMATIONS");
        IJ.log((String)"          target_image                      : In any image format");
        IJ.log((String)"          source_image                      : In any image format");
        IJ.log((String)"          Raw Transformation File 1         : As saved by bUnwarpJ in raw format");
        IJ.log((String)"          Raw Transformation File 2         : As saved by bUnwarpJ in raw format");
        IJ.log((String)"          Output Raw Transformation File    : As saved by bUnwarpJ in raw format");
        IJ.log((String)"");
        IJ.log((String)"  -compose_raw_elastic                      : COMPOSE A RAW DEFORMATION WITH AN ELASTIC DEFORMATION");
        IJ.log((String)"          target_image                      : In any image format");
        IJ.log((String)"          source_image                      : In any image format");
        IJ.log((String)"          Raw Transformation File           : As saved by bUnwarpJ in raw format");
        IJ.log((String)"          Elastic Transformation File       : As saved by bUnwarpJ in elastic format");
        IJ.log((String)"          Output Raw Transformation File    : As saved by bUnwarpJ in raw format");
        IJ.log((String)"");
        IJ.log((String)"  -adapt_transform                           : ADAPT AN ELASTIC DEFORMATION GIVEN A NEW IMAGE SIZE");
        IJ.log((String)"          target_image                       : In any image format");
        IJ.log((String)"          source_image                       : In any image format");
        IJ.log((String)"          Input Elastic Transformation File  : As saved by bUnwarpJ in elastic format");
        IJ.log((String)"          Output Elastic Transformation File : As saved by bUnwarpJ in elastic format");
        IJ.log((String)"          Image Size Factor                  : Integer (2, 4, 8...)");
        IJ.log((String)"");
        IJ.log((String)"Examples:");
        IJ.log((String)"Align two images without landmarks and without mask (no subsampling)");
        IJ.log((String)"   bUnwarpj_ -align target.jpg NULL source.jpg NULL 0 2 0 0.1 0.1 1 10 output_1.tif output_2.tif");
        IJ.log((String)"Align two images with landmarks and mask (no subsampling)");
        IJ.log((String)"   bUnwarpj_ -align target.tif target_mask.tif source.tif source_mask.tif 0 2 0 0.1 0.1 1 10 output_1.tif output_2.tif -landmarks 1 landmarks.txt");
        IJ.log((String)"Align two images with landmarks and initial affine transformations (no subsampling)");
        IJ.log((String)"   bUnwarpj_ -align target.tif target_mask.tif source.tif source_mask.tif 0 2 0 0.1 0.1 1 10 output_1.tif output_2.tif -affine affine_mat1.txt affine_mat2.txt");
        IJ.log((String)"Align two images using only landmarks (no subsampling)");
        IJ.log((String)"   bUnwarpj_ -align target.jpg NULL source.jpg NULL 0 2 0 0.1 0.1 0 0 output.tif_1 output_2.tif -landmarks 1 landmarks.txt");
        IJ.log((String)"Transform the source image with a previously computed elastic transformation");
        IJ.log((String)"   bUnwarpj_ -elastic_transform target.jpg source.jpg elastic_transformation.txt output.tif");
        IJ.log((String)"Transform the source image with a previously computed raw transformation");
        IJ.log((String)"   bUnwarpj_ -raw_transform target.jpg source.jpg raw_transformation.txt output.tif");
        IJ.log((String)"Calculate the warping index of two opposite elastic transformations");
        IJ.log((String)"   bUnwarpj_ -compare_elastic target.jpg source.jpg source_transformation.txt target_transformation.txt");
        IJ.log((String)"Calculate the warping index between an elastic transformation and a raw transformation");
        IJ.log((String)"   bUnwarpj_ -compare_elastic_raw target.jpg source.jpg elastic_transformation.txt raw_transformation.txt");
        IJ.log((String)"Calculate the warping index between two raw transformations");
        IJ.log((String)"   bUnwarpj_ -compare_raw target.jpg source.jpg raw_transformation_1.txt raw_transformation_2.txt");
        IJ.log((String)"Convert an elastic transformation into raw format");
        IJ.log((String)"   bUnwarpj_ -convert_to_raw target.jpg source.jpg elastic_transformation.txt output_raw_transformation.txt");
        IJ.log((String)"Compose two elastic transformations ");
        IJ.log((String)"   bUnwarpj_ -compose_elastic target.jpg source.jpg elastic_transformation_1.txt elastic_transformation_2.txt output_raw_transformation.txt");
        IJ.log((String)"Compose two raw transformations ");
        IJ.log((String)"   bUnwarpj_ -compose_raw target.jpg source.jpg raw_transformation_1.txt raw_transformation_2.txt output_raw_transformation.txt");
        IJ.log((String)"Compose a raw transformation with an elastic transformation ");
        IJ.log((String)"   bUnwarpj_ -compose_raw_elastic target.jpg source.jpg raw_transformation.txt elastic_transformation.txt output_raw_transformation.txt");
        IJ.log((String)"Adapt an elastic transformation to a new image size ");
        IJ.log((String)"   bUnwarpj_ -adapt_transform target.jpg source.jpg input_transformation.txt output_transformation.txt 2");
    }

    private static void adaptCoefficientsCommandLine(String[] args) {
        ImagePlus sourceImp;
        String fn_target = args[1];
        String fn_source = args[2];
        String fn_tnf = args[3];
        String fn_out = args[4];
        String sImageSizeFactor = args[5];
        IJ.log((String)("Target image                 : " + fn_target));
        IJ.log((String)("Source image                 : " + fn_source));
        IJ.log((String)("Input Transformation file    : " + fn_tnf));
        IJ.log((String)("Output Transformation file   : " + fn_out));
        IJ.log((String)("Image Size Factor            : " + sImageSizeFactor));
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        if (targetImp == null) {
            IJ.error((String)("\nError: " + fn_target + " could not be opened\n"));
        }
        if ((sourceImp = opener.openImage(fn_source)) == null) {
            IJ.error((String)("\nError: " + fn_source + " could not be opened\n"));
        }
        BSplineModel source = new BSplineModel(sourceImp.getProcessor(), false, 1);
        source.setPyramidDepth(0);
        source.startPyramids();
        int intervals = MiscTools.numberOfIntervalsOfTransformation(fn_tnf);
        double[][] cx = new double[intervals + 3][intervals + 3];
        double[][] cy = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(fn_tnf, cx, cy);
        try {
            source.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception " + e));
        }
        double dImageSizeFactor = Double.parseDouble(sImageSizeFactor);
        for (int i = 0; i < intervals + 3; ++i) {
            int j = 0;
            while (j < intervals + 3) {
                double[] dArray = cx[i];
                int n = j;
                dArray[n] = dArray[n] * dImageSizeFactor;
                double[] dArray2 = cy[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] * dImageSizeFactor;
            }
        }
        MiscTools.saveElasticTransformation(intervals, cx, cy, fn_out);
    }

    private static void elasticTransformImageCommandLine(String[] args) {
        ImagePlus sourceImp;
        String fn_target = args[1];
        String fn_source = args[2];
        String fn_tnf = args[3];
        String fn_out = args[4];
        IJ.log((String)("Target image           : " + fn_target));
        IJ.log((String)("Source image           : " + fn_source));
        IJ.log((String)("Transformation file    : " + fn_tnf));
        IJ.log((String)("Output:                : " + fn_out));
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        if (targetImp == null) {
            IJ.error((String)("\nError: " + fn_target + " could not be opened\n"));
        }
        if ((sourceImp = opener.openImage(fn_source)) == null) {
            IJ.error((String)("\nError: " + fn_source + " could not be opened\n"));
        }
        bUnwarpJ_.applyTransformToSource(fn_tnf, targetImp, sourceImp);
        FileSaver fs = new FileSaver(sourceImp);
        boolean ret = fs.saveAsTiff(fn_out);
        if (!ret) {
            System.out.println("Error when saving file " + fn_out);
        } else {
            System.out.println("Saved file " + fn_out);
        }
    }

    public static void applyTransformToSource(String transfPath, ImagePlus targetImp, ImagePlus sourceImp) {
        BSplineModel source = new BSplineModel(sourceImp.getProcessor(), false, 1);
        source.setPyramidDepth(0);
        source.startPyramids();
        int intervals = MiscTools.numberOfIntervalsOfTransformation(transfPath);
        double[][] cx = new double[intervals + 3][intervals + 3];
        double[][] cy = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(transfPath, cx, cy);
        try {
            source.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception " + e));
            return;
        }
        MiscTools.applyTransformationToSourceMT(sourceImp, targetImp, source, intervals, cx, cy);
    }

    private static void rawTransformImageCommandLine(String[] args) {
        ImagePlus sourceImp;
        String fn_target = args[1];
        String fn_source = args[2];
        String fn_tnf = args[3];
        String fn_out = args[4];
        IJ.log((String)("Target image           : " + fn_target));
        IJ.log((String)("Source image           : " + fn_source));
        IJ.log((String)("Transformation file    : " + fn_tnf));
        IJ.log((String)("Output:                : " + fn_out));
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        if (targetImp == null) {
            IJ.error((String)("\nError: " + fn_target + " could not be opened\n"));
        }
        if ((sourceImp = opener.openImage(fn_source)) == null) {
            IJ.error((String)("\nError: " + fn_source + " could not be opened\n"));
        }
        BSplineModel source = new BSplineModel(sourceImp.getProcessor(), false, 1);
        source.setPyramidDepth(0);
        source.startPyramids();
        double[][] transformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(fn_tnf, transformation_x, transformation_y);
        MiscTools.applyRawTransformationToSource(sourceImp, targetImp, source, transformation_x, transformation_y);
        FileSaver fs = new FileSaver(sourceImp);
        boolean ret = fs.saveAsTiff(fn_out);
        if (!ret) {
            System.out.println("Error when saving file " + fn_out);
        } else {
            System.out.println("Saved file " + fn_out);
        }
    }

    private static void compareElasticTransformationsCommandLine(String[] args) {
        double warpingIndex;
        ImagePlus sourceImp;
        String fn_target = args[1];
        String fn_source = args[2];
        String fn_tnf_1 = args[3];
        String fn_tnf_2 = args[4];
        IJ.log((String)("Target image                  : " + fn_target));
        IJ.log((String)("Source image                  : " + fn_source));
        IJ.log((String)("Target Transformation file    : " + fn_tnf_1));
        IJ.log((String)("Source Transformation file    : " + fn_tnf_2));
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        if (targetImp == null) {
            IJ.error((String)("\nError: " + fn_target + " could not be opened\n"));
        }
        if ((sourceImp = opener.openImage(fn_source)) == null) {
            IJ.error((String)("\nError: " + fn_source + " could not be opened\n"));
        }
        if ((warpingIndex = MiscTools.oppositeWarpingIndex(fn_tnf_2, fn_tnf_1, targetImp, sourceImp)) != -1.0) {
            IJ.log((String)(" Warping index = " + warpingIndex));
        } else {
            IJ.log((String)" Warping index could not be evaluated because not a single pixel matched after the deformation!");
        }
    }

    private static void compareElasticRawTransformationsCommandLine(String[] args) {
        ImagePlus sourceImp;
        String fn_target = args[1];
        String fn_source = args[2];
        String fn_tnf_elastic = args[3];
        String fn_tnf_raw = args[4];
        IJ.log((String)("Target image                  : " + fn_target));
        IJ.log((String)("Source image                  : " + fn_source));
        IJ.log((String)("Elastic Transformation file   : " + fn_tnf_elastic));
        IJ.log((String)("Raw Transformation file       : " + fn_tnf_raw));
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        if (targetImp == null) {
            IJ.error((String)("\nError: " + fn_target + " could not be opened\n"));
        }
        if ((sourceImp = opener.openImage(fn_source)) == null) {
            IJ.error((String)("\nError: " + fn_source + " could not be opened\n"));
        }
        int intervals = MiscTools.numberOfIntervalsOfTransformation(fn_tnf_elastic);
        double[][] cx_direct = new double[intervals + 3][intervals + 3];
        double[][] cy_direct = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(fn_tnf_elastic, cx_direct, cy_direct);
        double[][] transformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(fn_tnf_raw, transformation_x, transformation_y);
        double warpingIndex = MiscTools.rawWarpingIndex(sourceImp, targetImp, intervals, cx_direct, cy_direct, transformation_x, transformation_y);
        if (warpingIndex != -1.0) {
            IJ.log((String)(" Warping index = " + warpingIndex));
        } else {
            IJ.log((String)" Warping index could not be evaluated because not a single pixel matched after the deformation!");
        }
    }

    private static void compareRawTransformationsCommandLine(String[] args) {
        ImagePlus sourceImp;
        String fn_target = args[1];
        String fn_source = args[2];
        String fn_tnf_1 = args[3];
        String fn_tnf_2 = args[4];
        IJ.log((String)("Target image                  : " + fn_target));
        IJ.log((String)("Source image                  : " + fn_source));
        IJ.log((String)("Target Transformation file    : " + fn_tnf_1));
        IJ.log((String)("Source Transformation file    : " + fn_tnf_2));
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        if (targetImp == null) {
            IJ.error((String)("\nError: " + fn_target + " could not be opened\n"));
        }
        if ((sourceImp = opener.openImage(fn_source)) == null) {
            IJ.error((String)("\nError: " + fn_source + " could not be opened\n"));
        }
        double[][] transformation_x_1 = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y_1 = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(fn_tnf_1, transformation_x_1, transformation_y_1);
        double[][] transformation_x_2 = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y_2 = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(fn_tnf_2, transformation_x_2, transformation_y_2);
        double warpingIndex = MiscTools.rawWarpingIndex(sourceImp, targetImp, transformation_x_1, transformation_y_1, transformation_x_2, transformation_y_2);
        if (warpingIndex != -1.0) {
            IJ.log((String)(" Warping index = " + warpingIndex));
        } else {
            IJ.log((String)" Warping index could not be evaluated because not a single pixel matched after the deformation!");
        }
    }

    private static void convertToRawTransformationCommandLine(String[] args) {
        ImagePlus sourceImp;
        String fn_target = args[1];
        String fn_source = args[2];
        String fn_tnf_elastic = args[3];
        String fn_tnf_raw = args[4];
        IJ.log((String)("Target image                      : " + fn_target));
        IJ.log((String)("Source image                      : " + fn_source));
        IJ.log((String)("Input Elastic Transformation file : " + fn_tnf_elastic));
        IJ.log((String)("Ouput Raw Transformation file     : " + fn_tnf_raw));
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        if (targetImp == null) {
            IJ.error((String)("\nError: " + fn_target + " could not be opened\n"));
        }
        if ((sourceImp = opener.openImage(fn_source)) == null) {
            IJ.error((String)("\nError: " + fn_source + " could not be opened\n"));
        }
        int intervals = MiscTools.numberOfIntervalsOfTransformation(fn_tnf_elastic);
        double[][] cx = new double[intervals + 3][intervals + 3];
        double[][] cy = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(fn_tnf_elastic, cx, cy);
        double[][] transformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.convertElasticTransformationToRaw(targetImp, intervals, cx, cy, transformation_x, transformation_y);
        MiscTools.saveRawTransformation(fn_tnf_raw, targetImp.getWidth(), targetImp.getHeight(), transformation_x, transformation_y);
    }

    private static void composeRawTransformationsCommandLine(String[] args) {
        ImagePlus sourceImp;
        String fn_target = args[1];
        String fn_source = args[2];
        String fn_tnf_raw_1 = args[3];
        String fn_tnf_raw_2 = args[4];
        String fn_tnf_raw_out = args[5];
        IJ.log((String)("Target image                      : " + fn_target));
        IJ.log((String)("Source image                      : " + fn_source));
        IJ.log((String)("Input Raw Transformation file 1   : " + fn_tnf_raw_1));
        IJ.log((String)("Input Raw Transformation file 2   : " + fn_tnf_raw_2));
        IJ.log((String)("Output Raw Transformation file    : " + fn_tnf_raw_out));
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        if (targetImp == null) {
            IJ.error((String)("\nError: " + fn_target + " could not be opened\n"));
        }
        if ((sourceImp = opener.openImage(fn_source)) == null) {
            IJ.error((String)("\nError: " + fn_source + " could not be opened\n"));
        }
        double[][] transformation_x_1 = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y_1 = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(fn_tnf_raw_1, transformation_x_1, transformation_y_1);
        double[][] transformation_x_2 = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y_2 = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(fn_tnf_raw_2, transformation_x_2, transformation_y_2);
        double[][] outputTransformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] outputTransformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.composeRawTransformations(targetImp.getWidth(), targetImp.getHeight(), transformation_x_1, transformation_y_1, transformation_x_2, transformation_y_2, outputTransformation_x, outputTransformation_y);
        MiscTools.saveRawTransformation(fn_tnf_raw_out, targetImp.getWidth(), targetImp.getHeight(), outputTransformation_x, outputTransformation_y);
    }

    private static void composeElasticTransformationsCommandLine(String[] args) {
        ImagePlus sourceImp;
        String fn_target = args[1];
        String fn_source = args[2];
        String fn_tnf_elastic_1 = args[3];
        String fn_tnf_elastic_2 = args[4];
        String fn_tnf_raw = args[5];
        IJ.log((String)("Target image                        : " + fn_target));
        IJ.log((String)("Source image                        : " + fn_source));
        IJ.log((String)("Input Elastic Transformation file 1 : " + fn_tnf_elastic_1));
        IJ.log((String)("Input Elastic Transformation file 2 : " + fn_tnf_elastic_2));
        IJ.log((String)("Output Raw Transformation file      : " + fn_tnf_raw));
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        if (targetImp == null) {
            IJ.error((String)("\nError: " + fn_target + " could not be opened\n"));
        }
        if ((sourceImp = opener.openImage(fn_source)) == null) {
            IJ.error((String)("\nError: " + fn_source + " could not be opened\n"));
        }
        int intervals = MiscTools.numberOfIntervalsOfTransformation(fn_tnf_elastic_1);
        double[][] cx1 = new double[intervals + 3][intervals + 3];
        double[][] cy1 = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(fn_tnf_elastic_1, cx1, cy1);
        intervals = MiscTools.numberOfIntervalsOfTransformation(fn_tnf_elastic_2);
        double[][] cx2 = new double[intervals + 3][intervals + 3];
        double[][] cy2 = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(fn_tnf_elastic_2, cx2, cy2);
        double[][] outputTransformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] outputTransformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.composeElasticTransformations(targetImp, intervals, cx1, cy1, cx2, cy2, outputTransformation_x, outputTransformation_y);
        MiscTools.saveRawTransformation(fn_tnf_raw, targetImp.getWidth(), targetImp.getHeight(), outputTransformation_x, outputTransformation_y);
    }

    private static void composeRawElasticTransformationsCommandLine(String[] args) {
        ImagePlus sourceImp;
        String fn_target = args[1];
        String fn_source = args[2];
        String fn_tnf_raw_in = args[3];
        String fn_tnf_elastic = args[4];
        String fn_tnf_raw_out = args[5];
        IJ.log((String)("Target image                      : " + fn_target));
        IJ.log((String)("Source image                      : " + fn_source));
        IJ.log((String)("Input Raw Transformation file     : " + fn_tnf_raw_in));
        IJ.log((String)("Input Elastic Transformation file : " + fn_tnf_elastic));
        IJ.log((String)("Output Raw Transformation file    : " + fn_tnf_raw_out));
        Opener opener = new Opener();
        ImagePlus targetImp = opener.openImage(fn_target);
        if (targetImp == null) {
            IJ.error((String)("\nError: " + fn_target + " could not be opened\n"));
        }
        if ((sourceImp = opener.openImage(fn_source)) == null) {
            IJ.error((String)("\nError: " + fn_source + " could not be opened\n"));
        }
        double[][] transformation_x_1 = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y_1 = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(fn_tnf_raw_in, transformation_x_1, transformation_y_1);
        int intervals = MiscTools.numberOfIntervalsOfTransformation(fn_tnf_elastic);
        double[][] cx2 = new double[intervals + 3][intervals + 3];
        double[][] cy2 = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(fn_tnf_elastic, cx2, cy2);
        double[][] outputTransformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] outputTransformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.composeRawElasticTransformations(targetImp, intervals, transformation_x_1, transformation_y_1, cx2, cy2, outputTransformation_x, outputTransformation_y);
        MiscTools.saveRawTransformation(fn_tnf_raw_out, targetImp.getWidth(), targetImp.getHeight(), outputTransformation_x, outputTransformation_y);
    }

    public static void elasticTransformImageMacro(String targetImageName, String sourceImageName, String transformationFileName, String outputFileName) {
        String[] args = new String[]{"bUnwarpJ_", targetImageName, sourceImageName, transformationFileName, outputFileName};
        bUnwarpJ_.elasticTransformImageCommandLine(args);
    }

    public static void rawTransformImageMacro(String targetImageName, String sourceImageName, String transformationFileName, String outputFileName) {
        String[] args = new String[]{"bUnwarpJ_", targetImageName, sourceImageName, transformationFileName, outputFileName};
        bUnwarpJ_.rawTransformImageCommandLine(args);
    }

    public static void compareElasticTransformationsMacro(String targetImageName, String sourceImageName, String targetTransfFileName, String sourceTransfFileName) {
        String[] args = new String[]{"bUnwarpJ_", targetImageName, sourceImageName, targetTransfFileName, sourceTransfFileName};
        bUnwarpJ_.compareElasticTransformationsCommandLine(args);
    }

    public static void compareElasticRawTransformationsMacro(String targetImageName, String sourceImageName, String targetTransfFileName, String sourceTransfFileName) {
        String[] args = new String[]{"bUnwarpJ_", targetImageName, sourceImageName, targetTransfFileName, sourceTransfFileName};
        bUnwarpJ_.compareElasticRawTransformationsCommandLine(args);
    }

    public static void compareRawTransformationsMacro(String targetImageName, String sourceImageName, String targetTransfFileName, String sourceTransfFileName) {
        String[] args = new String[]{"bUnwarpJ_", targetImageName, sourceImageName, targetTransfFileName, sourceTransfFileName};
        bUnwarpJ_.compareRawTransformationsCommandLine(args);
    }

    public static void convertToRawTransformationMacro(String targetImageName, String sourceImageName, String inputElasticTransfFileName, String outputRawTransfFileName) {
        String[] args = new String[]{"bUnwarpJ_", targetImageName, sourceImageName, inputElasticTransfFileName, outputRawTransfFileName};
        bUnwarpJ_.convertToRawTransformationCommandLine(args);
    }

    public static void composeElasticTransformationsMacro(String targetImageName, String sourceImageName, String inputElasticTransfFileName1, String inputElasticTransfFileName2, String outputRawTransfFileName) {
        String[] args = new String[]{"bUnwarpJ_", targetImageName, sourceImageName, inputElasticTransfFileName1, inputElasticTransfFileName2, outputRawTransfFileName};
        bUnwarpJ_.composeElasticTransformationsCommandLine(args);
    }

    public static void composeRawTransformationsMacro(String targetImageName, String sourceImageName, String inputRawTransfFileName1, String inputRawTransfFileName2, String outputRawTransfFileName) {
        String[] args = new String[]{"bUnwarpJ_", targetImageName, sourceImageName, inputRawTransfFileName1, inputRawTransfFileName2, outputRawTransfFileName};
        bUnwarpJ_.composeRawTransformationsCommandLine(args);
    }

    public static void composeRawElasticTransformationsMacro(String targetImageName, String sourceImageName, String inputRawTransfFileName, String inputElasticTransfFileName, String outputRawTransfFileName) {
        String[] args = new String[]{"bUnwarpJ_", targetImageName, sourceImageName, inputRawTransfFileName, inputElasticTransfFileName, outputRawTransfFileName};
        bUnwarpJ_.composeRawElasticTransformationsCommandLine(args);
    }

    public static void adaptCoefficientsMacro(String targetImageName, String sourceImageName, String inputElasticTransfFileName, String outputElasticTransfFileName, String sizeFactor) {
        String[] args = new String[]{"bUnwarpJ_", targetImageName, sourceImageName, inputElasticTransfFileName, outputElasticTransfFileName, sizeFactor};
        bUnwarpJ_.adaptCoefficientsCommandLine(args);
    }

    public static void evaluateImageSimilarity(String targetImageName, String sourceImageName) {
        ImagePlus targetImp = WindowManager.getImage((String)targetImageName);
        if (null == targetImp) {
            IJ.log((String)("Error: missing target image: " + targetImageName));
            return;
        }
        ImagePlus sourceImp = WindowManager.getImage((String)sourceImageName);
        if (null == sourceImp) {
            IJ.log((String)("Error: missing source image: " + sourceImageName));
            return;
        }
        Mask targetMsk = targetImp.getImageStackSize() == 1 ? null : new Mask(targetImp.getImageStack().getProcessor(2), true);
        MiscTools.imageSimilarity(targetImp, sourceImp, targetMsk, true);
    }

    public static void loadLandmarks(String landmarksFilePath) {
        MainDialog md = bUnwarpJ_.getMainDialog();
        if (null == md) {
            IJ.log((String)"Error: bUnwarpJ dialog not found!");
            return;
        }
        Stack<Point> sourceStack = new Stack<Point>();
        Stack<Point> targetStack = new Stack<Point>();
        MiscTools.loadPoints(landmarksFilePath, sourceStack, targetStack);
        PointHandler sourcePh = md.getSourcePh();
        PointHandler targetPh = md.getTargetPh();
        sourcePh.removePoints();
        targetPh.removePoints();
        while (!sourceStack.empty() && !targetStack.empty()) {
            Point sourcePoint = sourceStack.pop();
            Point targetPoint = targetStack.pop();
            sourcePh.addPoint(sourcePoint.x, sourcePoint.y);
            targetPh.addPoint(targetPoint.x, targetPoint.y);
        }
    }

    public static void saveLandmarks(String landmarksFilePath) {
        MainDialog md = bUnwarpJ_.getMainDialog();
        if (null == md) {
            IJ.log((String)"Error: bUnwarpJ dialog not found!");
            return;
        }
        MiscTools.saveLandmarks(landmarksFilePath, md.getSourcePh().getPoints(), md.getTargetPh().getPoints());
    }

    public static void showLandmarks() {
        MainDialog md = bUnwarpJ_.getMainDialog();
        if (null == md) {
            IJ.log((String)"Error: bUnwarpJ dialog not found!");
            return;
        }
        MiscTools.showPoints(md.getSourcePh().getPoints(), md.getTargetPh().getPoints());
    }

    public static void loadElasticTransform(String transfPath, String targetTitle, String sourceTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        ImagePlus sourceImp = WindowManager.getImage((String)sourceTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        if (null == sourceImp) {
            IJ.error((String)("Error: " + sourceTitle + " image not found!"));
            return;
        }
        bUnwarpJ_.applyTransformToSource(transfPath, targetImp, sourceImp);
    }

    public static void loadRawTransform(String transfPath, String targetTitle, String sourceTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        ImagePlus sourceImp = WindowManager.getImage((String)sourceTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        if (null == sourceImp) {
            IJ.error((String)("Error: " + sourceTitle + " image not found!"));
            return;
        }
        bUnwarpJ_.applyRawTransformToSource(transfPath, targetImp, sourceImp);
    }

    public static void applyRawTransformToSource(String transfPath, ImagePlus targetImp, ImagePlus sourceImp) {
        double[][] transformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(transfPath, transformation_x, transformation_y);
        BSplineModel source = new BSplineModel(sourceImp.getProcessor(), false, 1);
        source.setPyramidDepth(0);
        source.startPyramids();
        try {
            source.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception " + e));
            return;
        }
        MiscTools.applyRawTransformationToSource(sourceImp, targetImp, source, transformation_x, transformation_y);
    }

    public static void compareOppositeElasticTransforms(String directTransfPath, String inverseTransfPath, String targetTitle, String sourceTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        ImagePlus sourceImp = WindowManager.getImage((String)sourceTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        if (null == sourceImp) {
            IJ.error((String)("Error: " + sourceTitle + " image not found!"));
            return;
        }
        double warpingIndex = MiscTools.oppositeWarpingIndex(directTransfPath, inverseTransfPath, targetImp, sourceImp);
        if (warpingIndex != -1.0) {
            IJ.log((String)(" Warping index = " + warpingIndex));
        } else {
            IJ.log((String)" Warping index could not be evaluated because not a singlepixel matched after the deformation!");
        }
    }

    public static void compareElasticRawTransforms(String elasticTransfPath, String rawTransfPath, String targetTitle, String sourceTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        ImagePlus sourceImp = WindowManager.getImage((String)sourceTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        if (null == sourceImp) {
            IJ.error((String)("Error: " + sourceTitle + " image not found!"));
            return;
        }
        double warpingIndex = MiscTools.elasticRawWarpingIndex(elasticTransfPath, rawTransfPath, targetImp, sourceImp);
        if (warpingIndex != -1.0) {
            IJ.log((String)(" Warping index = " + warpingIndex));
        } else {
            IJ.log((String)" Warping index could not be evaluated because not a singlepixel matched after the deformation!");
        }
    }

    public static void compareRawTransforms(String rawTransfPath1, String rawTransfPath2, String targetTitle, String sourceTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        ImagePlus sourceImp = WindowManager.getImage((String)sourceTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        if (null == sourceImp) {
            IJ.error((String)("Error: " + sourceTitle + " image not found!"));
            return;
        }
        double warpingIndex = MiscTools.rawWarpingIndex(rawTransfPath1, rawTransfPath2, targetImp, sourceImp);
        if (warpingIndex != -1.0) {
            IJ.log((String)(" Warping index = " + warpingIndex));
        } else {
            IJ.log((String)" Warping index could not be evaluated because not a singlepixel matched after the deformation!");
        }
    }

    public static void convertToRaw(String elasticTransfPath, String rawTransfPath, String targetTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        MiscTools.saveElasticAsRaw(elasticTransfPath, rawTransfPath, targetImp);
    }

    public static void convertToElastic(String rawTransfPath, String elasticTransfPath, String strIntervals, String targetTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        MiscTools.saveRawAsElastic(rawTransfPath, elasticTransfPath, Integer.parseInt(strIntervals), targetImp);
    }

    public static void composeElasticTransforms(String elasticTransfPath1, String elasticTransfPath2, String rawTransfPath, String targetTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        MiscTools.composeElasticTransforms(elasticTransfPath1, elasticTransfPath2, rawTransfPath, targetImp);
    }

    public static void composeRawTransforms(String rawTransfPath1, String rawTransfPath2, String outputRawTransfPath, String targetTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        MiscTools.composeRawTransforms(rawTransfPath1, rawTransfPath2, outputRawTransfPath, targetImp);
    }

    public static void composeRawElasticTransforms(String rawTransfPath, String elasticTransfPath, String outputRawTransfPath, String targetTitle, String sourceTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        ImagePlus sourceImp = WindowManager.getImage((String)sourceTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        if (null == sourceImp) {
            IJ.error((String)("Error: " + sourceTitle + " image not found!"));
            return;
        }
        MiscTools.composeRawElasticTransforms(rawTransfPath, elasticTransfPath, outputRawTransfPath, targetImp, sourceImp);
    }

    public static void adaptCoefficients(String inputTransfPath, String strImageFactor, String outputTransfPath) {
        MiscTools.adaptCoefficients(inputTransfPath, Double.parseDouble(strImageFactor), outputTransfPath);
    }

    public static void loadSourceMask(String sourceMaskPath) {
        MainDialog md = bUnwarpJ_.getMainDialog();
        if (null == md) {
            IJ.log((String)"Error: bUnwarpJ dialog not found!");
            return;
        }
        md.setSourceMask(sourceMaskPath);
        md.grayImage(md.getSourcePh());
    }

    public static void loadSourceAffineMatrix(String affineMatrixPath) {
        MainDialog md = bUnwarpJ_.getMainDialog();
        if (null == md) {
            IJ.log((String)"Error: bUnwarpJ dialog not found!");
            return;
        }
        double[][] affineMatrix = new double[2][3];
        MiscTools.loadAffineMatrix(affineMatrixPath, affineMatrix);
        md.setSourceAffineMatrix(affineMatrix);
    }

    public static void invertRawTransform(String inputTransfPath, String outputTransfPath, String targetTitle) {
        ImagePlus targetImp = WindowManager.getImage((String)targetTitle);
        if (null == targetImp) {
            IJ.error((String)("Error: " + targetTitle + " image not found!"));
            return;
        }
        MiscTools.invertRawTransformation(inputTransfPath, outputTransfPath, targetImp);
    }

    public static MainDialog getMainDialog() {
        for (Window w : Dialog.getWindows()) {
            MainDialog md;
            if (!(w instanceof MainDialog) || null == (md = (MainDialog)((Object)w)).getSource()) continue;
            return md;
        }
        return null;
    }
}

