/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DefaultBlockReader;
import org.janelia.saalfeldlab.n5.DefaultBlockWriter;

@Compression.CompressionType(value="lz4")
public class Lz4Compression
implements DefaultBlockReader,
DefaultBlockWriter,
Compression {
    private static final long serialVersionUID = -9071316415067427256L;
    @Compression.CompressionParameter
    private final int blockSize;

    public Lz4Compression(int blockSize) {
        this.blockSize = blockSize;
    }

    public Lz4Compression() {
        this(65536);
    }

    @Override
    public InputStream getInputStream(InputStream in) throws IOException {
        return new LZ4BlockInputStream(in);
    }

    @Override
    public OutputStream getOutputStream(OutputStream out) throws IOException {
        return new LZ4BlockOutputStream(out, this.blockSize);
    }

    @Override
    public Lz4Compression getReader() {
        return this;
    }

    @Override
    public Lz4Compression getWriter() {
        return this;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != Lz4Compression.class) {
            return false;
        }
        return this.blockSize == ((Lz4Compression)other).blockSize;
    }
}

