/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.janelia.saalfeldlab.n5.AbstractDataBlock;

public class StringDataBlock
extends AbstractDataBlock<String[]> {
    protected static final Charset ENCODING = StandardCharsets.UTF_8;
    protected static final String NULLCHAR = "\u0000";
    protected byte[] serializedData = null;
    protected String[] actualData = null;

    public StringDataBlock(int[] size, long[] gridPosition, String[] data) {
        super(size, gridPosition, new String[0]);
        this.actualData = data;
    }

    public StringDataBlock(int[] size, long[] gridPosition, byte[] data) {
        super(size, gridPosition, new String[0]);
        this.serializedData = data;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        if (this.serializedData == null) {
            this.serializedData = this.serialize(this.actualData);
        }
        return ByteBuffer.wrap(this.serializedData);
    }

    @Override
    public void readData(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            if (buffer.array() != this.serializedData) {
                buffer.get(this.serializedData);
            }
            this.actualData = this.deserialize(buffer.array());
        } else {
            this.actualData = ENCODING.decode(buffer).toString().split(NULLCHAR);
        }
    }

    protected byte[] serialize(String[] strings) {
        String flattenedArray = String.join((CharSequence)NULLCHAR, strings) + NULLCHAR;
        return flattenedArray.getBytes(ENCODING);
    }

    protected String[] deserialize(byte[] rawBytes) {
        String rawChars = new String(rawBytes, ENCODING);
        return rawChars.split(NULLCHAR);
    }

    @Override
    public int getNumElements() {
        if (this.serializedData == null) {
            this.serializedData = this.serialize(this.actualData);
        }
        return this.serializedData.length;
    }

    @Override
    public String[] getData() {
        if (this.actualData == null) {
            this.actualData = this.deserialize(this.serializedData);
        }
        return this.actualData;
    }
}

