/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;

public class parObject {
    public int n = 0;
    public int maxpixnum = 10000;
    public double[] x = new double[this.maxpixnum];
    public double[] y = new double[this.maxpixnum];
    public double[] intensity = new double[this.maxpixnum];
    public int type;
    public double princangle = -32000.0;
    public double curv = -32000.0;
    public double xave = -1.0;
    public double yave = -1.0;

    public void addp(int i, int j, double k) {
        if (this.isin(i, j) == 0 && this.n < this.maxpixnum - 3) {
            this.x[this.n] = i;
            this.y[this.n] = j;
            this.intensity[this.n] = k;
            ++this.n;
        }
    }

    public void addp(double i, double j, double k) {
        if (this.isin(i, j) == 0 && this.n < this.maxpixnum - 3) {
            this.x[this.n] = i;
            this.y[this.n] = j;
            this.intensity[this.n] = k;
            ++this.n;
        }
    }

    public void print() {
        IJ.log((String)("N " + this.n));
    }

    public double avef() {
        double s = 0.0;
        for (int i = 0; i < this.n; ++i) {
            s += this.intensity[i];
        }
        return s / (double)this.n;
    }

    public int objPixelSize() {
        return this.n;
    }

    public int isin(int i, int j) {
        for (int b = 0; b < this.n; ++b) {
            if (this.x[b] != (double)i || this.y[b] != (double)j) continue;
            return 1;
        }
        return 0;
    }

    public int isin(double i, double j) {
        for (int b = 0; b < this.n; ++b) {
            if (this.x[b] != i || this.y[b] != j) continue;
            return 1;
        }
        return 0;
    }

    public double sqrt(double sqrt_rslt) {
        double sqrt_l = sqrt_rslt;
        double sqrt_div = (char)((sqrt_l + 1.0) / 2.0);
        while (sqrt_rslt > sqrt_div) {
            sqrt_rslt = sqrt_div;
            sqrt_div = (char)((sqrt_l / sqrt_div + sqrt_div + 1.0) / 2.0);
        }
        return sqrt_rslt;
    }

    public int isclose(int i, int j) {
        for (int b = 0; b < this.n; ++b) {
            if (!(this.sqrt(((double)i - this.x[b]) * ((double)i - this.x[b]) + ((double)j - this.y[b]) * ((double)j - this.y[b])) <= 2.0)) continue;
            return 1;
        }
        return 0;
    }

    public double avex() {
        double s = 0.0;
        for (int i = 0; i < this.n; ++i) {
            s += this.x[i];
        }
        this.xave = s / (double)this.n;
        return s / (double)this.n;
    }

    public double avey() {
        double s = 0.0;
        for (int i = 0; i < this.n; ++i) {
            s += this.y[i];
        }
        this.yave = s / (double)this.n;
        return s / (double)this.n;
    }

    public double dx() {
        double s = this.avex();
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            d += (this.x[i] - s) * (this.x[i] - s);
        }
        return this.sqrt(d * 100.0) / 10.0;
    }

    public double dy() {
        double s = this.avey();
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            d += (this.y[i] - s) * (this.y[i] - s);
        }
        return this.sqrt(d * 100.0) / 10.0;
    }

    public int sumint() {
        int res = 0;
        for (int i = 0; i < this.n; ++i) {
            res = (int)((double)res + this.intensity[i]);
        }
        return res;
    }

    public double wavex() {
        double s = 0.0;
        for (int i = 0; i < this.n; ++i) {
            s += this.x[i] * this.intensity[i];
        }
        return s / (double)this.sumint();
    }

    public double wavey() {
        double s = 0.0;
        for (int i = 0; i < this.n; ++i) {
            s += this.y[i] * this.intensity[i];
        }
        return s / (double)this.sumint();
    }

    public double corrxy() {
        double sx = this.avex();
        double sy = this.avey();
        double cov = 0.0;
        for (int i = 0; i < this.n; ++i) {
            cov += (sx - this.x[i]) * (sy - this.y[i]);
        }
        return cov / this.dx() / this.dy();
    }

    public double corrxyweight() {
        double sx = this.wavex();
        double sy = this.wavey();
        double cov = 0.0;
        for (int i = 0; i < this.n; ++i) {
            cov += this.intensity[i] * (sx - this.x[i]) * (sy - this.y[i]);
        }
        return (double)this.n * cov / this.dx() / this.dy() / (double)this.sumint();
    }

    public int maxX() {
        double maxx = 0.0;
        for (int i = 0; i < this.n; ++i) {
            if (!(this.x[i] > maxx)) continue;
            maxx = this.x[i];
        }
        return (int)maxx;
    }

    public int minX() {
        double minx = 32000.0;
        for (int i = 0; i < this.n; ++i) {
            if (!(this.x[i] < minx)) continue;
            minx = this.x[i];
        }
        return (int)minx;
    }

    public int maxY() {
        double maxy = 0.0;
        for (int i = 0; i < this.n; ++i) {
            if (!(this.y[i] > maxy)) continue;
            maxy = this.y[i];
        }
        return (int)maxy;
    }

    public int minY() {
        double miny = 32000.0;
        for (int i = 0; i < this.n; ++i) {
            if (!(this.y[i] < miny)) continue;
            miny = this.y[i];
        }
        return (int)miny;
    }

    public double middleX(double yval) {
        double maxx = 0.0;
        double minx = 100000.0;
        for (int i = 0; i < this.n; ++i) {
            if ((int)this.y[i] >= (int)(yval + 1.0) || (int)this.y[i] <= (int)(yval - 1.0)) continue;
            if (this.x[i] < minx) {
                minx = this.x[i];
            }
            if (!(this.x[i] > maxx)) continue;
            maxx = this.x[i];
        }
        return (minx + maxx) / 2.0;
    }

    public int deftype() {
        parObject rtpar = new parObject();
        rtpar = this.rotate(45.0 - this.princ_angle());
        double c = Math.max(Math.abs(rtpar.corrxy()), Math.abs(this.corrxy()));
        if (Math.abs(c) >= 0.52) {
            return 3;
        }
        if (Math.abs(c) < 0.52 && Math.abs(c) > 0.15) {
            return 2;
        }
        if (Math.abs(c) <= 0.15) {
            return 1;
        }
        return 0;
    }

    public int deftype_ooc() {
        parObject rtpar = new parObject();
        rtpar = this.rotate(45.0);
        double c = Math.max(Math.abs(rtpar.corrxy()), Math.abs(this.corrxy()));
        if (Math.abs(c) > 0.25) {
            return 2;
        }
        if (Math.abs(c) <= 0.25) {
            return 1;
        }
        return 0;
    }

    public double mlen() {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!(this.sqrt((this.x[i] - this.x[j]) * (this.x[i] - this.x[j]) + (this.y[j] - this.y[i]) * (this.y[j] - this.y[i])) > d)) continue;
                d = Math.sqrt((this.x[i] - this.x[j]) * (this.x[i] - this.x[j]) + (this.y[j] - this.y[i]) * (this.y[j] - this.y[i]));
            }
        }
        return d;
    }

    public double dispersion() {
        double d = 0.0;
        double ax = this.avex();
        double ay = this.avey();
        for (int i = 0; i < this.n; ++i) {
            d += this.sqrt((this.x[i] - ax) * (this.x[i] - ax) + (ay - this.y[i]) * (ay - this.y[i]));
        }
        return d;
    }

    parObject rotate(double alpha) {
        double alpharad = alpha * 6.28 / 360.0;
        parObject rtpar = new parObject();
        double ax = this.avex();
        double ay = this.avey();
        for (int i = 0; i < this.n; ++i) {
            rtpar.addp(Math.cos(alpharad) * (this.x[i] - ax) + Math.sin(alpharad) * (this.y[i] - ay) + ax, Math.cos(alpharad) * (this.y[i] - ay) - Math.sin(alpharad) * (this.x[i] - ax) + ay, this.intensity[i]);
        }
        return rtpar;
    }

    public double princ_angle3() {
        parObject rot45 = new parObject();
        rot45 = this.rotate(45.0);
        double a = 0.0;
        double b = 0.0;
        double nd = this.n;
        for (int i = 0; i < this.n; ++i) {
            b += (this.x[i] - this.avex()) * (this.y[i] - this.avey());
            a += (this.x[i] - this.avex()) * (this.x[i] - this.avex());
        }
        return Math.atan((nd * b - this.dx() * this.dy()) / (nd * a - this.dx() * this.dx())) / 6.28 * 360.0;
    }

    public double princ_angle2() {
        parObject rot45 = new parObject();
        double rangle = 0.0;
        rot45 = this.rotate(rangle);
        double a = 0.0;
        double b = 0.0;
        double nd = rot45.n;
        for (int i = 0; i < this.n; ++i) {
            b += (rot45.x[i] - rot45.avex()) * (rot45.y[i] - rot45.avey());
            a += (rot45.x[i] - rot45.avex()) * (rot45.x[i] - rot45.avex());
        }
        return Math.atan((nd * b - this.dx() * this.dy()) / (nd * a - this.dx() * this.dx())) / 6.28 * 360.0;
    }

    public double princ_angle() {
        if (this.princangle != -32000.0) {
            return this.princangle;
        }
        double spf = 0.0;
        double bestangle = 0.0;
        parObject rot = new parObject();
        for (double i = 0.0; i < 180.0; i += 15.0) {
            rot = this.rotate(i);
            if (!(rot.dy() / rot.dx() > spf)) continue;
            spf = rot.dy() / rot.dx();
            bestangle = i;
        }
        double roughangle = bestangle;
        for (double i = roughangle - 8.0; i < roughangle + 9.0; i += 0.5) {
            rot = this.rotate(i);
            if (!(rot.dy() / rot.dx() > spf)) continue;
            spf = rot.dy() / rot.dx();
            bestangle = i;
        }
        this.princangle = bestangle - 90.0;
        return bestangle - 90.0;
    }

    double curvature() {
        int i;
        long r;
        if (this.curv != -32000.0) {
            return this.curv;
        }
        double ds = 0.0;
        double bestds = 2.147483647E9;
        long bestfit = -1000L;
        if (this.princangle == -32000.0) {
            this.princ_angle();
        }
        parObject rtpar = new parObject();
        rtpar = this.rotate(90.0 + this.princangle);
        if (this.xave == -1.0) {
            this.dx();
        }
        if (this.yave == -1.0) {
            this.dy();
        }
        double ax = this.middleX(this.yave);
        double ay = this.yave;
        for (r = -400L; r <= 400L; r += 30L) {
            ds = 0.0;
            if ((double)(Math.abs(r) * 2L) < rtpar.mlen() + 1.0) continue;
            for (i = 0; i < this.n; ++i) {
                ds += Math.abs(Math.sqrt((rtpar.x[i] - ax + (double)r) * (rtpar.x[i] - ax + (double)r) + (rtpar.y[i] - ay) * (rtpar.y[i] - ay)) - (double)Math.abs(r));
            }
            if (!(ds < bestds)) continue;
            bestds = ds;
            bestfit = r;
        }
        for (r = bestfit - 15L; r <= bestfit + 15L; ++r) {
            ds = 0.0;
            if ((double)(Math.abs(r) * 2L) < rtpar.mlen() + 1.0) continue;
            for (i = 0; i < this.n; ++i) {
                ds += Math.abs(Math.sqrt((rtpar.x[i] - ax + (double)r) * (rtpar.x[i] - ax + (double)r) + (rtpar.y[i] - ay) * (rtpar.y[i] - ay)) - (double)Math.abs(r));
            }
            if (!(ds < bestds)) continue;
            bestds = ds;
            bestfit = r;
        }
        return 1.0 / (double)bestfit;
    }

    public int perimeter() {
        int per = 0;
        double maxdist = 1.0;
        for (int i = 0; i < this.n; ++i) {
            double check = 0.0;
            for (int j = 0; j < this.n; ++j) {
                if (!(Math.sqrt((this.x[i] - this.x[j]) * (this.x[i] - this.x[j]) + (this.y[i] - this.y[j]) * (this.y[i] - this.y[j])) <= maxdist)) continue;
                check += 1.0;
            }
            if (!(check < 5.0)) continue;
            ++per;
        }
        return per;
    }

    public double circ_index() {
        return (double)this.perimeter() / (double)this.n;
    }
}

