/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.python.indexer.types.NModuleType;
import org.scijava.plugins.scripteditor.jython.DotAutocompletions;
import org.scijava.plugins.scripteditor.jython.JythonDev;
import org.scijava.plugins.scripteditor.jython.Scope;
import org.scijava.ui.swing.script.autocompletion.CompletionText;

public class StaticDotAutocompletions
implements DotAutocompletions {
    final String className;

    public StaticDotAutocompletions(String className) {
        this.className = className;
    }

    @Override
    public String getClassname() {
        return this.className;
    }

    @Override
    public List<CompletionText> get() {
        ArrayList<CompletionText> ac = new ArrayList<CompletionText>();
        if (null != this.className) {
            String msg = "";
            try {
                NModuleType module = Scope.loadPythonModule(this.className);
                JythonDev.printTrace("module is: " + module);
                if (null != module) {
                    module.getTable().keySet().forEach(m -> ac.add(new CompletionText(m)));
                    return ac;
                }
                msg = msg + "Not a python module: " + this.className;
                try {
                    DotAutocompletions.staticFieldsAndStaticMethodsInto(Class.forName(this.className), ac);
                    return ac;
                }
                catch (ClassNotFoundException cnfe) {
                    msg = msg + "\nCannot find java class " + this.className;
                    try {
                        int idot = this.className.lastIndexOf(46);
                        String name = this.className.substring(idot + 1);
                        Class<?> c = Class.forName(this.className.substring(0, idot));
                        for (Class r : Arrays.asList(c.getMethods()).stream().filter(m -> m.getName().equals(name)).map(m -> m.getReturnType()).distinct().collect(Collectors.toList())) {
                            DotAutocompletions.fieldsAndMethodsInto(r, ac);
                        }
                        return ac;
                    }
                    catch (ClassNotFoundException cnfe2) {
                        msg = msg + "\nCannot derive static method or field from " + this.className;
                        if (null != msg) {
                            JythonDev.print(msg);
                        }
                    }
                }
            }
            catch (Exception e) {
                JythonDev.print(msg, e);
            }
        }
        return ac;
    }

    public String toString() {
        String completions = this.get().stream().map(c -> c.getReplacementText()).collect(Collectors.joining(",", "[", "]"));
        return "StaticDotAutocompletions: " + this.className + " -- " + completions;
    }
}

