/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.geometry;

import java.util.ArrayList;
import org.scijava.java3d.utils.geometry.Stripifier;

public class StripifierStats {
    int numStrips = 0;
    int numVerts = 0;
    int minStripLen = 10000;
    int maxStripLen = 0;
    int totalTris = 0;
    int numFaces = 0;
    long time = 0L;
    int[] counts = new int[14];
    boolean noData = true;

    public int getNumOrigTris() {
        return this.numFaces;
    }

    public int getNumOrigVerts() {
        return this.numFaces * 3;
    }

    public int getNumStrips() {
        return this.numStrips;
    }

    public int getNumVerts() {
        return this.numVerts;
    }

    public int getTotalTris() {
        return this.totalTris;
    }

    public int getMinStripLength() {
        return this.minStripLen;
    }

    public int getMaxStripLength() {
        return this.maxStripLen;
    }

    public double getAvgStripLength() {
        return (double)this.totalTris / (double)this.numStrips;
    }

    public double getAvgNumVertsPerTri() {
        return (double)this.numVerts / (double)this.totalTris;
    }

    public long getTotalTime() {
        return this.time;
    }

    public int[] getStripLengthCounts() {
        return this.counts;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("num orig tris:        " + this.numFaces + "\n" + "num orig vertices:    " + this.numFaces * 3 + "\n" + "number of strips:     " + this.numStrips + "\n" + "number of vertices:   " + this.numVerts + "\n" + "total tris:           " + this.totalTris + "\n" + "min strip length:     " + this.minStripLen + "\n" + "max strip length:     " + this.maxStripLen + "\n" + "avg strip length:     " + (double)this.totalTris / (double)this.numStrips + "\n" + "avg num verts/tri:    " + (double)this.numVerts / (double)this.totalTris + "\n" + "total time:           " + this.time + "\n" + "strip length distribution:\n");
        for (int i = 0; i < 9; ++i) {
            str.append("  " + (i + 1) + "=" + this.counts[i]);
        }
        str.append("  10-19=" + this.counts[9]);
        str.append("  20-49=" + this.counts[10]);
        str.append("  50-99=" + this.counts[11]);
        str.append("  100-999=" + this.counts[12]);
        str.append("  1000 or more=" + this.counts[13] + "\n");
        return str.toString();
    }

    public void clearData() {
        this.noData = true;
        this.numStrips = 0;
        this.numVerts = 0;
        this.minStripLen = 10000;
        this.maxStripLen = 0;
        this.totalTris = 0;
        this.numFaces = 0;
        this.time = 0L;
        this.counts = new int[14];
    }

    void updateInfo(long ntime, ArrayList strips, int nNumFaces) {
        this.noData = false;
        this.time += ntime;
        this.numStrips += strips.size();
        int nv = 0;
        int mnsl = 10000;
        int mxsl = 0;
        int tt = 0;
        for (int i = 0; i < strips.size(); ++i) {
            Stripifier.Istream strm = (Stripifier.Istream)strips.get(i);
            int len = strm.length;
            int trilen = len - 2;
            nv += len;
            if (trilen < mnsl) {
                mnsl = trilen;
            }
            if (trilen > mxsl) {
                mxsl = trilen;
            }
            tt += trilen;
            if (trilen <= 9) {
                int n = trilen - 1;
                this.counts[n] = this.counts[n] + 1;
                continue;
            }
            if (trilen < 20) {
                this.counts[9] = this.counts[9] + 1;
                continue;
            }
            if (trilen < 50) {
                this.counts[10] = this.counts[10] + 1;
                continue;
            }
            if (trilen < 100) {
                this.counts[11] = this.counts[11] + 1;
                continue;
            }
            if (trilen < 1000) {
                this.counts[12] = this.counts[12] + 1;
                continue;
            }
            this.counts[13] = this.counts[13] + 1;
        }
        this.numVerts += nv;
        if (mnsl < this.minStripLen) {
            this.minStripLen = mnsl;
        }
        if (mxsl > this.maxStripLen) {
            this.maxStripLen = mxsl;
        }
        this.totalTris += tt;
        this.numFaces += nNumFaces;
    }

    void updateInfo(long ntime, int scLen, int[] sc, int nNumFaces) {
        this.noData = false;
        this.time += ntime;
        this.numStrips += scLen;
        int nv = 0;
        int mnsl = 10000;
        int mxsl = 0;
        int tt = 0;
        for (int i = 0; i < scLen; ++i) {
            int len = sc[i];
            int trilen = len - 2;
            this.numVerts += len;
            if (trilen < mnsl) {
                mnsl = trilen;
            }
            if (trilen > mxsl) {
                mxsl = trilen;
            }
            this.totalTris += trilen;
            if (trilen <= 9) {
                int n = trilen - 1;
                this.counts[n] = this.counts[n] + 1;
                continue;
            }
            if (trilen < 20) {
                this.counts[9] = this.counts[9] + 1;
                continue;
            }
            if (trilen < 50) {
                this.counts[10] = this.counts[10] + 1;
                continue;
            }
            if (trilen < 100) {
                this.counts[11] = this.counts[11] + 1;
                continue;
            }
            if (trilen < 1000) {
                this.counts[12] = this.counts[12] + 1;
                continue;
            }
            this.counts[13] = this.counts[13] + 1;
        }
        this.numVerts += nv;
        if (mnsl < this.minStripLen) {
            this.minStripLen = mnsl;
        }
        if (mxsl > this.maxStripLen) {
            this.maxStripLen = mxsl;
        }
        this.totalTris += tt;
        this.numFaces += nNumFaces;
    }

    StripifierStats() {
    }
}

