/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.utils.universe;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.HiResCoord;
import org.scijava.java3d.Locale;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.SceneGraphObjectState;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.utils.universe.PlatformGeometryState;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.utils.universe.ViewerAvatarState;
import org.scijava.java3d.utils.universe.ConfiguredUniverse;
import org.scijava.java3d.utils.universe.MultiTransformGroup;
import org.scijava.java3d.utils.universe.PlatformGeometry;
import org.scijava.java3d.utils.universe.SimpleUniverse;
import org.scijava.java3d.utils.universe.ViewerAvatar;
import org.scijava.java3d.utils.universe.ViewingPlatform;
import org.scijava.vecmath.Matrix4d;

public class SimpleUniverseState {
    private SimpleUniverse universe = null;
    private Controller control;
    private ArrayList localeBGs;
    private int totalBGs = 0;
    private PlatformGeometryState platformGeom;
    private ViewerAvatarState viewerAvatar;

    public SimpleUniverseState(ConfiguredUniverse universe, Controller control) {
        this.universe = universe;
        this.control = control;
    }

    public SimpleUniverseState(SimpleUniverse universe, Controller control) {
        this.universe = universe;
        this.control = control;
    }

    public SimpleUniverseState(Controller control) {
        this.control = control;
    }

    public void writeObject(DataOutput out) throws IOException {
        MultiTransformGroup mtg = this.universe.getViewingPlatform().getMultiTransformGroup();
        int mtgSize = mtg.getNumTransforms();
        out.writeInt(mtgSize);
        Transform3D trans = new Transform3D();
        Matrix4d matrix = new Matrix4d();
        for (int i = 0; i < mtgSize; ++i) {
            TransformGroup tg = mtg.getTransformGroup(i);
            tg.getTransform(trans);
            trans.get(matrix);
            this.control.writeMatrix4d(out, matrix);
        }
        this.control.writeObject(out, this.control.createState(this.universe.getViewingPlatform().getPlatformGeometry()));
        this.control.writeObject(out, this.control.createState(this.universe.getViewer().getAvatar()));
        this.writeLocales(out);
    }

    public void readObject(DataInput in, Canvas3D canvas) throws IOException {
        int mtgSize = in.readInt();
        this.universe = canvas != null ? new ConfiguredUniverse(canvas, mtgSize) : new ConfiguredUniverse(ConfiguredUniverse.getConfigURL(), mtgSize);
        MultiTransformGroup mtg = this.universe.getViewingPlatform().getMultiTransformGroup();
        Matrix4d matrix = new Matrix4d();
        for (int i = 0; i < mtgSize; ++i) {
            TransformGroup tg = mtg.getTransformGroup(i);
            matrix = this.control.readMatrix4d(in);
            Transform3D trans = new Transform3D(matrix);
            tg.setTransform(trans);
        }
        SceneGraphObjectState tmp = this.control.readObject(in);
        this.platformGeom = tmp instanceof PlatformGeometryState ? (PlatformGeometryState)tmp : null;
        tmp = this.control.readObject(in);
        this.viewerAvatar = tmp instanceof ViewerAvatarState ? (ViewerAvatarState)tmp : null;
        this.readLocales(in);
    }

    private void writeLocales(DataOutput out) throws IOException {
        Enumeration<Locale> allLocales = this.universe.getAllLocales();
        out.writeInt(this.universe.numLocales());
        this.localeBGs = new ArrayList(this.universe.numLocales());
        boolean currentLocale = false;
        int graphID = 0;
        while (allLocales.hasMoreElements()) {
            Locale locale = allLocales.nextElement();
            HiResCoord hiRes = new HiResCoord();
            this.writeHiResCoord(out, hiRes);
            int[] bgs = !currentLocale ? new int[locale.numBranchGraphs() - 1] : new int[locale.numBranchGraphs()];
            out.writeInt(bgs.length);
            int count = 0;
            Enumeration e = locale.getAllBranchGraphs();
            while (e.hasMoreElements()) {
                BranchGroup bg = (BranchGroup)e.nextElement();
                if (bg instanceof ViewingPlatform) continue;
                this.control.getSymbolTable().addBranchGraphReference(bg, graphID);
                bgs[count] = graphID++;
                out.writeInt(bgs[count]);
                ++count;
                ++this.totalBGs;
            }
            this.localeBGs.add(bgs);
        }
    }

    private void readLocales(DataInput in) throws IOException {
        int numLocales = in.readInt();
        this.localeBGs = new ArrayList(numLocales);
        for (int i = 0; i < numLocales; ++i) {
            Locale locale;
            HiResCoord hiRes = this.readHiResCoord(in);
            if (i == 0) {
                locale = this.universe.getLocale();
                locale.setHiRes(hiRes);
            } else {
                locale = new Locale(this.universe, hiRes);
            }
            int numBG = in.readInt();
            int[] bgs = new int[numBG];
            for (int n = 0; n < numBG; ++n) {
                bgs[i] = in.readInt();
                ++this.totalBGs;
            }
            this.localeBGs.add(bgs);
        }
    }

    public void buildGraph() {
        Enumeration<Locale> e = this.universe.getAllLocales();
        for (int i = 0; i < this.localeBGs.size(); ++i) {
            Locale locale = e.nextElement();
            int[] bgs = (int[])this.localeBGs.get(i);
            for (int j = 0; j < bgs.length; ++j) {
                SymbolTableData symbol = this.control.getSymbolTable().getBranchGraphRoot(bgs[j]);
                locale.addBranchGraph((BranchGroup)symbol.j3dNode);
            }
        }
        if (this.viewerAvatar != null) {
            this.viewerAvatar.buildGraph();
            this.universe.getViewer().setAvatar((ViewerAvatar)this.viewerAvatar.getNode());
        }
        if (this.platformGeom != null) {
            this.universe.getViewingPlatform().setPlatformGeometry((PlatformGeometry)this.platformGeom.getNode());
            this.platformGeom.buildGraph();
        }
    }

    public int[] getAllGraphIDs() {
        int[] ret = new int[this.totalBGs];
        int c = 0;
        for (int i = 0; i < this.localeBGs.size(); ++i) {
            int[] bgs = (int[])this.localeBGs.get(i);
            for (int j = 0; j < bgs.length; ++j) {
                ret[c++] = bgs[j];
            }
        }
        return ret;
    }

    public void detachAllGraphs() {
        boolean c = false;
        try {
            for (int i = 0; i < this.localeBGs.size(); ++i) {
                int[] bgs = (int[])this.localeBGs.get(i);
                for (int j = 0; j < bgs.length; ++j) {
                    SymbolTableData symbol = this.control.getSymbolTable().getBranchGraphRoot(bgs[j]);
                    ((BranchGroup)symbol.j3dNode).detach();
                }
            }
        }
        catch (CapabilityNotSetException e) {
            throw new CapabilityNotSetException("Locale BranchGraphs MUST have ALLOW_DETACH capability set");
        }
    }

    public void attachAllGraphs() {
        Enumeration<Locale> e = this.universe.getAllLocales();
        for (int i = 0; i < this.localeBGs.size(); ++i) {
            Locale locale = e.nextElement();
            int[] bgs = (int[])this.localeBGs.get(i);
            for (int j = 0; j < bgs.length; ++j) {
                SymbolTableData symbol = this.control.getSymbolTable().getBranchGraphRoot(bgs[j]);
                locale.addBranchGraph((BranchGroup)symbol.j3dNode);
            }
        }
    }

    public ConfiguredUniverse getNode() {
        if (this.universe instanceof ConfiguredUniverse) {
            return (ConfiguredUniverse)this.universe;
        }
        return null;
    }

    private void writeHiResCoord(DataOutput out, HiResCoord hiRes) throws IOException {
        int[] x = new int[8];
        int[] y = new int[8];
        int[] z = new int[8];
        hiRes.getHiResCoord(x, y, z);
        for (int i = 0; i < 8; ++i) {
            out.writeInt(x[i]);
            out.writeInt(y[i]);
            out.writeInt(z[i]);
        }
    }

    private HiResCoord readHiResCoord(DataInput in) throws IOException {
        int[] x = new int[8];
        int[] y = new int[8];
        int[] z = new int[8];
        for (int i = 0; i < 8; ++i) {
            x[i] = in.readInt();
            y[i] = in.readInt();
            z[i] = in.readInt();
        }
        return new HiResCoord(x, y, z);
    }
}

