/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;

@Deprecated
public final class MergeIterableIntervals<T extends RealType<T>>
implements UnaryOutputOperation<IterableInterval<T>[], Img<T>> {
    private final ImgFactory<T> m_factory;
    private final boolean m_adjustDimensionality;
    private ArrayList<Integer> m_invalidDims;

    public MergeIterableIntervals(ImgFactory<T> factory, boolean adjustDimensionality) {
        this.m_factory = factory;
        this.m_adjustDimensionality = adjustDimensionality;
    }

    @Override
    public final Img<T> createEmptyOutput(IterableInterval<T>[] src) {
        long[] resDims = this.initConstants(src);
        return this.m_factory.create(resDims, (Object)((RealType)src[0].firstElement()).createVariable());
    }

    private long[] initConstants(IterableInterval<T>[] src) {
        int numMaxDims = 0;
        for (IterableInterval<T> interval : src) {
            numMaxDims = Math.max(interval.numDimensions(), numMaxDims);
        }
        HashSet[] setDims = new HashSet[numMaxDims];
        for (int s = 0; s < setDims.length; ++s) {
            setDims[s] = new HashSet();
        }
        for (IterableInterval<T> interval : src) {
            for (int d = 0; d < interval.numDimensions(); ++d) {
                for (long i = interval.min(d); i <= interval.max(d); ++i) {
                    setDims[d].add(i);
                }
            }
        }
        this.m_invalidDims = new ArrayList();
        if (this.m_adjustDimensionality) {
            for (int d = 0; d < setDims.length; ++d) {
                if (setDims[d].size() != 1) continue;
                this.m_invalidDims.add(d);
            }
        }
        long[] resDims = new long[numMaxDims - this.m_invalidDims.size()];
        int k = 0;
        for (int d = 0; d < numMaxDims; ++d) {
            if (this.m_invalidDims.contains(d)) continue;
            resDims[k++] = setDims[d].size();
        }
        return resDims;
    }

    @Override
    public final Img<T> compute(IterableInterval<T>[] intervals, Img<T> res) {
        if (this.m_invalidDims == null) {
            this.initConstants(intervals);
        }
        if (res.numDimensions() == 0) {
            return res;
        }
        RandomAccess randomAccess = res.randomAccess();
        Arrays.sort(intervals, new Comparator<Interval>(){

            @Override
            public int compare(Interval o1, Interval o2) {
                for (int d = 0; d < Math.min(o1.numDimensions(), o2.numDimensions()); ++d) {
                    if (o1.min(d) == o2.min(d)) continue;
                    return (int)o1.min(d) - (int)o2.min(d);
                }
                return 0;
            }
        });
        long[] offset = new long[intervals[0].numDimensions()];
        long[] intervalWidth = new long[intervals[0].numDimensions()];
        intervals[0].min(offset);
        intervals[0].dimensions(intervalWidth);
        this.writeInterval(randomAccess, intervals[0], offset);
        for (int i = 1; i < intervals.length; ++i) {
            for (int d = 0; d < intervals[i].numDimensions(); ++d) {
                if (intervals[i].min(d) == intervals[i - 1].min(d)) continue;
                for (int innerD = d + 1; innerD < intervals[i].numDimensions(); ++innerD) {
                    intervalWidth[innerD] = 0L;
                }
                offset[d] = intervals[i].min(d) - intervalWidth[d];
                int n = d;
                intervalWidth[n] = intervalWidth[n] + intervals[i].dimension(d);
            }
            this.writeInterval(randomAccess, intervals[i], offset);
        }
        return res;
    }

    private void writeInterval(RandomAccess<T> resAccess, IterableInterval<T> interval, long[] offset) {
        Cursor localizingCursor = interval.localizingCursor();
        while (localizingCursor.hasNext()) {
            localizingCursor.fwd();
            int offsetCtr = 0;
            for (int d = 0; d < interval.numDimensions(); ++d) {
                if (this.m_invalidDims.contains(d)) {
                    ++offsetCtr;
                    continue;
                }
                resAccess.setPosition((long)localizingCursor.getIntPosition(d) - offset[d], d - offsetCtr);
            }
            ((RealType)resAccess.get()).set((Type)localizingCursor.get());
        }
    }

    @Override
    public UnaryOutputOperation<IterableInterval<T>[], Img<T>> copy() {
        return new MergeIterableIntervals<T>(this.m_factory, this.m_adjustDimensionality);
    }

    @Override
    public Img<T> compute(IterableInterval<T>[] in) {
        return this.compute(in, this.createEmptyOutput(in));
    }

    public List<Integer> getInvalidDims() {
        return this.m_invalidDims;
    }
}

