/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bdv.gui.FieldOfViewPanel;
import bdv.ij.ApplyBigwarpPlugin;
import bdv.ij.BigWarpToDeformationFieldPlugIn;
import bdv.viewer.Source;
import bigwarp.BigWarp;
import bigwarp.BigWarpData;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.transforms.BigWarpTransform;
import com.formdev.flatlaf.util.UIScale;
import ij.IJ;
import ij.Macro;
import ij.plugin.frame.Recorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportDisplacementFieldFrame
extends JFrame {
    private static final long serialVersionUID = -6179153725489981013L;
    public static final String FMT_NGFF = "NGFF";
    public static final String FMT_BIGWARP_TPS = "TPS";
    public static final String FMT_N5 = "N5";
    public static final String FMT_SLICER = "Slicer";
    public static final String commandName = "Big Warp to Displacement field";
    protected static final String landmarksKey = "landmarks";
    protected static final String splitAffineKey = "split_affine";
    protected static final String typeKey = "type";
    protected static final String dtypeKey = "dataType";
    protected static final String quantizationErrorKey = "quantizationError";
    protected static final String directionKey = "direction";
    protected static final String inverseToleranceKey = "inverseTolerance";
    protected static final String inverseMaxIterationsKey = "inverseMaxIterations";
    protected static final String virtualKey = "virtual";
    protected static final String threadsKey = "threads";
    protected static final String formatKey = "format";
    protected static final String sizeKey = "pixel_size";
    protected static final String spacingKey = "pixel_spacing";
    protected static final String minKey = "min";
    protected static final String unitKey = "unit";
    protected static final String n5RootKey = "n5_root";
    protected static final String n5DatasetKey = "n5_dataset";
    protected static final String n5BlockSizeKey = "n5_block_size";
    protected static final String n5CompressionKey = "n5_compression";
    private String lastBrowsePath = null;
    private String initialPath = "";
    private Consumer<BigWarpToDeformationFieldPlugIn.DeformationFieldExportParameters> okayCallback;
    private Consumer<BigWarpToDeformationFieldPlugIn.DeformationFieldExportParameters> cancelCallback;
    private BigWarpData<?> data;
    private BigWarpTransform bwTransform;
    private LandmarkTableModel ltm;
    private boolean imageJOpen = IJ.getInstance() != null;
    private boolean initialRecorderState;
    private boolean n5DatasetChanged;
    private DocumentListener docListener;
    private JPanel contentPanel;
    private JPanel invPanel;
    private JTextField landmarkPathTxt;
    private JButton browseLandmarksButton;
    private JTextField n5RootTxt;
    private JButton browseN5Button;
    private JTextField n5DatasetTxt;
    private JTextField n5BlockSizeTxt;
    private JComboBox<String> n5CompressionDropdown;
    private JCheckBox splitAffineCheckBox;
    private JCheckBox virtualCheckBox;
    private JComboBox<DTYPE> dataTypeComboBox;
    private JSpinner quantizationErrorSpinner;
    private JComboBox<String> typeComboBox;
    private JComboBox<String> directionComboBox;
    private JSpinner nThreadsField;
    private JComboBox<String> formatComboBox;
    private JButton okBtn;
    private JButton cancelBtn;
    private JSpinner invMaxIterationsSpinner;
    private JSpinner invToleranceSpinner;
    private FieldOfViewPanel fovPanel;
    private static final String TYPE_HELP_TEXT = "\"Flat\" combines all transformations into a single displacement field. \"Sequence\" keeps the components separate (e.g. affine, nonlinear).";
    private static final String DTYPE_HELP_TEXT = "The data type used to store the displacement field.";
    private static final String DIRECTION_HELP_TEXT = "";

    public ExportDisplacementFieldFrame(BigWarp<?> bw) {
        this(bw.getData(), bw.getBwTransform(), bw.getLandmarkPanel().getTableModel());
    }

    public ExportDisplacementFieldFrame(BigWarpData<?> data, BigWarpTransform bwTransform, LandmarkTableModel ltm) {
        super("Export transformation");
        this.data = data;
        this.bwTransform = bwTransform;
        this.ltm = ltm;
        this.cancelCallback = x -> {
            this.dispose();
            this.setVisible(false);
            Recorder.record = this.initialRecorderState;
        };
        this.okayCallback = x -> {
            this.macroRecord();
            this.run();
            Recorder.record = this.initialRecorderState;
            this.dispose();
            this.setVisible(false);
        };
        this.docListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportDisplacementFieldFrame.this.n5DatasetChanged = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportDisplacementFieldFrame.this.n5DatasetChanged = true;
            }
        };
    }

    public static void createAndShow() {
        ExportDisplacementFieldFrame.createAndShow(null, null, null);
    }

    public static void createAndShow(BigWarp<?> bw) {
        ExportDisplacementFieldFrame frame = new ExportDisplacementFieldFrame(bw);
        frame = bw == null ? new ExportDisplacementFieldFrame(null, null, null) : new ExportDisplacementFieldFrame(bw);
        frame.createContent();
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public static void createAndShow(BigWarpData<?> data, BigWarpTransform bwTransform, LandmarkTableModel ltm) {
        ExportDisplacementFieldFrame frame = new ExportDisplacementFieldFrame(data, bwTransform, ltm);
        frame.createContent();
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void createContent() {
        boolean isNonlinear = this.bwTransform.isNonlinear();
        this.n5DatasetChanged = false;
        int frameSizeX = UIScale.scale((int)600);
        JPanel panel = this.basicPanel();
        this.invPanel = this.inverseOptionsPanel(frameSizeX);
        this.invPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Inverse options"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        JPanel n5Panel = this.n5OptionsPanel(frameSizeX);
        n5Panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "N5 options"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        String unit = "pixel";
        if (this.data != null) {
            Source src = this.data.getMovingSource(0).getSpimSource();
            unit = src.getVoxelDimensions().unit();
        }
        if (isNonlinear) {
            this.fovPanel = new FieldOfViewPanel(this.data, this.ltm, this.bwTransform, unit, 150, new double[]{0.0, 0.0, 0.0}, new double[]{1.0, 1.0, 1.0}, new long[]{256L, 256L, 128L});
            this.fovPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Field of view"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        }
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints cGbc = new GridBagConstraints();
        cGbc.gridx = 0;
        cGbc.gridwidth = 4;
        cGbc.fill = 2;
        cGbc.gridy = 0;
        this.contentPanel.add((Component)panel, cGbc);
        cGbc.gridy = 1;
        this.contentPanel.add((Component)this.invPanel, cGbc);
        this.invPanel.setEnabled(false);
        this.invPanel.setVisible(false);
        cGbc.gridy = 2;
        this.contentPanel.add((Component)n5Panel, cGbc);
        cGbc.gridy = 3;
        if (isNonlinear) {
            this.contentPanel.add((Component)this.fovPanel, cGbc);
        }
        GridBagConstraints cbot = new GridBagConstraints();
        cbot.gridx = 0;
        cbot.gridy = 4;
        cbot.gridwidth = 1;
        cbot.gridheight = 1;
        cbot.weightx = 1.0;
        cbot.weighty = 0.0;
        cbot.fill = 0;
        this.okBtn = new JButton("OK");
        this.okBtn.setPreferredSize(new Dimension(this.okBtn.getPreferredSize().width, this.okBtn.getPreferredSize().height));
        this.okBtn.addActionListener(e -> this.okayCallback.accept(this.getParams()));
        cbot.gridx = 2;
        cbot.gridwidth = 1;
        cbot.insets = new Insets(20, (int)((double)frameSizeX * 0.8), 20, 2);
        cbot.anchor = 22;
        this.contentPanel.add((Component)this.okBtn, cbot);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setPreferredSize(new Dimension(this.cancelBtn.getPreferredSize().width, this.cancelBtn.getPreferredSize().height));
        this.cancelBtn.addActionListener(e -> this.cancelCallback.accept(null));
        cbot.gridx = 3;
        cbot.anchor = 21;
        cbot.ipadx = 0;
        cbot.insets = new Insets(2, 2, 2, 2);
        this.contentPanel.add((Component)this.cancelBtn, cbot);
        Container content = this.getContentPane();
        content.add(this.contentPanel);
        if (isNonlinear) {
            if (this.data != null) {
                double[] res = ApplyBigwarpPlugin.getResolution(this.data, "Target", null);
                this.fovPanel.setSpacing(res);
                this.fovPanel.updateFieldsFromReference();
            } else {
                this.fovPanel.updateFieldsFromImageJReference();
            }
        }
        this.addDefaultN5DatasetAction();
    }

    public JPanel basicPanel() {
        int OUTER_PAD = 8;
        int BUTTON_PAD = 3;
        int MID_PAD = 5;
        Insets defaultInsets = new Insets(8, 3, 5, 3);
        Insets leftInsets = new Insets(8, 30, 5, 3);
        Insets rightInsets = new Insets(8, 3, 5, 30);
        int szX = UIScale.scale((int)600);
        JPanel panel = new JPanel(false);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints ctxt = new GridBagConstraints();
        ctxt.gridx = 0;
        ctxt.gridy = 0;
        ctxt.gridwidth = 1;
        ctxt.gridheight = 1;
        ctxt.weightx = 0.0;
        ctxt.weighty = 0.0;
        ctxt.anchor = 22;
        ctxt.fill = 0;
        ctxt.insets = defaultInsets;
        GridBagConstraints gbcBar = new GridBagConstraints();
        gbcBar.gridx = 1;
        gbcBar.gridy = 0;
        gbcBar.gridwidth = 6;
        gbcBar.gridheight = 1;
        gbcBar.weightx = 1.0;
        gbcBar.weighty = 0.0;
        gbcBar.fill = 2;
        gbcBar.insets = defaultInsets;
        GridBagConstraints cProjBrowse = new GridBagConstraints();
        cProjBrowse.gridx = 7;
        cProjBrowse.gridy = 0;
        cProjBrowse.gridwidth = 1;
        cProjBrowse.weightx = 0.0;
        cProjBrowse.fill = 2;
        cProjBrowse.insets = defaultInsets;
        if (this.bwTransform == null) {
            panel.add((Component)new JLabel("Landmarks:"), ctxt);
            this.landmarkPathTxt = new JTextField();
            this.landmarkPathTxt.setPreferredSize(new Dimension(szX / 3, this.landmarkPathTxt.getPreferredSize().height));
            panel.add((Component)this.landmarkPathTxt, gbcBar);
            this.browseLandmarksButton = new JButton("Browse");
            this.browseLandmarksButton.addActionListener(e -> this.browseLandmarksDialog());
            panel.add((Component)this.browseLandmarksButton, cProjBrowse);
        }
        ctxt.gridx = 0;
        ctxt.gridy = 1;
        ctxt.anchor = 22;
        JLabel typeLabel = new JLabel("Type:");
        typeLabel.setToolTipText(TYPE_HELP_TEXT);
        panel.add((Component)typeLabel, ctxt);
        GridBagConstraints gbcCheck = new GridBagConstraints();
        gbcCheck.gridx = 1;
        gbcCheck.gridy = 1;
        gbcCheck.insets = defaultInsets;
        gbcCheck.anchor = 21;
        this.typeComboBox = new JComboBox<String>(new String[]{"Flat", "Sequence"});
        panel.add(this.typeComboBox, gbcCheck);
        ctxt.gridx = 3;
        ctxt.insets = new Insets(8, 30, 5, 3);
        panel.add((Component)new JLabel("Direction:"), ctxt);
        ctxt.insets = defaultInsets;
        gbcCheck.gridx = 4;
        this.directionComboBox = new JComboBox<String>(new String[]{BigWarpToDeformationFieldPlugIn.INVERSE_OPTIONS.FORWARD.toString(), BigWarpToDeformationFieldPlugIn.INVERSE_OPTIONS.INVERSE.toString(), BigWarpToDeformationFieldPlugIn.INVERSE_OPTIONS.BOTH.toString()});
        panel.add(this.directionComboBox, gbcCheck);
        GridBagConstraints gbcQuantization = new GridBagConstraints();
        gbcQuantization.gridx = 5;
        gbcQuantization.gridy = 1;
        gbcQuantization.insets = leftInsets;
        gbcQuantization.anchor = 22;
        panel.add((Component)new JLabel("Data type:"), gbcQuantization);
        this.dataTypeComboBox = new JComboBox<DTYPE>(new DTYPE[]{DTYPE.BYTE, DTYPE.SHORT, DTYPE.FLOAT, DTYPE.DOUBLE});
        this.dataTypeComboBox.setSelectedItem((Object)DTYPE.FLOAT);
        gbcQuantization.gridx = 6;
        gbcQuantization.insets = rightInsets;
        gbcQuantization.anchor = 21;
        panel.add(this.dataTypeComboBox, gbcQuantization);
        ctxt.gridx = 7;
        ctxt.anchor = 22;
        panel.add((Component)new JLabel("Split affine:"), ctxt);
        gbcCheck.gridx = 8;
        this.splitAffineCheckBox = new JCheckBox();
        panel.add((Component)this.splitAffineCheckBox, gbcCheck);
        ctxt.gridx = 0;
        ctxt.gridy = 2;
        ctxt.anchor = 22;
        panel.add((Component)new JLabel("Threads:"), ctxt);
        gbcCheck.gridx = 1;
        gbcCheck.gridy = 2;
        gbcCheck.fill = 2;
        this.nThreadsField = new JSpinner(new SpinnerNumberModel(1, 1, 9999, 1));
        panel.add((Component)this.nThreadsField, gbcCheck);
        ctxt.gridx = 3;
        panel.add((Component)new JLabel("Format:"), ctxt);
        gbcCheck.gridx = 4;
        this.formatComboBox = new JComboBox<String>(new String[]{FMT_NGFF, FMT_N5, FMT_BIGWARP_TPS});
        panel.add(this.formatComboBox, gbcCheck);
        gbcQuantization.gridx = 5;
        gbcQuantization.gridy = 2;
        gbcQuantization.insets = leftInsets;
        gbcQuantization.anchor = 22;
        panel.add((Component)new JLabel("Error:"), gbcQuantization);
        gbcQuantization.gridx = 6;
        gbcQuantization.insets = rightInsets;
        this.quantizationErrorSpinner = new JSpinner(new SpinnerNumberModel(0.01, 1.0E-9, 999.0, 0.001));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.quantizationErrorSpinner, "#.######");
        JFormattedTextField textField = editor.getTextField();
        textField.setColumns(6);
        this.quantizationErrorSpinner.setEditor(editor);
        panel.add((Component)this.quantizationErrorSpinner, gbcQuantization);
        ctxt.gridx = 7;
        ctxt.anchor = 22;
        ctxt.insets = new Insets(8, 3, 5, 3);
        ctxt.weightx = 0.1;
        panel.add((Component)new JLabel("Virtual:"), ctxt);
        gbcCheck.gridx = 8;
        gbcCheck.weightx = 0.1;
        this.virtualCheckBox = new JCheckBox();
        panel.add((Component)this.virtualCheckBox, gbcCheck);
        return panel;
    }

    public JPanel inverseOptionsPanel(int frameSizeX) {
        int OUTER_PAD = 8;
        int BUTTON_PAD = 3;
        int MID_PAD = 5;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints ctxt = new GridBagConstraints();
        ctxt.gridx = 0;
        ctxt.gridy = 0;
        ctxt.gridwidth = 1;
        ctxt.gridheight = 1;
        ctxt.weightx = 0.0;
        ctxt.weighty = 0.0;
        ctxt.anchor = 22;
        ctxt.fill = 0;
        ctxt.insets = new Insets(8, 8, 5, 3);
        GridBagConstraints gbcBar = new GridBagConstraints();
        gbcBar.gridx = 1;
        gbcBar.gridy = 0;
        gbcBar.gridwidth = 1;
        gbcBar.gridheight = 1;
        gbcBar.weightx = 1.0;
        gbcBar.weighty = 0.0;
        gbcBar.fill = 2;
        gbcBar.insets = new Insets(8, 8, 5, 3);
        ctxt.gridx = 0;
        ctxt.anchor = 22;
        panel.add((Component)new JLabel("Tolerance:"), ctxt);
        gbcBar.gridx = 1;
        gbcBar.fill = 2;
        this.invToleranceSpinner = new JSpinner(new SpinnerNumberModel(0.5, 1.0E-9, 999999.0, 0.01));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.invToleranceSpinner, "###,###.######");
        JFormattedTextField textField = editor.getTextField();
        textField.setColumns(12);
        this.invToleranceSpinner.setEditor(editor);
        panel.add((Component)this.invToleranceSpinner, gbcBar);
        ctxt.gridx = 3;
        ctxt.anchor = 22;
        panel.add((Component)new JLabel("Max iterations:"), ctxt);
        gbcBar.gridx = 4;
        gbcBar.fill = 2;
        this.invMaxIterationsSpinner = new JSpinner(new SpinnerNumberModel(200, 1, 999999, 1));
        panel.add((Component)this.invMaxIterationsSpinner, gbcBar);
        return panel;
    }

    public JPanel n5OptionsPanel(int frameSizeX) {
        int OUTER_PAD = 8;
        int BUTTON_PAD = 3;
        int MID_PAD = 5;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints ctxt = new GridBagConstraints();
        ctxt.gridx = 0;
        ctxt.gridy = 0;
        ctxt.gridwidth = 1;
        ctxt.gridheight = 1;
        ctxt.weightx = 0.0;
        ctxt.weighty = 0.0;
        ctxt.anchor = 22;
        ctxt.fill = 0;
        ctxt.insets = new Insets(8, 8, 5, 3);
        panel.add((Component)new JLabel("Root folder:"), ctxt);
        GridBagConstraints gbcBar = new GridBagConstraints();
        gbcBar.gridx = 1;
        gbcBar.gridy = 0;
        gbcBar.gridwidth = 6;
        gbcBar.gridheight = 1;
        gbcBar.weightx = 1.0;
        gbcBar.weighty = 0.0;
        gbcBar.fill = 2;
        gbcBar.insets = new Insets(8, 8, 5, 3);
        this.n5RootTxt = new JTextField();
        this.n5RootTxt.setPreferredSize(new Dimension(frameSizeX / 3, this.n5RootTxt.getPreferredSize().height));
        panel.add((Component)this.n5RootTxt, gbcBar);
        GridBagConstraints cProjBrowse = new GridBagConstraints();
        cProjBrowse.gridx = 7;
        cProjBrowse.gridy = 0;
        cProjBrowse.gridwidth = 1;
        cProjBrowse.weightx = 0.0;
        cProjBrowse.fill = 2;
        cProjBrowse.insets = new Insets(8, 3, 5, 3);
        this.browseN5Button = new JButton("Browse");
        this.browseN5Button.addActionListener(e -> this.browseN5Root());
        panel.add((Component)this.browseN5Button, cProjBrowse);
        ctxt.gridy = 1;
        panel.add((Component)new JLabel("Dataset:"), ctxt);
        gbcBar.gridy = 1;
        this.n5DatasetTxt = new JTextField();
        this.n5DatasetTxt.setPreferredSize(new Dimension(frameSizeX / 3, this.n5DatasetTxt.getPreferredSize().height));
        this.n5DatasetTxt.setText("dfield");
        this.n5DatasetTxt.getDocument().addDocumentListener(this.docListener);
        panel.add((Component)this.n5DatasetTxt, gbcBar);
        ctxt.gridy = 2;
        panel.add((Component)new JLabel("Block size:"), ctxt);
        gbcBar.gridy = 2;
        this.n5BlockSizeTxt = new JTextField();
        this.n5BlockSizeTxt.setPreferredSize(new Dimension(frameSizeX / 3, this.n5BlockSizeTxt.getPreferredSize().height));
        this.n5BlockSizeTxt.setText("64");
        panel.add((Component)this.n5BlockSizeTxt, gbcBar);
        ctxt.gridy = 3;
        panel.add((Component)new JLabel("Compression"), ctxt);
        gbcBar.gridy = 3;
        gbcBar.fill = 0;
        gbcBar.anchor = 21;
        this.n5CompressionDropdown = new JComboBox<String>(BigWarpToDeformationFieldPlugIn.compressionOptions);
        panel.add(this.n5CompressionDropdown, gbcBar);
        return panel;
    }

    private void addDefaultN5DatasetAction() {
        this.directionComboBox.addActionListener(e -> {
            if (this.n5DatasetChanged) {
                return;
            }
            String item = (String)this.directionComboBox.getSelectedItem();
            if (item.equals(BigWarpToDeformationFieldPlugIn.INVERSE_OPTIONS.FORWARD.toString())) {
                this.n5DatasetTxt.getDocument().removeDocumentListener(this.docListener);
                this.n5DatasetTxt.setText("dfield");
                this.n5DatasetTxt.getDocument().addDocumentListener(this.docListener);
                SwingUtilities.invokeLater(() -> {
                    this.invPanel.setEnabled(false);
                    this.invPanel.setVisible(false);
                    this.contentPanel.revalidate();
                    this.contentPanel.repaint();
                    this.pack();
                });
            } else if (item.equals(BigWarpToDeformationFieldPlugIn.INVERSE_OPTIONS.INVERSE.toString())) {
                this.n5DatasetTxt.getDocument().removeDocumentListener(this.docListener);
                this.n5DatasetTxt.setText("invdfield");
                this.n5DatasetTxt.getDocument().addDocumentListener(this.docListener);
                SwingUtilities.invokeLater(() -> {
                    this.invPanel.setEnabled(true);
                    this.invPanel.setVisible(true);
                    this.contentPanel.revalidate();
                    this.contentPanel.repaint();
                    this.pack();
                });
            } else if (item.equals(BigWarpToDeformationFieldPlugIn.INVERSE_OPTIONS.BOTH.toString())) {
                this.n5DatasetTxt.getDocument().removeDocumentListener(this.docListener);
                this.n5DatasetTxt.setText("transform");
                this.n5DatasetTxt.getDocument().addDocumentListener(this.docListener);
                SwingUtilities.invokeLater(() -> {
                    this.invPanel.setEnabled(true);
                    this.invPanel.setVisible(true);
                    this.contentPanel.revalidate();
                    this.contentPanel.repaint();
                    this.pack();
                });
            }
        });
    }

    private String browseLandmarksDialog() {
        String s = this.browseDialogGeneral(0, new FileNameExtensionFilter("csv file", "csv"));
        this.landmarkPathTxt.setText(s);
        return s;
    }

    private String browseN5Root() {
        String s = this.browseDialogGeneral(2, null);
        this.n5RootTxt.setText(s);
        return s;
    }

    private String browseDialogGeneral(int mode, FileFilter filefilter) {
        String path;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(mode);
        if (filefilter == null) {
            fileChooser.setFileFilter(filefilter);
        }
        if (this.lastBrowsePath != null && !this.lastBrowsePath.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(this.lastBrowsePath));
        } else if (this.initialPath != null && !this.initialPath.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(this.initialPath));
        } else if (this.imageJOpen) {
            File f = null;
            String currDir = IJ.getDirectory((String)"current");
            String homeDir = IJ.getDirectory((String)"home");
            if (currDir != null) {
                f = new File(currDir);
            } else if (homeDir != null) {
                f = new File(homeDir);
            }
            fileChooser.setCurrentDirectory(f);
        }
        int ret = fileChooser.showOpenDialog(this);
        if (ret != 0) {
            return null;
        }
        this.lastBrowsePath = path = fileChooser.getSelectedFile().getAbsolutePath();
        return path;
    }

    public BigWarpToDeformationFieldPlugIn.DeformationFieldExportParameters getParams() {
        String n5BlockSizeString = this.n5BlockSizeTxt.getText();
        int[] blockSize = n5BlockSizeString.isEmpty() ? null : Arrays.stream(n5BlockSizeString.split(",")).mapToInt(Integer::parseInt).toArray();
        return new BigWarpToDeformationFieldPlugIn.DeformationFieldExportParameters(this.landmarkPathTxt == null ? DIRECTION_HELP_TEXT : this.landmarkPathTxt.getText(), this.splitAffineCheckBox.isSelected(), (String)this.typeComboBox.getSelectedItem(), (DTYPE)((Object)this.dataTypeComboBox.getSelectedItem()), (Double)this.quantizationErrorSpinner.getValue(), (String)this.directionComboBox.getSelectedItem(), (Double)this.invToleranceSpinner.getValue(), (Integer)this.invMaxIterationsSpinner.getValue(), this.virtualCheckBox.isSelected(), (Integer)this.nThreadsField.getValue(), (String)this.formatComboBox.getSelectedItem(), this.fovPanel == null ? null : this.fovPanel.getPixelSize(), this.fovPanel == null ? null : this.fovPanel.getSpacing(), this.fovPanel == null ? null : this.fovPanel.getMin(), this.fovPanel == null ? null : this.fovPanel.getUnit(), this.n5RootTxt.getText(), this.n5DatasetTxt.getText(), blockSize, BigWarpToDeformationFieldPlugIn.getCompression((String)this.n5CompressionDropdown.getSelectedItem()));
    }

    public void run() {
        BigWarpToDeformationFieldPlugIn.runFromParameters(this.getParams(), this.data, this.ltm, this.bwTransform);
    }

    public String macroRecord() {
        if (!Recorder.record) {
            return DIRECTION_HELP_TEXT;
        }
        Recorder.setCommand((String)commandName);
        String szString = Arrays.stream(this.fovPanel.getPixelSize()).mapToObj(Long::toString).collect(Collectors.joining(","));
        String spacingString = Arrays.stream(this.fovPanel.getSpacing()).mapToObj(Double::toString).collect(Collectors.joining(","));
        String minString = Arrays.stream(this.fovPanel.getMin()).mapToObj(Double::toString).collect(Collectors.joining(","));
        Recorder.resetCommandOptions();
        Recorder.recordOption((String)landmarksKey, (String)this.landmarkPathTxt.getText().trim());
        Recorder.recordOption((String)splitAffineKey);
        Recorder.recordOption((String)virtualKey);
        Recorder.recordOption((String)typeKey, (String)((String)this.typeComboBox.getSelectedItem()));
        Recorder.recordOption((String)threadsKey, (String)Integer.toString((Integer)this.nThreadsField.getValue()));
        Recorder.recordOption((String)sizeKey, (String)szString);
        Recorder.recordOption((String)spacingKey, (String)spacingString);
        Recorder.recordOption((String)minKey, (String)minString);
        Recorder.recordOption((String)unitKey, (String)this.fovPanel.getUnit());
        if (!this.n5RootTxt.getText().isEmpty()) {
            Recorder.recordOption((String)n5RootKey, (String)this.n5RootTxt.getText().trim());
            Recorder.recordOption((String)n5DatasetKey, (String)this.n5DatasetTxt.getText().trim());
            Recorder.recordOption((String)n5BlockSizeKey, (String)this.n5BlockSizeTxt.getText().trim());
            Recorder.recordOption((String)n5CompressionKey, (String)((String)this.n5CompressionDropdown.getSelectedItem()));
        }
        Recorder.saveCommand();
        return Recorder.getCommandOptions();
    }

    public static void runMacro(String args) {
        String landmarks = Macro.getValue((String)args, (String)landmarksKey, (String)DIRECTION_HELP_TEXT);
        String type = Macro.getValue((String)args, (String)typeKey, (String)DIRECTION_HELP_TEXT);
        DTYPE dtype = DTYPE.valueOf(Macro.getValue((String)args, (String)dtypeKey, (String)DIRECTION_HELP_TEXT));
        double maxQuantizationError = Double.valueOf(Macro.getValue((String)args, (String)quantizationErrorKey, (String)DIRECTION_HELP_TEXT));
        String direction = Macro.getValue((String)args, (String)directionKey, (String)DIRECTION_HELP_TEXT);
        double tolerance = Double.valueOf(Macro.getValue((String)args, (String)inverseToleranceKey, (String)DIRECTION_HELP_TEXT));
        int maxIters = Integer.valueOf(Macro.getValue((String)args, (String)inverseMaxIterationsKey, (String)DIRECTION_HELP_TEXT));
        boolean splitAffine = args.contains(" split_affine");
        boolean openAsVirtual = args.contains(" virtual");
        int threads = Integer.valueOf(Macro.getValue((String)args, (String)threadsKey, (String)"1"));
        String format = Macro.getValue((String)args, (String)formatKey, (String)FMT_NGFF);
        double[] min = Arrays.stream(Macro.getValue((String)args, (String)minKey, (String)DIRECTION_HELP_TEXT).split(",")).mapToDouble(Double::valueOf).toArray();
        double[] spacing = Arrays.stream(Macro.getValue((String)args, (String)spacingKey, (String)DIRECTION_HELP_TEXT).split(",")).mapToDouble(Double::valueOf).toArray();
        long[] pixSize = Arrays.stream(Macro.getValue((String)args, (String)sizeKey, (String)DIRECTION_HELP_TEXT).split(",")).mapToLong(Long::valueOf).toArray();
        String unit = Macro.getValue((String)args, (String)typeKey, (String)"pixel");
        String n5Root = Macro.getValue((String)args, (String)n5RootKey, (String)DIRECTION_HELP_TEXT);
        String n5Dataset = Macro.getValue((String)args, (String)n5DatasetKey, (String)DIRECTION_HELP_TEXT);
        String n5BlockSizeString = Macro.getValue((String)args, (String)n5BlockSizeKey, (String)DIRECTION_HELP_TEXT);
        String n5Compression = Macro.getValue((String)args, (String)n5CompressionKey, (String)DIRECTION_HELP_TEXT);
        int[] blockSize = n5BlockSizeString.isEmpty() ? null : Arrays.stream(n5BlockSizeString.split(",")).mapToInt(Integer::parseInt).toArray();
        BigWarpToDeformationFieldPlugIn.DeformationFieldExportParameters params = new BigWarpToDeformationFieldPlugIn.DeformationFieldExportParameters(landmarks, splitAffine, type, dtype, maxQuantizationError, direction, tolerance, maxIters, openAsVirtual, threads, format, pixSize, spacing, min, unit, n5Root, n5Dataset, blockSize, BigWarpToDeformationFieldPlugIn.getCompression(n5Compression));
        BigWarpToDeformationFieldPlugIn.runFromParameters(params, null, null, null);
    }

    public static enum DTYPE {
        BYTE,
        SHORT,
        FLOAT,
        DOUBLE;

    }
}

