/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.img.RenamableSource;
import bdv.img.WarpedSource;
import bdv.tools.transformation.TransformedSource;
import bdv.util.RandomAccessibleIntervalMipmapSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarpData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Optional;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.imglib2.realtransform.AffineTransform3D;

public class SourceInfoDialog
extends JDialog {
    private static final long serialVersionUID = 8333668892181971701L;

    public SourceInfoDialog(Frame owner, BigWarpData<?> bwData) {
        super(owner, "Source information", false);
        String name;
        SourceAndConverter<?> src;
        int i;
        StringBuffer infoString = new StringBuffer();
        infoString.append("MOVING:\n");
        for (i = 0; i < bwData.numMovingSources(); ++i) {
            src = bwData.getMovingSource(i);
            name = src.getSpimSource().getName();
            if (name.equals("WarpMagnitudeSource") || name.equals("JacobianDeterminantSource") || name.equals("GridSource")) continue;
            this.appendSourceString(infoString, src);
            infoString.append("\n");
        }
        infoString.append("\nTARGET:\n");
        for (i = 0; i < bwData.numTargetSources(); ++i) {
            src = bwData.getTargetSource(i);
            name = src.getSpimSource().getName();
            if (name.equals("WarpMagnitudeSource") || name.equals("JacobianDeterminantSource") || name.equals("GridSource")) continue;
            this.appendSourceString(infoString, src);
            infoString.append("\n");
        }
        JTextArea textArea = new JTextArea(infoString.toString());
        textArea.setEditable(false);
        JScrollPane editorScrollPane = new JScrollPane(textArea);
        editorScrollPane.setVerticalScrollBarPolicy(20);
        editorScrollPane.setPreferredSize(new Dimension(800, 800));
        this.getContentPane().add((Component)editorScrollPane, "Center");
        this.pack();
        this.setDefaultCloseOperation(1);
    }

    private void appendSourceString(StringBuffer infoString, SourceAndConverter<?> src) {
        Source ssrc = src.getSpimSource();
        Optional<RandomAccessibleIntervalMipmapSource> mipmapSrcOpt = this.unwrapToMultiscale(ssrc);
        String name = src.getSpimSource().getName();
        String unit = src.getSpimSource().getVoxelDimensions().unit();
        infoString.append(name + "\n");
        infoString.append("  unit   : " + unit + "\n");
        AffineTransform3D xfm = new AffineTransform3D();
        if (mipmapSrcOpt.isPresent()) {
            RandomAccessibleIntervalMipmapSource mmSrc = mipmapSrcOpt.get();
            for (int i = 0; i < mmSrc.getNumMipmapLevels(); ++i) {
                mmSrc.getSourceTransform(0, i, xfm);
                infoString.append("  level " + i + "\n");
                infoString.append("    scale  : " + xfm.get(0, 0) + " " + xfm.get(1, 1) + " " + xfm.get(2, 2) + "\n");
                infoString.append("    offset : " + xfm.get(0, 3) + " " + xfm.get(1, 3) + " " + xfm.get(2, 3) + "\n");
            }
        } else {
            src.getSpimSource().getSourceTransform(0, 0, xfm);
            infoString.append("  scale  : " + xfm.get(0, 0) + " " + xfm.get(1, 1) + " " + xfm.get(2, 2) + "\n");
            infoString.append("  offset : " + xfm.get(0, 3) + " " + xfm.get(1, 3) + " " + xfm.get(2, 3) + "\n");
        }
    }

    private Optional<RandomAccessibleIntervalMipmapSource> unwrapToMultiscale(Source<?> src) {
        Source outSrc = src;
        boolean wrappedSource = true;
        while (wrappedSource) {
            if (outSrc instanceof TransformedSource) {
                outSrc = ((TransformedSource)outSrc).getWrappedSource();
                continue;
            }
            if (outSrc instanceof WarpedSource) {
                outSrc = ((WarpedSource)outSrc).getWrappedSource();
                continue;
            }
            if (outSrc instanceof RenamableSource) {
                outSrc = ((RenamableSource)outSrc).getWrappedSource();
                continue;
            }
            wrappedSource = false;
        }
        if (outSrc instanceof RandomAccessibleIntervalMipmapSource) {
            return Optional.of((RandomAccessibleIntervalMipmapSource)outSrc);
        }
        return Optional.empty();
    }
}

