/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.loader;

import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.spimdata.XmlIoSpimDataMinimal;
import bigwarp.loader.Loader;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;

public class XMLLoader
implements Loader {
    private final String xmlPath;
    private List<String> names;
    private int numSources = 0;

    public XMLLoader(String xmlPath) {
        this.xmlPath = xmlPath;
    }

    @Override
    public String name(int i) {
        assert (i <= this.numSources);
        return this.names.get(i);
    }

    @Override
    public int numSources() {
        return this.numSources;
    }

    public SpimDataMinimal[] load() {
        this.names = new ArrayList<String>();
        SpimDataMinimal spimData = null;
        try {
            spimData = (SpimDataMinimal)new XmlIoSpimDataMinimal().load(this.xmlPath);
            this.numSources = ((SequenceDescriptionMinimal)spimData.getSequenceDescription()).getViewSetupsOrdered().size();
            for (BasicViewSetup s : ((SequenceDescriptionMinimal)spimData.getSequenceDescription()).getViewSetupsOrdered()) {
                this.names.add(s.getName());
            }
            if (WrapBasicImgLoader.wrapImgLoaderIfNecessary((AbstractSpimData)spimData)) {
                System.err.println("WARNING:\nOpening <SpimData> dataset that is not suited for interactive browsing.\nConsider resaving as HDF5 for better performance.");
            }
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
        return new SpimDataMinimal[]{spimData};
    }
}

