/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.transforms;

import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.transforms.AbstractTransformSolver;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.SpatiallyInterpolatedRealTransform;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.type.numeric.RealType;

public class MaskedTransformSolver<T extends RealType<T>, S extends AbstractTransformSolver<?>>
extends AbstractTransformSolver<WrappedIterativeInvertibleRealTransform<?>> {
    private final S solver;
    private RealRandomAccessible<T> lambda;

    public MaskedTransformSolver(S solver, RealRandomAccessible<T> lambda) {
        this.lambda = lambda;
        this.solver = solver;
    }

    public S getSolver() {
        return this.solver;
    }

    public void setMask(RealRandomAccessible<T> lambda) {
        this.lambda = lambda;
    }

    @Override
    public WrappedIterativeInvertibleRealTransform<?> solve(double[][] mvgPts, double[][] tgtPts) {
        return MaskedTransformSolver.wrap(this.solver.solve(mvgPts, tgtPts), this.lambda);
    }

    @Override
    public WrappedIterativeInvertibleRealTransform<?> solve(LandmarkTableModel landmarkTable) {
        return MaskedTransformSolver.wrap(((AbstractTransformSolver)this.solver).solve(landmarkTable), this.lambda);
    }

    @Override
    public WrappedIterativeInvertibleRealTransform<?> solve(LandmarkTableModel landmarkTable, int indexChanged) {
        return MaskedTransformSolver.wrap(((AbstractTransformSolver)this.solver).solve(landmarkTable, indexChanged), this.lambda);
    }

    public static <T extends RealType<T>> WrappedIterativeInvertibleRealTransform<?> wrap(RealTransform base, RealRandomAccessible<T> lambda) {
        RealTransformSequence identity = new RealTransformSequence();
        return new WrappedIterativeInvertibleRealTransform(new SpatiallyInterpolatedRealTransform<T>(base, (RealTransform)identity, lambda));
    }
}

