/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.listeners;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.scijava.listeners.ListenableVar;
import org.scijava.listeners.Listeners;

public class DefaultListenableVar<T, L>
implements ListenableVar<T, L> {
    private final AtomicReference<T> ref;
    private final Listeners.List<L> listeners;
    private final BiConsumer<L, T> notify;
    private final boolean notifyWhenSet;

    public DefaultListenableVar(T value, Consumer<L> notify) {
        this(value, notify, false);
    }

    public DefaultListenableVar(T value, BiConsumer<L, T> notify) {
        this(value, notify, false);
    }

    public DefaultListenableVar(T value, Consumer<L> notify, boolean notifyWhenSet) {
        this(value, (L l, T t) -> notify.accept(l), notifyWhenSet);
    }

    public DefaultListenableVar(T value, BiConsumer<L, T> notify, boolean notifyWhenSet) {
        this.ref = new AtomicReference<T>(value);
        this.notify = notify;
        this.notifyWhenSet = notifyWhenSet;
        this.listeners = new Listeners.SynchronizedList<L>();
    }

    @Override
    public void set(T value) {
        T previous = this.ref.getAndSet(value);
        if (this.notifyWhenSet || !previous.equals(value)) {
            this.listeners.list.forEach(l -> this.notify.accept(l, value));
        }
    }

    @Override
    public T get() {
        return this.ref.get();
    }

    @Override
    public Listeners<L> listeners() {
        return this.listeners;
    }
}

