/*
 * Decompiled with CFR 0.152.
 */
package emblcmci;

import emblcmci.BleachCorrection_ExpoFit;
import emblcmci.BleachCorrection_MH;
import emblcmci.BleachCorrection_SimpleRatio;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.Duplicator;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import org.scijava.util.VersionUtils;

public class BleachCorrection
implements PlugInFilter {
    public static final int SIMPLE_RATIO = 0;
    public static final int EXPONENTIAL_FIT = 1;
    public static final int HISTOGRAM_MATCHING = 2;
    boolean doHeadLess = false;
    double simpleratio_baseline = 0.0;
    ImagePlus imp;
    ImagePlus impdup;
    String[] CorrectionMethods = new String[]{"Simple Ratio", "Exponential Fit", "Histogram Matching"};
    private static int CorrectionMethod = 0;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (!this.showDialog()) {
            return 0;
        }
        return 2053;
    }

    public void run(ImageProcessor ip) {
        ImagePlus impdup = this.doCorrection(this.imp);
        impdup.show();
    }

    public ImagePlus doCorrection(ImagePlus imp) {
        this.imp = imp;
        Roi curROI = imp.getRoi();
        if (curROI != null) {
            Rectangle rect = curROI.getBounds();
            System.out.println("(x,y)=(" + rect.x + "," + rect.y);
            System.out.println("Width=" + rect.width);
            System.out.println("Height=" + rect.height);
        } else {
            System.out.println("No ROI");
        }
        imp.killRoi();
        this.impdup = new Duplicator().run(imp);
        if (curROI != null) {
            this.impdup.setRoi(curROI);
        }
        if (CorrectionMethod == 0) {
            BleachCorrection_SimpleRatio BCSR = null;
            BCSR = curROI == null ? new BleachCorrection_SimpleRatio(this.impdup) : new BleachCorrection_SimpleRatio(this.impdup, curROI);
            if (!this.doHeadLess) {
                BCSR.showDialogAskBaseline();
            } else {
                BCSR.setSimpleRatioBaseline(this.simpleratio_baseline);
            }
            BCSR.correctBleach();
        } else if (CorrectionMethod == 1) {
            BleachCorrection_ExpoFit BCEF = curROI == null ? new BleachCorrection_ExpoFit(this.impdup) : new BleachCorrection_ExpoFit(this.impdup, curROI);
            BCEF.setHeadlessProcessing(this.doHeadLess);
            BCEF.core();
        } else if (CorrectionMethod == 2) {
            BleachCorrection_MH BCMH = null;
            BCMH = new BleachCorrection_MH(this.impdup);
            BCMH.doCorrection();
        }
        return this.impdup;
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("Bleach Correction");
        gd.addChoice("Correction Method :", this.CorrectionMethods, this.CorrectionMethods[CorrectionMethod]);
        gd.addMessage("version " + VersionUtils.getVersion(this.getClass()));
        gd.addMessage("Citation doi: 10.12688/f1000research.27171.1");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        BleachCorrection.setCorrectionMethod(gd.getNextChoiceIndex());
        return true;
    }

    public ImagePlus getCorrectedImagePlus() {
        return this.impdup;
    }

    public static int getCorrectionMethod() {
        return CorrectionMethod;
    }

    public static void setCorrectionMethod(int correctionMethod) {
        CorrectionMethod = correctionMethod;
    }

    public void setHeadlessProcessing(boolean headless) {
        this.doHeadLess = headless;
    }

    public void setSimpleRatioBaseline(double baseline) {
        this.simpleratio_baseline = baseline;
    }
}

