/*
 * Decompiled with CFR 0.152.
 */
package emblcmci;

import histogram2.HistogramMatcher;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.process.ImageProcessor;

public class BleachCorrection_MH {
    ImagePlus imp;
    Roi curROI = null;

    public BleachCorrection_MH(ImagePlus imp) {
        this.imp = imp;
    }

    public BleachCorrection_MH(ImagePlus imp, Roi curROI) {
        this.imp = imp;
        this.curROI = curROI;
    }

    public void doCorrection() {
        int histbinnum = 0;
        if (this.imp.getBitDepth() == 8) {
            histbinnum = 256;
        } else if (this.imp.getBitDepth() == 16) {
            histbinnum = 65536;
        }
        boolean is3DT = false;
        int zframes = 1;
        int timeframes = 1;
        int[] impdimA = this.imp.getDimensions();
        IJ.log((String)("slices" + Integer.toString(impdimA[3]) + "  -- frames" + Integer.toString(impdimA[4])));
        if (impdimA[3] > 1 && impdimA[4] > 1) {
            is3DT = true;
            zframes = impdimA[3];
            timeframes = impdimA[4];
            if (zframes * timeframes != this.imp.getStackSize()) {
                IJ.showMessage((String)"slice and time frames do not match with the length of the stack. Please correct!");
                return;
            }
        }
        ImageStack stack = this.imp.getStack();
        ImageProcessor ipA = null;
        ImageProcessor ipB = null;
        HistogramMatcher m = new HistogramMatcher();
        int[] hA = new int[histbinnum];
        int[] hB = new int[histbinnum];
        int[] F = new int[histbinnum];
        int[] histB = null;
        int[] histA = null;
        int i = 0;
        int j = 0;
        int k = 0;
        if (is3DT) {
            for (i = 0; i < timeframes; ++i) {
                if (i == 0) {
                    for (j = 0; j < zframes; ++j) {
                        ipB = stack.getProcessor(i * zframes + j + 1);
                        histB = ipB.getHistogram();
                        for (k = 0; k < histbinnum; ++k) {
                            int n = k;
                            hB[n] = hB[n] + histB[k];
                        }
                    }
                    continue;
                }
                for (k = 0; k < histbinnum; ++k) {
                    hA[k] = 0;
                }
                for (j = 0; j < zframes; ++j) {
                    ipA = stack.getProcessor(i * zframes + j + 1);
                    histA = ipA.getHistogram();
                    for (k = 0; k < histbinnum; ++k) {
                        int n = k;
                        hA[n] = hA[n] + histA[k];
                    }
                }
                F = m.matchHistograms(hA, hB);
                for (j = 0; j < zframes; ++j) {
                    ipA = stack.getProcessor(i * zframes + j + 1);
                    ipA.applyTable(F);
                }
                IJ.log((String)("corrected time point: " + Integer.toString(i + 1)));
            }
        } else {
            for (i = 0; i < stack.getSize(); ++i) {
                if (i == 0) {
                    ipB = stack.getProcessor(i + 1);
                    hB = ipB.getHistogram();
                    continue;
                }
                ipA = stack.getProcessor(i + 1);
                hA = ipA.getHistogram();
                F = m.matchHistograms(hA, hB);
                ipA.applyTable(F);
                IJ.log((String)("corrected frame: " + Integer.toString(i + 1)));
            }
        }
    }
}

