/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin;

import fiji.Debug;
import fiji.plugin.Multi_View_Deconvolution;
import fiji.plugin.timelapsedisplay.GraphFrame;
import fiji.plugin.timelapsedisplay.TimeLapseDisplay;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.cell.CellContainerFactory;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.io.LOCI;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.spim.Reconstruction;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.segmentation.InteractiveDoG;
import mpicbg.spim.segmentation.InteractiveIntegral;
import spim.Threads;
import spim.fiji.plugin.util.GUIHelper;
import spimopener.SPIMExperiment;

public class Bead_Registration
implements PlugIn {
    private final String myURL = "http://fly.mpi-cbg.de/preibisch";
    private final String paperURL = "http://www.nature.com/nmeth/journal/v7/n6/full/nmeth0610-418.html";
    final String[] beadRegistration = new String[]{"Single-channel", "Multi-channel (same beads visible in different channels)"};
    final String[] beadDetectionType = new String[]{"Difference-of-Gaussian", "Difference-of-Mean (Integral image based)"};
    public static int defaultBeadRegistration = 0;
    public static int defaultBeadDetectionType = 1;
    public static String spimDataDirectory = "";
    public static String timepoints = "18";
    public static String fileNamePattern = "spim_TL{t}_Angle{a}.lsm";
    public static String angles = "0-270:45";
    public static boolean loadSegmentation = false;
    public static int relocalize = 1;
    public static boolean keepImagesOpen = true;
    public static boolean iterativeRelocalization = true;
    public static String[] localization = new String[]{"None", "3-dimensional quadratic fit (all detections)", "Gauss fit (true correspondences)", "Gauss fit (all detections)"};
    public static String[] beadBrightness = new String[]{"Very weak", "Weak", "Comparable to Sample", "Strong", "Advanced ...", "Interactive ..."};
    public static int defaultBeadBrightness = 1;
    public static boolean overrideResolution = false;
    public static double xyRes = 0.73;
    public static double zRes = 2.0;
    final String[] model = new String[]{"Translation", "Rigid", "Affine"};
    public static int defaultModel = 2;
    public static boolean loadRegistration = false;
    public static boolean timeLapseRegistration = false;
    final String[] timeLapseRegistrationTypes = new String[]{"Manually (interactive)", "Manually (specify)", "Automatically"};
    public static int defaultTimeLapseRegistration = 0;
    public static int defaultTimePoint = 1;
    private SPIMConfiguration conf;
    public static String fileNamePatternMC = "spim_TL{t}_Channel{c}_Angle{a}.lsm";
    public static String channelsBeadsMC = "0, 1";
    public static int[] defaultBeadBrightnessMC = null;
    static double[][] defaultDoGParameters = null;
    static double[] defaultintegralParameters = null;
    static int[][] defaultIntegralRadius = null;

    public void run(String arg0) {
        IOFunctions.printIJLog = true;
        GenericDialog gd = new GenericDialog("Bead based registration");
        gd.addChoice("Select_type_of_registration", this.beadRegistration, this.beadRegistration[defaultBeadRegistration]);
        gd.addChoice("Select_type_of_detection", this.beadDetectionType, this.beadDetectionType[defaultBeadDetectionType]);
        gd.addMessage("Please note that the SPIM Registration is based on a publication.\nIf you use it successfully for your research please be so kind to cite our work:\nPreibisch et al., Nature Methods (2010), 7(6):418-419\n");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        GUIHelper.addHyperLinkListener(text, "http://www.nature.com/nmeth/journal/v7/n6/full/nmeth0610-418.html");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int choice = defaultBeadRegistration = gd.getNextChoiceIndex();
        int choiceType = defaultBeadDetectionType = gd.getNextChoiceIndex();
        SPIMConfiguration conf = choice == 0 ? this.singleChannel(choiceType) : this.multiChannel(choiceType);
        if (conf == null) {
            return;
        }
        if (!Bead_Registration.init(conf)) {
            return;
        }
        conf.registerOnly = true;
        if (!timeLapseRegistration) {
            conf.timeLapseRegistration = false;
            conf.collectRegistrationStatistics = true;
            Reconstruction reconstruction = new Reconstruction(conf);
            if (reconstruction.getSPIMConfiguration().file.length > 1 && defaultTimeLapseRegistration == 0) {
                TimeLapseDisplay.plotData(reconstruction.getRegistrationStatistics(), -1, false);
            }
        } else {
            conf.timeLapseRegistration = false;
            conf.collectRegistrationStatistics = true;
            Reconstruction reconstruction = new Reconstruction(conf);
            if (defaultTimeLapseRegistration == 0) {
                GraphFrame gf = TimeLapseDisplay.plotData(reconstruction.getRegistrationStatistics(), -1, true);
                int lastRefTP = -1;
                do {
                    lastRefTP = gf.getReferenceTimePoint();
                    SimpleMultiThreading.threadWait((long)1000L);
                } while (gf.getReferenceTimePoint() == lastRefTP);
                conf.referenceTimePoint = gf.getReferenceTimePoint();
            } else if (defaultTimeLapseRegistration == 1) {
                conf.referenceTimePoint = defaultTimePoint;
            } else {
                conf.referenceTimePoint = TimeLapseDisplay.getOptimalTimePoint(reconstruction.getRegistrationStatistics());
                TimeLapseDisplay.plotData(reconstruction.getRegistrationStatistics(), conf.referenceTimePoint, false);
            }
            conf.timeLapseRegistration = true;
            conf.readRegistration = false;
            reconstruction = new Reconstruction(conf);
        }
    }

    public SPIMConfiguration singleChannel(final int choiceType) {
        this.conf = null;
        final GenericDialogPlus gd = new GenericDialogPlus("Single Channel Bead-based Registration");
        gd.addDirectoryOrFileField("SPIM_data_directory", spimDataDirectory);
        final TextField tfSpimDataDirectory = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Pattern_of_SPIM files", fileNamePattern, 25);
        final TextField tfFilePattern = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Timepoints_to_process", timepoints);
        final TextField tfTimepoints = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Angles_to_process", angles);
        final TextField tfAngles = (TextField)gd.getStringFields().lastElement();
        gd.addMessage("");
        gd.addCheckbox("Load_segmented_beads", loadSegmentation);
        gd.addChoice("Bead_brightness", beadBrightness, beadBrightness[defaultBeadBrightness]);
        gd.addChoice("Subpixel_localization", localization, localization[relocalize]);
        gd.addCheckbox("Specify_calibration_manually (Note: otherwise read from file - slow)", overrideResolution);
        final Checkbox dimensionsBox = (Checkbox)gd.getCheckboxes().lastElement();
        gd.addNumericField("xy_resolution (um/px)", xyRes, 3);
        final TextField tfXyRes = (TextField)gd.getNumericFields().lastElement();
        gd.addNumericField("z_resolution (um/px)", zRes, 3);
        final TextField tfZRes = (TextField)gd.getNumericFields().lastElement();
        gd.addMessage("");
        gd.addChoice("Transformation_model", this.model, this.model[defaultModel]);
        gd.addCheckbox("Re-use_per_timepoint_registration", loadRegistration);
        gd.addMessage("");
        gd.addCheckbox("Timelapse_registration", timeLapseRegistration);
        gd.addChoice("Select_reference timepoint", this.timeLapseRegistrationTypes, this.timeLapseRegistrationTypes[defaultTimeLapseRegistration]);
        gd.addMessage("");
        gd.addChoice("ImgLib_container", Multi_View_Deconvolution.imglibContainer, Multi_View_Deconvolution.imglibContainer[Multi_View_Deconvolution.defaultContainerInput]);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/preibisch");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        GUIHelper.addHyperLinkListener(text, "http://fly.mpi-cbg.de/preibisch");
        gd.addDialogListener(new DialogListener(){

            public boolean dialogItemChanged(GenericDialog dialog, AWTEvent e) {
                if (e == null) {
                    if (!gd.wasCanceled()) {
                        Bead_Registration.this.conf = Bead_Registration.getConfigurationSingleChannel(dialog, choiceType);
                    }
                    return true;
                }
                if (e instanceof TextEvent && e.getID() == 900 && e.getSource() == tfSpimDataDirectory) {
                    TextField tf = (TextField)e.getSource();
                    spimDataDirectory = tf.getText();
                    File f = new File(spimDataDirectory);
                    if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
                        SPIMExperiment exp = new SPIMExperiment(f.getAbsolutePath());
                        tfFilePattern.setEnabled(false);
                        String expTimepoints = "";
                        expTimepoints = exp.timepointStart == exp.timepointEnd ? "" + exp.timepointStart : "" + exp.timepointStart + "-" + exp.timepointEnd;
                        tfTimepoints.setText(expTimepoints);
                        String expAngles = "";
                        for (String angle : exp.angles) {
                            int a = Integer.parseInt(angle.substring(1, angle.length()));
                            if (!expAngles.equals("")) {
                                expAngles = expAngles + ",";
                            }
                            expAngles = expAngles + a;
                        }
                        tfAngles.setText(expAngles);
                        if (exp.pw != exp.ph) {
                            IJ.log((String)("Warning: pixel width != pixel height in " + spimDataDirectory));
                        }
                        dimensionsBox.setState(true);
                        tfXyRes.setText(String.format("%.3f", exp.pw));
                        tfZRes.setText(String.format("%.3f", exp.pd));
                    } else {
                        tfFilePattern.setEnabled(true);
                    }
                }
                return true;
            }
        });
        System.out.println("init Bead_Registration dialog: tfSpimDataDirectory.getText() = " + tfSpimDataDirectory.getText());
        File f = new File(tfSpimDataDirectory.getText());
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            tfFilePattern.setEnabled(false);
        }
        gd.showDialog();
        if (gd.wasCanceled() || this.conf == null) {
            return null;
        }
        return this.conf;
    }

    private static SPIMConfiguration getConfigurationSingleChannel(GenericDialog gd, int choiceType) {
        spimDataDirectory = gd.getNextString();
        fileNamePattern = gd.getNextString();
        timepoints = gd.getNextString();
        angles = gd.getNextString();
        loadSegmentation = gd.getNextBoolean();
        defaultBeadBrightness = gd.getNextChoiceIndex();
        relocalize = gd.getNextChoiceIndex();
        overrideResolution = gd.getNextBoolean();
        xyRes = gd.getNextNumber();
        zRes = gd.getNextNumber();
        defaultModel = gd.getNextChoiceIndex();
        loadRegistration = gd.getNextBoolean();
        timeLapseRegistration = gd.getNextBoolean();
        defaultTimeLapseRegistration = gd.getNextChoiceIndex();
        Multi_View_Deconvolution.defaultContainerInput = gd.getNextChoiceIndex();
        SPIMConfiguration conf = new SPIMConfiguration();
        conf.inputImageFactory = Multi_View_Deconvolution.defaultContainerInput == 1 ? new CellContainerFactory(256) : new ArrayContainerFactory();
        if (conf.initialSigma == null || conf.initialSigma.length != 1 || conf.minPeakValue == null || conf.minPeakValue.length != 1) {
            conf.initialSigma = new float[]{1.8f};
            conf.minPeakValue = new float[]{0.01f};
        }
        if (conf.integralImgRadius1 == null || conf.integralImgRadius2 == null || conf.integralImgThreshold == null || conf.integralImgRadius1.length != 1 || conf.integralImgRadius2.length != 1 || conf.integralImgThreshold.length != 1) {
            conf.integralImgRadius1 = new int[]{3};
            conf.integralImgRadius2 = new int[]{5};
            conf.integralImgThreshold = new float[]{0.1f};
        }
        if (!loadSegmentation) {
            if (defaultBeadBrightness == 0) {
                conf.minPeakValue[0] = 0.001f;
                conf.integralImgThreshold[0] = 0.0025f;
            } else if (defaultBeadBrightness == 1) {
                conf.minPeakValue[0] = 0.008f;
                conf.integralImgThreshold[0] = 0.02f;
            } else if (defaultBeadBrightness == 2) {
                conf.minPeakValue[0] = 0.03f;
                conf.integralImgThreshold[0] = 0.075f;
            } else if (defaultBeadBrightness == 3) {
                conf.minPeakValue[0] = 0.1f;
                conf.integralImgThreshold[0] = 0.25f;
            } else {
                double[] values;
                if (defaultBeadBrightness == 4) {
                    values = choiceType == 0 ? Bead_Registration.getAdvancedDoGParameters(new int[1])[0] : Bead_Registration.getAdvancedIntegralImageParameters(new int[1])[0];
                } else if (choiceType == 0) {
                    values = new double[]{conf.initialSigma[0], conf.minPeakValue[0]};
                    Bead_Registration.getInteractiveDoGParameters("Select view to analyze", values);
                    IJ.log((String)("sigma1 = " + values[0]));
                    IJ.log((String)("threshold = " + values[1]));
                } else {
                    values = defaultintegralParameters != null && defaultIntegralRadius != null && defaultintegralParameters.length >= 1 ? new double[]{defaultIntegralRadius[0][0], defaultIntegralRadius[0][1], defaultintegralParameters[0]} : new double[]{conf.integralImgRadius1[0], conf.integralImgRadius2[0], conf.integralImgThreshold[0]};
                    Bead_Registration.getInteractiveIntegralParameters("Select view to analyze", values);
                    defaultIntegralRadius = new int[1][2];
                    defaultintegralParameters = new double[1];
                    Bead_Registration.defaultIntegralRadius[0][0] = (int)Math.round(values[0]);
                    Bead_Registration.defaultIntegralRadius[0][1] = (int)Math.round(values[1]);
                    Bead_Registration.defaultintegralParameters[0] = values[2];
                    IJ.log((String)("r1 = " + values[0]));
                    IJ.log((String)("r2 = " + values[1]));
                    IJ.log((String)("threshold = " + values[2]));
                }
                if (values == null) {
                    return null;
                }
                if (choiceType == 0) {
                    conf.initialSigma[0] = (float)values[0];
                    conf.minPeakValue[0] = (float)values[1];
                } else {
                    conf.integralImgRadius1[0] = (int)Math.round(values[0]);
                    conf.integralImgRadius2[0] = (int)Math.round(values[1]);
                    conf.integralImgThreshold[0] = (float)values[2];
                }
            }
        }
        if (choiceType == 1) {
            conf.segmentation = SPIMConfiguration.SegmentationTypes.DOM;
        }
        conf.minInitialPeakValue = new float[]{conf.minPeakValue[0] / 4.0f};
        conf.timepointPattern = timepoints;
        conf.channelPattern = "";
        conf.channelsToRegister = "";
        conf.channelsToFuse = "";
        conf.anglePattern = angles;
        conf.inputFilePattern = fileNamePattern;
        File f = new File(spimDataDirectory);
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            conf.spimExperiment = new SPIMExperiment(f.getAbsolutePath());
            conf.inputdirectory = f.getAbsolutePath().substring(0, f.getAbsolutePath().length() - 4);
            System.out.println("inputdirectory : " + conf.inputdirectory);
        } else {
            conf.inputdirectory = spimDataDirectory;
        }
        conf.overrideImageZStretching = overrideResolution;
        conf.doFit = relocalize;
        if (conf.doFit == 2) {
            GenericDialog gdGauss = new GenericDialog("Gauss options");
            gdGauss.addMessage("The re-localization using a Gaussian fit will be done for the true corresponding beads only, performed after or iteratively with the registration.");
            gdGauss.addCheckbox("Keep_images_open", keepImagesOpen);
            gdGauss.showDialog();
            if (gdGauss.wasCanceled()) {
                return null;
            }
            conf.doGaussKeepImagesOpen = keepImagesOpen = gdGauss.getNextBoolean();
        }
        if (defaultTimeLapseRegistration == 1) {
            GenericDialog gdTL = new GenericDialog("Select reference timepoint");
            gdTL.addNumericField("Reference_timepoint", (double)defaultTimePoint, 0);
            gdTL.showDialog();
            if (gdTL.wasCanceled()) {
                return null;
            }
            defaultTimePoint = (int)Math.round(gdTL.getNextNumber());
        }
        if (overrideResolution) {
            conf.zStretching = zRes / xyRes;
        }
        conf.readSegmentation = loadSegmentation;
        conf.readRegistration = loadRegistration;
        if (defaultModel == 0) {
            conf.transformationModel = "Translation";
            conf.max_epsilon = 10.0f;
            conf.numIterations = 10000;
        } else if (defaultModel == 1) {
            conf.transformationModel = "Rigid";
            conf.max_epsilon = 7.0f;
            conf.numIterations = 10000;
        } else {
            conf.transformationModel = "Affine";
        }
        conf.registerOnly = true;
        conf.timeLapseRegistration = timeLapseRegistration;
        return conf;
    }

    public SPIMConfiguration multiChannel(int choiceType) {
        this.conf = null;
        final GenericDialogPlus gd = new GenericDialogPlus("Multi Channel Bead-based Registration");
        gd.addDirectoryOrFileField("SPIM_data_directory", spimDataDirectory);
        final TextField tfSpimDataDirectory = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Pattern_of_SPIM files", fileNamePatternMC, 25);
        final TextField tfFilePattern = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Timepoints_to_process", timepoints);
        final TextField tfTimepoints = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Channels_containing_beads", channelsBeadsMC);
        final TextField tfBeadChannels = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Angles to process", angles);
        final TextField tfAngles = (TextField)gd.getStringFields().lastElement();
        gd.addMessage("");
        gd.addCheckbox("Re-use_segmented_beads", loadSegmentation);
        gd.addCheckbox("Override_file_dimensions", overrideResolution);
        final Checkbox dimensionsBox = (Checkbox)gd.getCheckboxes().lastElement();
        gd.addNumericField("xy_resolution (um/px)", xyRes, 3);
        final TextField tfXyRes = (TextField)gd.getNumericFields().lastElement();
        gd.addNumericField("z_resolution (um/px)", zRes, 3);
        final TextField tfZRes = (TextField)gd.getNumericFields().lastElement();
        gd.addMessage("");
        gd.addChoice("Transformation_model", this.model, this.model[defaultModel]);
        gd.addCheckbox("Re-use_per_timepoint_registration", loadRegistration);
        gd.addMessage("");
        gd.addCheckbox("Timelapse_registration", timeLapseRegistration);
        gd.addChoice("Select_reference timepoint", this.timeLapseRegistrationTypes, this.timeLapseRegistrationTypes[defaultTimeLapseRegistration]);
        gd.addMessage("");
        gd.addChoice("ImgLib_container", Multi_View_Deconvolution.imglibContainer, Multi_View_Deconvolution.imglibContainer[Multi_View_Deconvolution.defaultContainerInput]);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/preibisch");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        GUIHelper.addHyperLinkListener(text, "http://fly.mpi-cbg.de/preibisch");
        gd.addDialogListener(new DialogListener(){

            public boolean dialogItemChanged(GenericDialog dialog, AWTEvent e) {
                if (e == null) {
                    if (!gd.wasCanceled()) {
                        Bead_Registration.this.conf = Bead_Registration.getConfigurationMultiChannel(dialog);
                    }
                    return true;
                }
                if (e instanceof TextEvent && e.getID() == 900 && e.getSource() == tfSpimDataDirectory) {
                    TextField tf = (TextField)e.getSource();
                    spimDataDirectory = tf.getText();
                    File f = new File(spimDataDirectory);
                    if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
                        SPIMExperiment exp = new SPIMExperiment(f.getAbsolutePath());
                        tfFilePattern.setEnabled(false);
                        String expTimepoints = "";
                        expTimepoints = exp.timepointStart == exp.timepointEnd ? "" + exp.timepointStart : "" + exp.timepointStart + "-" + exp.timepointEnd;
                        tfTimepoints.setText(expTimepoints);
                        String expChannels = "";
                        for (String channel : exp.channels) {
                            int c = Integer.parseInt(channel.substring(1, channel.length()));
                            if (!expChannels.equals("")) {
                                expChannels = expChannels + ",";
                            }
                            expChannels = expChannels + c;
                        }
                        tfBeadChannels.setText(expChannels);
                        String expAngles = "";
                        for (String angle : exp.angles) {
                            int a = Integer.parseInt(angle.substring(1, angle.length()));
                            if (!expAngles.equals("")) {
                                expAngles = expAngles + ",";
                            }
                            expAngles = expAngles + a;
                        }
                        tfAngles.setText(expAngles);
                        if (exp.pw != exp.ph) {
                            IJ.log((String)("Warning: pixel width != pixel height in " + spimDataDirectory));
                        }
                        dimensionsBox.setState(true);
                        tfXyRes.setText(String.format("%.3f", exp.pw));
                        tfZRes.setText(String.format("%.3f", exp.pd));
                    } else {
                        tfFilePattern.setEnabled(true);
                    }
                }
                return true;
            }
        });
        System.out.println("init Bead_Registration dialog: tfSpimDataDirectory.getText() = " + tfSpimDataDirectory.getText());
        File f = new File(tfSpimDataDirectory.getText());
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            tfFilePattern.setEnabled(false);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        return this.conf;
    }

    private static SPIMConfiguration getConfigurationMultiChannel(GenericDialog gd) {
        int c;
        ArrayList<Integer> channels;
        spimDataDirectory = gd.getNextString();
        fileNamePatternMC = gd.getNextString();
        timepoints = gd.getNextString();
        channelsBeadsMC = gd.getNextString();
        angles = gd.getNextString();
        loadSegmentation = gd.getNextBoolean();
        overrideResolution = gd.getNextBoolean();
        xyRes = gd.getNextNumber();
        zRes = gd.getNextNumber();
        defaultModel = gd.getNextChoiceIndex();
        loadRegistration = gd.getNextBoolean();
        timeLapseRegistration = gd.getNextBoolean();
        defaultTimeLapseRegistration = gd.getNextChoiceIndex();
        Multi_View_Deconvolution.defaultContainerInput = gd.getNextChoiceIndex();
        int numChannels = 0;
        try {
            channels = SPIMConfiguration.parseIntegerString(channelsBeadsMC);
            numChannels = channels.size();
        }
        catch (ConfigurationParserException e) {
            IOFunctions.printErr("Cannot understand/parse the channels: " + channelsBeadsMC);
            return null;
        }
        if (numChannels < 1) {
            IOFunctions.printErr("There are no channels given: " + channelsBeadsMC);
            return null;
        }
        SPIMConfiguration conf = new SPIMConfiguration();
        conf.inputImageFactory = Multi_View_Deconvolution.defaultContainerInput == 1 ? new CellContainerFactory(256) : new ArrayContainerFactory();
        if (conf.initialSigma == null || conf.initialSigma.length != numChannels) {
            conf.initialSigma = new float[numChannels];
            for (c = 0; c < numChannels; ++c) {
                conf.initialSigma[c] = 1.8f;
            }
        }
        if (conf.minPeakValue == null || conf.minPeakValue.length != numChannels) {
            conf.minPeakValue = new float[numChannels];
            for (c = 0; c < numChannels; ++c) {
                conf.minPeakValue[c] = 0.01f;
            }
        }
        if (conf.minInitialPeakValue == null || conf.minInitialPeakValue.length != numChannels) {
            conf.minInitialPeakValue = new float[numChannels];
            for (c = 0; c < numChannels; ++c) {
                conf.minInitialPeakValue[c] = conf.minPeakValue[c] / 4.0f;
            }
        }
        if (!loadSegmentation && !loadRegistration) {
            int c2;
            if (defaultBeadBrightnessMC == null || defaultBeadBrightness != numChannels) {
                defaultBeadBrightnessMC = new int[numChannels];
                for (c = 0; c < numChannels; ++c) {
                    Bead_Registration.defaultBeadBrightnessMC[c] = 1;
                }
            }
            GenericDialogPlus gd2 = new GenericDialogPlus("Bead Brightness for Multi Channel Registration");
            for (int c3 = 0; c3 < numChannels; ++c3) {
                gd2.addChoice("Bead_brightness_channel_" + channels.get(c3), beadBrightness, beadBrightness[defaultBeadBrightnessMC[c3]]);
            }
            gd2.showDialog();
            if (gd2.wasCanceled()) {
                return null;
            }
            int advanced = 0;
            int interactive = 0;
            for (c2 = 0; c2 < numChannels; ++c2) {
                Bead_Registration.defaultBeadBrightnessMC[c2] = gd2.getNextChoiceIndex();
                if (defaultBeadBrightnessMC[c2] == 0) {
                    conf.minPeakValue[c2] = 0.001f;
                    continue;
                }
                if (defaultBeadBrightnessMC[c2] == 1) {
                    conf.minPeakValue[c2] = 0.008f;
                    continue;
                }
                if (defaultBeadBrightnessMC[c2] == 2) {
                    conf.minPeakValue[c2] = 0.03f;
                    continue;
                }
                if (defaultBeadBrightnessMC[c2] == 3) {
                    conf.minPeakValue[c2] = 0.1f;
                    continue;
                }
                if (defaultBeadBrightnessMC[c2] == 4) {
                    ++advanced;
                    continue;
                }
                ++interactive;
            }
            if (interactive > 0) {
                for (c2 = 0; c2 < numChannels; ++c2) {
                    if (defaultBeadBrightnessMC[c2] != 5) continue;
                    double[] values = new double[]{conf.initialSigma[c2], conf.minPeakValue[c2]};
                    Bead_Registration.getInteractiveDoGParameters("Select view to analyze for channel " + channels.get(c2), values);
                    conf.initialSigma[c2] = (float)values[0];
                    conf.minPeakValue[c2] = (float)values[1];
                }
            }
            if (advanced > 0) {
                int[] channelIndices = new int[advanced];
                int count = 0;
                for (int c4 = 0; c4 < numChannels; ++c4) {
                    if (defaultBeadBrightnessMC[c4] != 4) continue;
                    channelIndices[count++] = channels.get(c4);
                }
                double[][] values = Bead_Registration.getAdvancedDoGParameters(channelIndices);
                count = 0;
                for (int c5 = 0; c5 < numChannels; ++c5) {
                    if (defaultBeadBrightnessMC[c5] != 4) continue;
                    conf.initialSigma[c5] = (float)values[count][0];
                    conf.minPeakValue[c5] = (float)values[count++][1];
                }
            }
        }
        for (int c6 = 0; c6 < numChannels; ++c6) {
            conf.minInitialPeakValue[c6] = conf.minPeakValue[c6] / 4.0f;
        }
        conf.timepointPattern = timepoints;
        conf.anglePattern = angles;
        conf.channelPattern = channelsBeadsMC;
        conf.channelsToRegister = channelsBeadsMC;
        conf.channelsToFuse = "";
        conf.inputFilePattern = fileNamePatternMC;
        File f = new File(spimDataDirectory);
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            conf.spimExperiment = new SPIMExperiment(f.getAbsolutePath());
            conf.inputdirectory = f.getAbsolutePath().substring(0, f.getAbsolutePath().length() - 4);
            System.out.println("inputdirectory : " + conf.inputdirectory);
        } else {
            conf.inputdirectory = spimDataDirectory;
        }
        if (defaultTimeLapseRegistration == 1) {
            GenericDialog gdTL = new GenericDialog("Select reference timepoint");
            gdTL.addNumericField("Reference_timepoint", (double)defaultTimePoint, 0);
            gdTL.showDialog();
            if (gdTL.wasCanceled()) {
                return null;
            }
            defaultTimePoint = (int)Math.round(gdTL.getNextNumber());
        }
        conf.overrideImageZStretching = overrideResolution;
        if (overrideResolution) {
            conf.zStretching = zRes / xyRes;
        }
        conf.readSegmentation = loadSegmentation;
        conf.readRegistration = loadRegistration;
        if (defaultModel == 0) {
            conf.transformationModel = "Translation";
            conf.max_epsilon = 10.0f;
            conf.numIterations = 10000;
        } else if (defaultModel == 1) {
            conf.transformationModel = "Rigid";
            conf.max_epsilon = 7.0f;
            conf.numIterations = 10000;
        } else {
            conf.transformationModel = "Affine";
        }
        conf.registerOnly = true;
        conf.timeLapseRegistration = timeLapseRegistration;
        return conf;
    }

    public static double[][] getAdvancedDoGParameters(int[] channelIndices) {
        int i;
        if (channelIndices == null || channelIndices.length == 0) {
            return null;
        }
        if (defaultDoGParameters == null || defaultDoGParameters.length != channelIndices.length) {
            for (double[] dog : defaultDoGParameters = new double[channelIndices.length][2]) {
                dog[0] = 1.8;
                dog[1] = 0.008;
            }
        }
        GenericDialog gd1 = new GenericDialog("Select Difference-of-Gaussian Parameters");
        for (i = 0; i < channelIndices.length; ++i) {
            int channel = channelIndices[i];
            gd1.addNumericField("Channel_" + channel + "_Initial_sigma", defaultDoGParameters[i][0], 4);
            gd1.addNumericField("Channel_" + channel + "_Threshold", defaultDoGParameters[i][1], 4);
        }
        gd1.showDialog();
        if (gd1.wasCanceled()) {
            return null;
        }
        for (i = 0; i < channelIndices.length; ++i) {
            Bead_Registration.defaultDoGParameters[i][0] = gd1.getNextNumber();
            Bead_Registration.defaultDoGParameters[i][1] = gd1.getNextNumber();
        }
        return (double[][])defaultDoGParameters.clone();
    }

    public static double[][] getAdvancedIntegralImageParameters(int[] channelIndices) {
        if (channelIndices == null || channelIndices.length == 0) {
            return null;
        }
        if (defaultintegralParameters == null || defaultintegralParameters.length != channelIndices.length || defaultIntegralRadius == null || defaultIntegralRadius.length != channelIndices.length) {
            defaultintegralParameters = new double[channelIndices.length];
            defaultIntegralRadius = new int[channelIndices.length][2];
            for (int i = 0; i < channelIndices.length; ++i) {
                Bead_Registration.defaultintegralParameters[i] = 0.02;
                Bead_Registration.defaultIntegralRadius[i][0] = 2;
                Bead_Registration.defaultIntegralRadius[i][1] = 3;
            }
        }
        GenericDialog gd = new GenericDialog("Select Integral Image Parameters");
        for (int i = 0; i < channelIndices.length; ++i) {
            int channel = channelIndices[i];
            gd.addNumericField("Channel_" + channel + "_radius_1", (double)defaultIntegralRadius[i][0], 0);
            gd.addNumericField("Channel_" + channel + "_radius_2", (double)defaultIntegralRadius[i][1], 0);
            gd.addNumericField("Channel_" + channel + "_Threshold", defaultintegralParameters[i], 4);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        double[][] integralParameters = new double[channelIndices.length][3];
        for (int i = 0; i < channelIndices.length; ++i) {
            Bead_Registration.defaultIntegralRadius[i][0] = (int)Math.round(gd.getNextNumber());
            Bead_Registration.defaultIntegralRadius[i][1] = (int)Math.round(gd.getNextNumber());
            Bead_Registration.defaultintegralParameters[i] = gd.getNextNumber();
            if (defaultIntegralRadius[i][0] < 1) {
                Bead_Registration.defaultIntegralRadius[i][0] = 1;
            }
            if (defaultIntegralRadius[i][1] < defaultIntegralRadius[i][0]) {
                Bead_Registration.defaultIntegralRadius[i][1] = defaultIntegralRadius[i][0] + 1;
            }
            if (defaultintegralParameters[i] <= 0.0) {
                Bead_Registration.defaultintegralParameters[i] = 1.4E-45f;
            }
            integralParameters[i][0] = defaultIntegralRadius[i][0];
            integralParameters[i][1] = defaultIntegralRadius[i][1];
            integralParameters[i][2] = defaultintegralParameters[i];
        }
        return integralParameters;
    }

    public static void getInteractiveDoGParameters(String text, double[] values) {
        GenericDialogPlus gd = new GenericDialogPlus(text);
        gd.addFileField("", spimDataDirectory, 50);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String file = gd.getNextString();
        IOFunctions.println("Loading " + file);
        Image img = LOCI.openLOCIFloatType((String)file, (ContainerFactory)new ArrayContainerFactory());
        if (img == null) {
            IOFunctions.println("File not found: " + file);
            return;
        }
        img.getDisplay().setMinMax();
        ImagePlus imp = ImageJFunctions.copyToImagePlus((Image)img);
        img.close();
        imp.show();
        imp.setSlice(imp.getStackSize() / 2);
        imp.setRoi(0, 0, imp.getWidth() / 3, imp.getHeight() / 3);
        InteractiveDoG idog = new InteractiveDoG();
        if (values.length == 2) {
            idog.setSigma2isAdjustable(false);
            idog.setInitialSigma((float)values[0]);
            idog.setThreshold((float)values[1]);
        } else {
            idog.setInitialSigma((float)values[0]);
            idog.setThreshold((float)values[2]);
        }
        idog.run(null);
        while (!idog.isFinished()) {
            SimpleMultiThreading.threadWait((long)100L);
        }
        imp.close();
        if (values.length == 2) {
            values[0] = idog.getInitialSigma();
            values[1] = idog.getThreshold();
        } else {
            values[0] = idog.getInitialSigma();
            values[1] = idog.getSigma2();
            values[2] = idog.getThreshold();
        }
    }

    public static void getInteractiveIntegralParameters(String text, double[] values) {
        GenericDialogPlus gd = new GenericDialogPlus(text);
        gd.addFileField("", spimDataDirectory, 50);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String file = gd.getNextString();
        IOFunctions.println("Loading " + file);
        Image img = LOCI.openLOCIFloatType((String)file, (ContainerFactory)new ArrayContainerFactory());
        if (img == null) {
            IOFunctions.println("File not found: " + file);
            return;
        }
        img.getDisplay().setMinMax();
        ImagePlus imp = ImageJFunctions.copyToImagePlus((Image)img);
        img.close();
        imp.show();
        imp.setSlice(imp.getStackSize() / 2);
        InteractiveIntegral ii = new InteractiveIntegral();
        ii.setInitialRadius(Math.round((float)values[0]));
        ii.setThreshold((float)values[2]);
        ii.run(null);
        while (!ii.isFinished()) {
            SimpleMultiThreading.threadWait((long)100L);
        }
        imp.close();
        values[0] = ii.getRadius1();
        values[1] = ii.getRadius2();
        values[2] = ii.getThreshold();
    }

    protected static boolean init(SPIMConfiguration conf) {
        boolean success;
        conf.inputdirectory = conf.inputdirectory.replace('\\', '/');
        conf.inputdirectory = conf.inputdirectory.replaceAll("//", "/");
        conf.inputdirectory = conf.inputdirectory.trim();
        if (conf.inputdirectory.length() > 0 && !conf.inputdirectory.endsWith("/")) {
            conf.inputdirectory = conf.inputdirectory + "/";
        }
        conf.outputdirectory = conf.inputdirectory + "output/";
        conf.registrationFiledirectory = conf.inputdirectory + "registration/";
        if (conf.numberOfThreads < 1) {
            conf.numberOfThreads = Threads.numThreads();
        }
        if (conf.scaleSpaceNumberOfThreads < 1) {
            conf.scaleSpaceNumberOfThreads = Threads.numThreads();
        }
        try {
            if (conf.isHuiskenFormat()) {
                conf.getFilenamesHuisken();
            } else {
                conf.getFileNames();
            }
        }
        catch (ConfigurationParserException e) {
            IJ.error((String)("Cannot parse input: " + e));
            return false;
        }
        conf.interpolatorFactorOutput.setOutOfBoundsStrategyFactory(conf.strategyFactoryOutput);
        File dir = new File(conf.outputdirectory, "");
        if (!dir.exists()) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Creating directory '" + conf.outputdirectory + "'.");
            success = dir.mkdirs();
            if (!success && !dir.exists()) {
                IOFunctions.printErr("(" + new Date(System.currentTimeMillis()) + "): Cannot create directory '" + conf.outputdirectory + "', quitting.");
                return false;
            }
        }
        if (!(dir = new File(conf.registrationFiledirectory, "")).exists()) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Creating directory '" + conf.registrationFiledirectory + "'.");
            success = dir.mkdirs();
            if (!success && !dir.exists()) {
                IOFunctions.printErr("(" + new Date(System.currentTimeMillis()) + "): Cannot create directory '" + conf.registrationFiledirectory + "', quitting.");
                return false;
            }
        }
        return true;
    }

    public static final void addHyperLinkListener(MultiLineLabel text, String myURL) {
        GUIHelper.addHyperLinkListener(text, myURL);
    }

    public static void main(String[] args) {
        Debug.run((String)"Record...", null);
        Debug.run((String)"Find Commands...", null);
        Debug.run((String)"Bead-based registration", null);
    }
}

