/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.timelapsedisplay;

import fiji.plugin.timelapsedisplay.FileOpenMenuEntry;
import fiji.plugin.timelapsedisplay.MouseListenerTimelapse;
import fiji.plugin.timelapsedisplay.RegistrationStatistics;
import ij.gui.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class GraphFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JFreeChart chart = null;
    ChartPanel chartPanel = null;
    MouseListenerTimelapse mouseListener;
    JPanel mainPanel;
    private int referenceTimePoint;
    final boolean enableReferenceTimePoint;

    public GraphFrame(JFreeChart chart, int referenceTimePoint, boolean enableReferenceTimePoint, List<FileOpenMenuEntry> extraMenuItems, ArrayList<RegistrationStatistics> data) {
        this.referenceTimePoint = referenceTimePoint;
        this.enableReferenceTimePoint = enableReferenceTimePoint;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.updateWithNewChart(chart, true, extraMenuItems, data);
        JPanel buttonsPanel = new JPanel();
        this.mainPanel.add((Component)buttonsPanel, "South");
        this.setContentPane(this.mainPanel);
        this.validate();
        GUI.center((Window)this);
    }

    public int getReferenceTimePoint() {
        return this.mouseListener.getReferenceTimePoint();
    }

    public synchronized void updateWithNewChart(JFreeChart c, boolean setSize, List<FileOpenMenuEntry> extraMenuItems, ArrayList<RegistrationStatistics> data) {
        if (this.chartPanel != null) {
            this.remove((Component)this.chartPanel);
        }
        this.chartPanel = null;
        this.chart = c;
        this.chartPanel = new ChartPanel(c);
        this.mouseListener = new MouseListenerTimelapse(this.chartPanel, this.referenceTimePoint, this.enableReferenceTimePoint);
        this.chartPanel.addChartMouseListener((ChartMouseListener)this.mouseListener);
        this.chartPanel.setMouseWheelEnabled(true);
        this.chartPanel.setHorizontalAxisTrace(true);
        this.mainPanel.add((Component)this.chartPanel, "Center");
        JPopupMenu menu = this.chartPanel.getPopupMenu();
        if (extraMenuItems != null) {
            for (FileOpenMenuEntry m : extraMenuItems) {
                m.setChartPanel(this.chartPanel);
                menu.add(new JMenuItem(m));
            }
        }
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

