/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor;

import fiji.util.node.Leaf;
import java.util.ArrayList;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.AbstractPointDescriptor;
import mpicbg.pointdescriptor.LinkedPoint;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import spim.vecmath.Matrix3d;
import spim.vecmath.Vector3d;

public class LocalCoordinateSystemPointDescriptor<P extends Point>
extends AbstractPointDescriptor<P, LocalCoordinateSystemPointDescriptor<P>>
implements Leaf<LocalCoordinateSystemPointDescriptor<P>> {
    protected final boolean normalize;
    public float ax = 1.0f;
    public float bx;
    public float by;
    public float cx;
    public float cy;
    public float cz;

    public LocalCoordinateSystemPointDescriptor(P basisPoint, ArrayList<P> orderedNearestNeighboringPoints, boolean normalize) throws NoSuitablePointsException {
        super(basisPoint, orderedNearestNeighboringPoints, null, null);
        if (this.numDimensions != 3) {
            throw new NoSuitablePointsException("LocalCoordinateSystemPointDescriptor does not support dim = " + this.numDimensions + ", only dim = 3 is valid.");
        }
        if (this.numNeighbors() != 3) {
            throw new NoSuitablePointsException("Only 3 nearest neighbors is supported by a LocalCoordinateSystemPointDescriptor : num neighbors = " + this.numNeighbors());
        }
        this.normalize = normalize;
        this.buildLocalCoordinateSystem(this.descriptorPoints, normalize);
    }

    @Override
    public double descriptorDistance(LocalCoordinateSystemPointDescriptor<P> pointDescriptor) {
        double difference = 0.0;
        if (!this.normalize) {
            difference += (double)((this.ax - pointDescriptor.ax) * (this.ax - pointDescriptor.ax));
        }
        difference += (double)((this.bx - pointDescriptor.bx) * (this.bx - pointDescriptor.bx));
        difference += (double)((this.by - pointDescriptor.by) * (this.by - pointDescriptor.by));
        difference += (double)((this.cx - pointDescriptor.cx) * (this.cx - pointDescriptor.cx));
        difference += (double)((this.cy - pointDescriptor.cy) * (this.cy - pointDescriptor.cy));
        return difference += (double)((this.cz - pointDescriptor.cz) * (this.cz - pointDescriptor.cz));
    }

    @Override
    public Object fitMatches(ArrayList<PointMatch> matches) {
        return null;
    }

    public void buildLocalCoordinateSystem(ArrayList<LinkedPoint<P>> neighbors, boolean normalize) {
        Vector3d b = new Vector3d(neighbors.get(0).getL());
        Vector3d c = new Vector3d(neighbors.get(1).getL());
        Vector3d d = new Vector3d(neighbors.get(2).getL());
        Vector3d x = new Vector3d(d);
        x.normalize();
        if (normalize) {
            double lengthD = 1.0 / d.length();
            b.scale(lengthD);
            c.scale(lengthD);
            d.scale(lengthD);
        } else {
            this.ax = (float)d.length();
        }
        Vector3d n = new Vector3d();
        n.cross(b, x);
        n.normalize();
        if (n.dot(c) < 0.0) {
            n.negate();
        }
        Vector3d y = new Vector3d();
        y.cross(n, x);
        y.normalize();
        Matrix3d m = new Matrix3d();
        m.m00 = x.x;
        m.m01 = y.x;
        m.m02 = n.x;
        m.m10 = x.y;
        m.m11 = y.y;
        m.m12 = n.y;
        m.m20 = x.z;
        m.m21 = y.z;
        m.m22 = n.z;
        try {
            m.invert();
        }
        catch (Exception e) {
            this.cz = 0.0f;
            this.cy = 0.0f;
            this.cx = 0.0f;
            this.by = 0.0f;
            this.bx = 0.0f;
            return;
        }
        Vector3d bl = new Vector3d(b);
        Vector3d cl = new Vector3d(c);
        m.transform(bl);
        m.transform(cl);
        this.bx = (float)bl.x;
        this.by = (float)bl.y;
        this.cx = (float)cl.x;
        this.cy = (float)cl.y;
        this.cz = (float)cl.z;
    }

    public LocalCoordinateSystemPointDescriptor<P>[] createArray(int n) {
        return new LocalCoordinateSystemPointDescriptor[n];
    }

    public float distanceTo(LocalCoordinateSystemPointDescriptor<P> other) {
        return (float)Math.sqrt(this.descriptorDistance(other));
    }

    public float get(int k) {
        if (this.normalize) {
            if (k == 0) {
                return this.bx;
            }
            if (k == 1) {
                return this.by;
            }
            if (k == 2) {
                return this.cx;
            }
            if (k == 3) {
                return this.cy;
            }
            return this.cz;
        }
        if (k == 0) {
            return this.ax;
        }
        if (k == 1) {
            return this.bx;
        }
        if (k == 2) {
            return this.by;
        }
        if (k == 3) {
            return this.cx;
        }
        if (k == 4) {
            return this.cy;
        }
        return this.cz;
    }

    public int getNumDimensions() {
        if (this.normalize) {
            return 5;
        }
        return 6;
    }

    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean resetWorldCoordinatesAfterMatching() {
        return true;
    }

    @Override
    public boolean useWorldCoordinatesForDescriptorBuildUp() {
        return false;
    }
}

