/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.postprocessing.deconvolution;

import ij.IJ;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.fft.FourierConvolution;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.postprocessing.deconvolution.LucyRichardsonFFT;
import mpicbg.util.RealSum;

public class LucyRichardsonMultiViewDeconvolution {
    public static boolean debug = false;
    public static int debugInterval = 10;

    public static Image<FloatType> lucyRichardsonMultiView(final ArrayList<LucyRichardsonFFT> data, int minIterations, int maxIterations, boolean multiplicative, double lambda, final int numThreads) {
        final int numViews = data.size();
        double minValue = 1.0E-4;
        final Image psi = data.get(0).getImage().createNewImage("psi (deconvolved image)");
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    for (int i = 0; i < data.size(); ++i) {
                        if (i % numThreads != myNumber) continue;
                        IJ.log((String)(new Date(System.currentTimeMillis()) + " Norming kernel " + (i + 1)));
                        LucyRichardsonMultiViewDeconvolution.normImage((Image<FloatType>)((LucyRichardsonFFT)data.get(i)).getKernel());
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        double avg = LucyRichardsonMultiViewDeconvolution.normAllImages(data);
        IJ.log((String)("Average intensity in overlapping area: " + avg));
        Cursor cursorPsiGlobal = psi.createCursor();
        float avgFloat = (float)avg;
        while (cursorPsiGlobal.hasNext()) {
            cursorPsiGlobal.fwd();
            ((FloatType)cursorPsiGlobal.getType()).set(avgFloat);
        }
        cursorPsiGlobal.reset();
        Image nextPsi = psi.createNewImage();
        Cursor cursorNextPsiGlobal = nextPsi.createCursor();
        double sumChange = 0.0;
        int i = 0;
        do {
            IJ.log((String)("iteration: " + i++ + " (" + new Date(System.currentTimeMillis()) + ")"));
            cursorNextPsiGlobal.reset();
            while (cursorNextPsiGlobal.hasNext()) {
                cursorNextPsiGlobal.fwd();
                ((FloatType)cursorNextPsiGlobal.getType()).set(1.0f);
            }
            ai.set(0);
            threads = SimpleMultiThreading.newThreads((int)numThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        for (int view = 0; view < numViews; ++view) {
                            if (view % numThreads != myNumber) continue;
                            LucyRichardsonFFT processingData = (LucyRichardsonFFT)data.get(view);
                            FourierConvolution<FloatType, FloatType> fftConvolution = processingData.getFFTConvolution();
                            fftConvolution.replaceImage(psi);
                            fftConvolution.process();
                            Image psiBlurred = fftConvolution.getResult();
                            Cursor cursorImg = processingData.getImage().createCursor();
                            Cursor cursorPsiBlurred = psiBlurred.createCursor();
                            while (cursorImg.hasNext()) {
                                cursorImg.fwd();
                                cursorPsiBlurred.fwd();
                                float imgValue = ((FloatType)cursorImg.getType()).get();
                                float psiBlurredValue = ((FloatType)cursorPsiBlurred.getType()).get();
                                ((FloatType)cursorPsiBlurred.getType()).set(imgValue / psiBlurredValue);
                            }
                            cursorImg.close();
                            cursorPsiBlurred.close();
                            fftConvolution.replaceImage(psiBlurred);
                            fftConvolution.process();
                            processingData.setViewContribution((Image<FloatType>)fftConvolution.getResult());
                            psiBlurred.close();
                        }
                    }
                });
            }
            SimpleMultiThreading.startAndJoin((Thread[])threads);
            ArrayList<Cursor> blurredResidualsCursors = new ArrayList<Cursor>();
            ArrayList<Cursor> weightCursors = new ArrayList<Cursor>();
            for (int view = 0; view < numViews; ++view) {
                blurredResidualsCursors.add(data.get(view).getViewContribution().createCursor());
                if (data.get(view).getWeight() == null) continue;
                weightCursors.add(data.get(view).getWeight().createCursor());
            }
            cursorNextPsiGlobal.reset();
            cursorPsiGlobal.reset();
            while (cursorNextPsiGlobal.hasNext()) {
                Cursor cursorResidualsBlurred;
                int h;
                cursorNextPsiGlobal.fwd();
                double value = ((FloatType)cursorNextPsiGlobal.getType()).get();
                if (!multiplicative) {
                    value = 0.0;
                }
                double num = 0.0;
                if (weightCursors.size() > 0) {
                    for (h = 0; h < numViews; ++h) {
                        cursorResidualsBlurred = (Cursor)blurredResidualsCursors.get(h);
                        Cursor cursorWeight = (Cursor)weightCursors.get(h);
                        cursorResidualsBlurred.fwd();
                        cursorWeight.fwd();
                        float weight = ((FloatType)cursorWeight.getType()).get();
                        if (!(weight > 0.0f)) continue;
                        value = multiplicative ? (value *= Math.pow(((FloatType)cursorResidualsBlurred.getType()).get(), weight)) : (value += (double)(((FloatType)cursorResidualsBlurred.getType()).get() * weight));
                        num += (double)weight;
                    }
                } else {
                    for (h = 0; h < numViews; ++h) {
                        cursorResidualsBlurred = (Cursor)blurredResidualsCursors.get(h);
                        cursorResidualsBlurred.fwd();
                        value *= (double)((FloatType)cursorResidualsBlurred.getType()).get();
                        num += 1.0;
                    }
                }
                cursorPsiGlobal.fwd();
                value = num > 0.0 ? (multiplicative ? (double)((FloatType)cursorPsiGlobal.getType()).get() * Math.pow(value, 1.0 / num) : (double)((FloatType)cursorPsiGlobal.getType()).get() * (double)((FloatType)cursorNextPsiGlobal.getType()).get() * value / num) : 1.0E-4;
                ((FloatType)cursorNextPsiGlobal.getType()).set((float)value);
            }
            for (Cursor cursorResidualsBlurred : blurredResidualsCursors) {
                cursorResidualsBlurred.close();
            }
            for (Cursor cursorWeight : weightCursors) {
                cursorWeight.close();
            }
            if (lambda > 0.0) {
                cursorNextPsiGlobal.reset();
                while (cursorNextPsiGlobal.hasNext()) {
                    cursorNextPsiGlobal.fwd();
                    float f = ((FloatType)cursorNextPsiGlobal.getType()).get();
                    float reg = (float)((Math.sqrt(1.0 + 2.0 * lambda * (double)f) - 1.0) / lambda);
                    ((FloatType)cursorNextPsiGlobal.getType()).set(reg);
                }
            }
            cursorPsiGlobal.reset();
            cursorNextPsiGlobal.reset();
            sumChange = 0.0;
            double maxChange = -1.0;
            while (cursorNextPsiGlobal.hasNext()) {
                cursorPsiGlobal.fwd();
                cursorNextPsiGlobal.fwd();
                float lastPsiValue = ((FloatType)cursorPsiGlobal.getType()).get();
                float nextPsiValue = Float.isNaN(((FloatType)cursorNextPsiGlobal.getType()).get()) ? 1.0E-4f : (float)Math.max(1.0E-4, (double)((FloatType)cursorNextPsiGlobal.getType()).get());
                ((FloatType)cursorPsiGlobal.getType()).set(nextPsiValue);
                float change = Math.abs(lastPsiValue - nextPsiValue);
                sumChange += (double)change;
                maxChange = Math.max(maxChange, (double)change);
            }
            IJ.log((String)"------------------------------------------------");
            IJ.log((String)(" Change: " + sumChange));
            IJ.log((String)(" Max Change per Pixel: " + maxChange));
            IJ.log((String)"------------------------------------------------");
            System.out.println(i + "\t" + sumChange + "\t" + maxChange);
            if (!debug || i % debugInterval != 0) continue;
            Image psiCopy = psi.clone();
            psiCopy.setName("Iteration " + i + " l=" + lambda);
            psiCopy.getDisplay().setMinMax(0.0, 1.0);
            ImageJFunctions.copyToImagePlus((Image)psiCopy).show();
            psiCopy.close();
            psiCopy = null;
        } while (i < maxIterations);
        cursorPsiGlobal.close();
        cursorNextPsiGlobal.close();
        nextPsi.close();
        return psi;
    }

    public static double normAllImages(ArrayList<LucyRichardsonFFT> data) {
        RealSum sum = new RealSum();
        long count = 0L;
        ArrayList<Cursor> cursorsImage = new ArrayList<Cursor>();
        ArrayList<Cursor> cursorsWeight = new ArrayList<Cursor>();
        for (LucyRichardsonFFT fft : data) {
            cursorsImage.add(fft.getImage().createCursor());
            if (fft.getWeight() == null) continue;
            cursorsWeight.add(fft.getWeight().createCursor());
        }
        Cursor cursor = (Cursor)cursorsImage.get(0);
        while (cursor.hasNext()) {
            for (Cursor c : cursorsImage) {
                c.fwd();
            }
            for (Cursor c : cursorsWeight) {
                c.fwd();
            }
            double sumLocal = 0.0;
            int countLocal = 0;
            for (int i = 0; i < cursorsImage.size(); ++i) {
                if (((FloatType)((Cursor)cursorsWeight.get(i)).getType()).get() == 0.0f) continue;
                sumLocal += (double)((FloatType)((Cursor)cursorsImage.get(i)).getType()).get();
                ++countLocal;
            }
            if (countLocal <= true) continue;
            sum.add(sumLocal);
            count += (long)countLocal;
        }
        if (count == 0L) {
            return 1.0;
        }
        double avg = sum.getSum() / (double)count;
        for (Cursor c : cursorsImage) {
            c.close();
        }
        for (Cursor c : cursorsWeight) {
            c.close();
        }
        return avg;
    }

    private static final BigDecimal sumImage(Image<FloatType> img) {
        BigDecimal sum = new BigDecimal(0, MathContext.UNLIMITED);
        Cursor cursorImg = img.createCursor();
        while (cursorImg.hasNext()) {
            cursorImg.fwd();
            sum = sum.add(BigDecimal.valueOf(((FloatType)cursorImg.getType()).get()));
        }
        cursorImg.close();
        return sum;
    }

    private static final void normImage(Image<FloatType> img) {
        BigDecimal sum = LucyRichardsonMultiViewDeconvolution.sumImage(img);
        Cursor cursor = img.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((FloatType)cursor.getType()).set((float)((double)((FloatType)cursor.getType()).get() / sum.doubleValue()));
        }
        cursor.close();
    }
}

