/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.preprocessing;

import java.util.ArrayList;
import mpicbg.models.AffineModel3D;
import mpicbg.models.CoordinateTransform;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import mpicbg.util.TransformUtils;
import spim.vecmath.AxisAngle4d;
import spim.vecmath.Matrix3d;
import spim.vecmath.Point3d;
import spim.vecmath.Transform3D;
import spim.vecmath.Vector3d;

public class AutomaticAngleSetup {
    public AutomaticAngleSetup(ViewStructure viewStructure) {
        ArrayList<ViewDataBeads> views = viewStructure.getViews();
        ViewDataBeads viewA = views.get(0);
        ViewDataBeads viewB = views.get(1);
        IOFunctions.println("Using view " + viewA.getName() + " and " + viewB.getName() + " for automatic angle setup.");
        Vector3d rotationAxis = AutomaticAngleSetup.extractRotationAxis((AffineModel3D)viewA.getTile().getModel(), (AffineModel3D)viewB.getTile().getModel());
        IOFunctions.println("rotation axis: " + rotationAxis);
        rotationAxis.normalize();
        IOFunctions.println("rotation axis normed: " + rotationAxis);
        Vector3d xAxis = new Vector3d(new double[]{1.0, 0.0, 0.0});
        IOFunctions.println("Difference to xAxis: " + AutomaticAngleSetup.distance(rotationAxis, xAxis));
    }

    public static double distance(Vector3d a, Vector3d b) {
        double dx = a.x - b.x;
        double dy = a.y - b.y;
        double dz = a.z - b.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static void testRotationAxis() {
        Transform3D a = new Transform3D();
        Transform3D b = new Transform3D();
        a.setRotation(new AxisAngle4d(new Vector3d(1.0, 2.0, 3.0), Math.toRadians(45.0)));
        b.setRotation(new AxisAngle4d(new Vector3d(1.0, 2.0, 3.0), Math.toRadians(90.0)));
        Transform3D c = new Transform3D(a);
        c.mul(a);
        IOFunctions.println(c);
        IOFunctions.println(b);
        Vector3d roationAxis = AutomaticAngleSetup.extractRotationAxis(TransformUtils.getAffineModel3D(a), TransformUtils.getAffineModel3D(b));
        IOFunctions.println(roationAxis);
        IOFunctions.println(AutomaticAngleSetup.extractRotationAngle(TransformUtils.getAffineModel3D(a), TransformUtils.getAffineModel3D(b), roationAxis));
    }

    public static double extractRotationAngle(AffineModel3D modelA, AffineModel3D modelB, Vector3d rotationAxis) {
        Transform3D transformA = TransformUtils.getTransform3D(modelA);
        Transform3D transformB = TransformUtils.getTransform3D(modelB);
        transformA.setTranslation(new Vector3d());
        transformB.setTranslation(new Vector3d());
        Transform3D connectingTransform = new Transform3D();
        Transform3D tmp = new Transform3D();
        Matrix3d matrix1 = new Matrix3d();
        Matrix3d matrix2 = new Matrix3d();
        transformB.get(matrix2);
        double minError = 3.4028234663852886E38;
        double minAngle = -1.0;
        for (double angle = 0.0; angle < 360.0; angle += 1.0) {
            connectingTransform.setIdentity();
            connectingTransform.setRotation(new AxisAngle4d(rotationAxis, Math.toRadians(angle)));
            tmp.set(transformA);
            tmp.mul(connectingTransform);
            tmp.get(matrix1);
            matrix1.sub(matrix2);
            double diff = matrix1.m00 * matrix1.m00 + matrix1.m01 * matrix1.m01 + matrix1.m02 * matrix1.m02 + matrix1.m10 * matrix1.m10 + matrix1.m11 * matrix1.m11 + matrix1.m12 * matrix1.m12 + matrix1.m20 * matrix1.m20 + matrix1.m21 * matrix1.m21 + matrix1.m22 * matrix1.m22;
            IOFunctions.println(angle + " " + diff);
            if (!(diff < minError)) continue;
            minError = diff;
            minAngle = angle;
        }
        return minAngle;
    }

    public static Vector3d extractRotationAxis(AffineModel3D model) {
        double[] matrix = model.getMatrix(null);
        double m00 = matrix[0];
        double m01 = matrix[1];
        double m02 = matrix[2];
        double m10 = matrix[4];
        double m11 = matrix[5];
        double m12 = matrix[6];
        double m20 = matrix[8];
        double m21 = matrix[9];
        double m22 = matrix[10];
        Vector3d rotationAxis = new Vector3d(1.0, 0.0, 0.0);
        double x = rotationAxis.x;
        rotationAxis.y = ((1.0 - m00) * (1.0 - m22) * x - m20 * m02 * x) / (m01 * (1.0 - m22) + m21 * m02);
        rotationAxis.z = ((1.0 - m00) * (1.0 - m11) * x - m10 * m01 * x) / (m02 * (1.0 - m11) + m12 * m01);
        return rotationAxis;
    }

    public static Vector3d extractRotationAxis(AffineModel3D modelA, AffineModel3D modelB) {
        double[] matrixA = modelA.getMatrix(null);
        double[] matrixB = modelB.getMatrix(null);
        double m00 = matrixA[0];
        double m01 = matrixA[1];
        double m02 = matrixA[2];
        double m10 = matrixA[4];
        double m11 = matrixA[5];
        double m12 = matrixA[6];
        double m20 = matrixA[8];
        double m21 = matrixA[9];
        double m22 = matrixA[10];
        double n00 = matrixB[0];
        double n01 = matrixB[1];
        double n02 = matrixB[2];
        double n10 = matrixB[4];
        double n11 = matrixB[5];
        double n12 = matrixB[6];
        double n20 = matrixB[8];
        double n21 = matrixB[9];
        double n22 = matrixB[10];
        Vector3d rotationAxis = new Vector3d(1.0, 0.0, 0.0);
        double x = rotationAxis.x;
        rotationAxis.y = ((m00 - n00) * (m22 - n22) * x - (n20 - m20) * (n02 - m02) * x) / ((n01 - m01) * (m22 - n22) + (n21 - m21) * (n02 - m02));
        rotationAxis.z = ((m00 - n00) * (m11 - n11) * x - (n10 - m10) * (n01 - m01) * x) / ((n02 - m02) * (m11 - n11) + (n12 - m12) * (n01 - m01));
        return rotationAxis;
    }

    public static Vector3d extractRotationAxis(Matrix3d matrixA, Matrix3d matrixB) {
        double m00 = matrixA.m00;
        double m01 = matrixA.m01;
        double m02 = matrixA.m02;
        double m10 = matrixA.m10;
        double m11 = matrixA.m11;
        double m12 = matrixA.m12;
        double m20 = matrixA.m20;
        double m21 = matrixA.m21;
        double m22 = matrixA.m22;
        double n00 = matrixB.m00;
        double n01 = matrixB.m01;
        double n02 = matrixB.m02;
        double n10 = matrixB.m10;
        double n11 = matrixB.m11;
        double n12 = matrixB.m12;
        double n20 = matrixB.m20;
        double n21 = matrixB.m21;
        double n22 = matrixB.m22;
        Vector3d rotationAxis = new Vector3d(1.0, 0.0, 0.0);
        double x = rotationAxis.x;
        rotationAxis.y = ((m00 - n00) * (m22 - n22) * x - (n20 - m20) * (n02 - m02) * x) / ((n01 - m01) * (m22 - n22) + (n21 - m21) * (n02 - m02));
        rotationAxis.z = ((m00 - n00) * (m11 - n11) * x - (n10 - m10) * (n01 - m01) * x) / ((n02 - m02) * (m11 - n11) + (n12 - m12) * (n01 - m01));
        return rotationAxis;
    }

    protected void getCommonAreaPerpendicularViews(ViewDataBeads viewA, ViewDataBeads viewB) {
        double[][] minMaxDimViewA = TransformUtils.getMinMaxDim(viewA.getImageSize(), (CoordinateTransform)viewA.getTile().getModel());
        double[][] minMaxDimViewB = TransformUtils.getMinMaxDim(viewB.getImageSize(), (CoordinateTransform)viewB.getTile().getModel());
        double maxX = minMaxDimViewB[0][1];
        double minY = minMaxDimViewB[1][0];
        double maxY = minMaxDimViewB[1][1];
        double minZ = minMaxDimViewA[2][0];
        double maxZ = minMaxDimViewA[2][1];
        IOFunctions.println("X1: " + minMaxDimViewA[0][0] + " -> " + minMaxDimViewA[0][1]);
        IOFunctions.println("X2: " + minMaxDimViewB[0][0] + " -> " + minMaxDimViewB[0][1]);
        IOFunctions.println("Y1: " + minMaxDimViewA[1][0] + " -> " + minMaxDimViewA[1][1]);
        IOFunctions.println("Y2: " + minMaxDimViewB[1][0] + " -> " + minMaxDimViewB[1][1]);
        IOFunctions.println("Z1: " + minMaxDimViewA[2][0] + " -> " + minMaxDimViewA[2][1]);
        IOFunctions.println("Z2: " + minMaxDimViewB[2][0] + " -> " + minMaxDimViewB[2][1]);
        double angle = Math.toRadians(30.0);
        Point3d q = new Point3d(maxX, (maxY - minY) / 2.0, (maxZ - minZ) / 2.0);
        Point3d r = new Point3d(0.0, Math.cos(angle), Math.sin(angle));
        Point3d p1 = new Point3d(maxX, minY, minZ);
        Point3d p2 = new Point3d(maxX, maxY, minZ);
        Point3d p3 = new Point3d(maxX, minY, maxZ);
        Point3d p4 = new Point3d(maxX, maxY, maxZ);
        double lambda1 = this.computeLambda(q, r, p1);
        double lambda2 = this.computeLambda(q, r, p2);
        double lambda3 = this.computeLambda(q, r, p3);
        double lambda4 = this.computeLambda(q, r, p4);
        Point3d fp1 = new Point3d(lambda1 * r.x + q.x, lambda1 * r.y + q.y, lambda1 * r.z + q.z);
        Point3d fp2 = new Point3d(lambda2 * r.x + q.x, lambda2 * r.y + q.y, lambda2 * r.z + q.z);
        Point3d fp3 = new Point3d(lambda3 * r.x + q.x, lambda3 * r.y + q.y, lambda3 * r.z + q.z);
        Point3d fp4 = new Point3d(lambda4 * r.x + q.x, lambda4 * r.y + q.y, lambda4 * r.z + q.z);
        double d1 = Math.sqrt(Math.pow(p1.x - fp1.x, 2.0) + Math.pow(p1.y - fp1.y, 2.0) + Math.pow(p1.z - fp1.z, 2.0));
        double d2 = Math.sqrt(Math.pow(p2.x - fp2.x, 2.0) + Math.pow(p2.y - fp2.y, 2.0) + Math.pow(p2.z - fp2.z, 2.0));
        double d3 = Math.sqrt(Math.pow(p3.x - fp3.x, 2.0) + Math.pow(p3.y - fp3.y, 2.0) + Math.pow(p3.z - fp3.z, 2.0));
        double d4 = Math.sqrt(Math.pow(p4.x - fp4.x, 2.0) + Math.pow(p4.y - fp4.y, 2.0) + Math.pow(p4.z - fp4.z, 2.0));
        IOFunctions.println(d1 + " " + d2 + " " + d3 + " " + d4);
    }

    protected double computeLambda(Point3d q, Point3d r, Point3d p) {
        return (p.x + p.y + p.z - (r.x * q.x + r.y * q.y + r.z * q.z)) / (r.x * r.x + r.y * r.y + r.z * r.z);
    }

    public static void main(String[] args) {
        SPIMConfiguration config = IOFunctions.initSPIMProcessing();
        ViewStructure viewStructure = ViewStructure.initViewStructure(config, 0, new AffineModel3D(), "ViewStructure Timepoint 0", config.debugLevelInt);
        for (ViewDataBeads view : viewStructure.getViews()) {
            view.loadDimensions();
            view.loadSegmentation();
            view.loadRegistration();
        }
        new AutomaticAngleSetup(viewStructure);
    }
}

