/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.queryXML;

import fiji.util.gui.GenericDialogPlus;
import ij.gui.GenericDialog;
import java.awt.Color;
import java.awt.Container;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.XmlIoAbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.NamedEntity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.io.IOFunctions;
import spim.Version;
import spim.fiji.plugin.Toggle_Cluster_Options;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.EmptyEntity;
import spim.fiji.spimdata.NamePattern;

public class GenericLoadParseQueryXML<AS extends AbstractSpimData<S>, S extends AbstractSequenceDescription<V, D, L>, V extends BasicViewSetup, D extends BasicViewDescription<V>, L extends BasicImgLoader, X extends XmlIoAbstractSpimData<S, AS>> {
    public static String defaultXMLfilename = "";
    public static boolean debugRandomClusterHash = false;
    protected static String goodMsg1 = "The selected XML file was parsed successfully";
    protected static String warningMsg1 = "The selected file does not appear to be an xml. Press OK to try to parse anyways.";
    protected static String errorMsg1 = "An ERROR occured parsing this XML file! Please select a different XML (see log)";
    protected static String neutralMsg1 = "No XML file selected.";
    protected static String noMsg2 = " ";
    protected static String[] attributeChoiceList = new String[]{"All *s", "Single * (Select from List)", "Multiple *s (Select from List)", "Range of *s (Specify by Name)"};
    public static final String[] clusterOptions1 = new String[]{"Do not process on cluster", "Save every XML with unique id generated from processed subset", "Save every XML with user-provided unique id"};
    public static int defaultClusterOption1 = 1;
    public static HashMap<String, Integer> defaultAttributeChoice = new HashMap();
    public static HashMap<String, Integer> defaultAttributeEntityIndex = new HashMap();
    public static HashMap<String, String> defaultAttributePatternString = new HashMap();
    public static HashMap<String, boolean[]> defaultAttributeSelectedEntities = new HashMap();
    protected HashMap<String, Integer> attributeChoice = new HashMap();
    protected final X io;
    protected Comparator<String> comparator = null;
    protected String message1;
    protected String message2;
    protected Color color;
    protected AS data;
    protected String xmlfilename;
    protected ArrayList<TimePoint> timepointsToProcess;
    protected ArrayList<String> attributes;
    protected HashMap<String, List<Entity>> allAttributeInstances;
    protected HashMap<String, List<Entity>> attributeInstancesToProcess;
    protected String clusterExt = null;
    protected String buttonText = null;
    protected ActionListener listener = null;
    protected GenericDialog gd = null;
    protected boolean returnfalse = false;

    public GenericLoadParseQueryXML(X io) {
        this.io = io;
        IOFunctions.println("Using spimdata version: " + mpicbg.spim.data.Version.getVersion());
        IOFunctions.println("Using spimreconstruction version: " + Version.getVersion());
    }

    public X getIO() {
        return this.io;
    }

    public AS getData() {
        return this.data;
    }

    public String getXMLFileName() {
        return this.xmlfilename;
    }

    public List<TimePoint> getTimePointsToProcess() {
        return this.timepointsToProcess;
    }

    public ArrayList<V> getViewSetupsToProcess() {
        ArrayList<BasicViewSetup> viewSetups = new ArrayList<BasicViewSetup>();
        for (BasicViewSetup v : this.data.getSequenceDescription().getViewSetupsOrdered()) {
            boolean contained = true;
            for (String attribute : this.attributes) {
                Entity attributeEntityForViewSetup = (Entity)v.getAttributes().get(attribute);
                if (this.attributeInstancesToProcess.get(attribute).contains(attributeEntityForViewSetup)) continue;
                contained = false;
            }
            if (!contained) continue;
            viewSetups.add(v);
        }
        return viewSetups;
    }

    public void setComparator(Comparator<String> comparator) {
        this.comparator = comparator;
    }

    public Comparator<String> getComparator() {
        return this.comparator;
    }

    public boolean queryXML() {
        return this.queryXML("", "Process", null);
    }

    public boolean queryXML(List<String> specifyAttributes) {
        return this.queryXML("", "Process", specifyAttributes);
    }

    public boolean queryXML(String query) {
        return this.queryXML("", query, null);
    }

    public boolean queryXML(String query, List<String> specifyAttributes) {
        return this.queryXML("", query, specifyAttributes);
    }

    public void addButton(String buttonText, ActionListener listener) {
        this.buttonText = buttonText;
        this.listener = listener;
    }

    public GenericDialog getGenericDialog() {
        return this.gd;
    }

    public void setReturnFalse(boolean value) {
        this.returnfalse = value;
    }

    public boolean queryXML(String additionalTitle, String query, List<String> specifyAttributes) {
        if (specifyAttributes == null) {
            specifyAttributes = new ArrayList<String>();
        }
        if (this.comparator == null) {
            Collections.sort(specifyAttributes);
        } else {
            Collections.sort(specifyAttributes, this.comparator);
        }
        if (specifyAttributes.contains("Timepoint")) {
            specifyAttributes.remove("Timepoint");
            specifyAttributes.add("Timepoint");
        }
        if (query.contains(" ")) {
            query = query.replaceAll(" ", "_");
        }
        this.attributeChoice = new HashMap();
        this.tryParsing(defaultXMLfilename, false);
        GenericDialogPlus gd = additionalTitle != null && additionalTitle.length() > 0 ? new GenericDialogPlus("Select dataset for " + additionalTitle) : new GenericDialogPlus("Select Dataset");
        gd.addFileField("Select_XML", defaultXMLfilename, 65);
        gd.addMessage(this.message1, GUIHelper.largestatusfont, this.color);
        Label l1 = (Label)gd.getMessage();
        gd.addMessage(this.message2, GUIHelper.smallStatusFont, this.color);
        Label l2 = (Label)gd.getMessage();
        if (specifyAttributes.size() > 0) {
            gd.addMessage(" ");
        }
        for (int i = 0; i < specifyAttributes.size(); ++i) {
            String attribute = specifyAttributes.get(i);
            String[] choices = GenericLoadParseQueryXML.makeChoiceList(attribute);
            int defaultChoice = defaultAttributeChoice.containsKey(attribute) ? defaultAttributeChoice.get(attribute) : 0;
            gd.addChoice(query + "_" + attribute, choices, choices[defaultChoice]);
        }
        if (Toggle_Cluster_Options.displayClusterProcessing) {
            gd.addMessage("");
            gd.addChoice("XML_Output", clusterOptions1, clusterOptions1[defaultClusterOption1]);
            gd.addMessage("Note: Later on you need to merge the different XML's using Plugins>MultiView Reconstruction>Tools>Cluster>Merge Cluster Jobs", GUIHelper.smallStatusFont);
        }
        this.addListeners((GenericDialog)gd, (TextField)gd.getStringFields().firstElement(), l1, l2);
        if (this.buttonText != null && this.listener != null) {
            gd.addMessage("");
            gd.addMessage("OR");
            gd.addMessage("");
            gd.addButton(this.buttonText, this.listener);
            this.gd = gd;
        }
        gd.addMessage("");
        GUIHelper.addPreibischLabWebsite((GenericDialog)gd);
        gd.showDialog();
        if (gd.wasCanceled() || this.returnfalse) {
            return false;
        }
        String xmlFilename = defaultXMLfilename = gd.getNextString();
        this.tryParsing(xmlFilename, true);
        for (int i = 0; i < specifyAttributes.size(); ++i) {
            String attribute = specifyAttributes.get(i);
            int choice = gd.getNextChoiceIndex();
            defaultAttributeChoice.put(attribute, choice);
            this.attributeChoice.put(attribute, choice);
        }
        int clusterSaving = Toggle_Cluster_Options.displayClusterProcessing ? (defaultClusterOption1 = gd.getNextChoiceIndex()) : 0;
        if (!this.queryDetails()) {
            return false;
        }
        if (clusterSaving == 0) {
            this.clusterExt = "";
        } else if (clusterSaving == 1) {
            this.clusterExt = "job_" + this.createUniqueName();
        } else {
            GenericDialog gdCluster = new GenericDialog("Define unique ID");
            gdCluster.addStringField("UNIQUE_ID", "");
            gdCluster.addMessage("Note: Using an ID twice might result in overwriting of the XML files.", GUIHelper.smallStatusFont);
            gdCluster.showDialog();
            if (gdCluster.wasCanceled()) {
                return false;
            }
            this.clusterExt = "job_" + gdCluster.getNextString();
        }
        return true;
    }

    public String getClusterExtension() {
        return this.clusterExt;
    }

    protected String createUniqueName() {
        long idSum = 1L;
        for (TimePoint t : this.getTimePointsToProcess()) {
            idSum *= (long)t.getId();
        }
        for (BasicViewSetup v : this.getViewSetupsToProcess()) {
            idSum += (long)v.getId();
        }
        long nano = System.nanoTime();
        long millis = System.currentTimeMillis();
        long finalHash = nano + millis + idSum;
        if (debugRandomClusterHash) {
            IOFunctions.println("idsum=" + idSum);
            IOFunctions.println("nano=" + nano);
            IOFunctions.println("millis=" + millis);
            IOFunctions.println("final=" + finalHash);
        }
        return "" + finalHash;
    }

    public static int queryIndividualEntry(String name, String[] list, int defaultSelection) {
        if (defaultSelection >= list.length) {
            defaultSelection = 0;
        }
        GenericDialog gd = new GenericDialog("Select Single " + name);
        gd.addChoice("Processing_" + name, list, list[defaultSelection]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return -1;
        }
        return gd.getNextChoiceIndex();
    }

    public static boolean[] queryMultipleEntries(String name, String[] list, boolean[] defaultSelection) {
        int i;
        int i2;
        if (defaultSelection == null || defaultSelection.length != list.length) {
            defaultSelection = new boolean[list.length];
            defaultSelection[0] = true;
            for (i2 = 1; i2 < list.length; ++i2) {
                defaultSelection[i2] = false;
            }
            if (defaultSelection.length > 1) {
                defaultSelection[1] = true;
            }
        }
        for (i2 = 0; i2 < list.length; ++i2) {
            list[i2] = list[i2].replace(" ", "_");
        }
        GenericDialog gd = new GenericDialog("Select Multiple " + name);
        gd.addMessage("");
        for (i = 0; i < list.length; ++i) {
            gd.addCheckbox(list[i], defaultSelection[i]);
        }
        gd.addMessage("");
        GUIHelper.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        for (i = 0; i < list.length; ++i) {
            defaultSelection[i] = gd.getNextBoolean();
        }
        return defaultSelection;
    }

    public static boolean[] queryPattern(String name, String[] list, String[] defaultSelectionArray) {
        String defaultSelection = defaultSelectionArray[0];
        if (defaultSelection == null || defaultSelection.length() == 0) {
            defaultSelection = list[0];
            for (int i = 1; i < Math.min(list.length, 3); ++i) {
                defaultSelection = defaultSelection + "," + list[i];
            }
        }
        GenericDialog gd = new GenericDialog("Select Range of " + name);
        gd.addMessage("");
        gd.addStringField("Process_following_" + name, defaultSelection, 30);
        gd.addMessage("");
        gd.addMessage("Available " + name + ":");
        String singular = name.substring(0, name.length() - 1) + " ";
        String allTps = singular + list[0];
        for (int i = 1; i < list.length; ++i) {
            allTps = allTps + "\n" + singular + list[i];
        }
        gd.addMessage(allTps, GUIHelper.smallStatusFont);
        GUIHelper.addScrollBars((Container)gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        boolean[] selected = new boolean[list.length];
        for (int i = 0; i < list.length; ++i) {
            selected[i] = false;
        }
        try {
            defaultSelection = gd.getNextString();
            ArrayList<String> nameList = NamePattern.parseNameString(defaultSelection, true);
            for (String entry : nameList) {
                boolean found = false;
                for (int i = 0; i < list.length && !found; ++i) {
                    if (!entry.equals(list[i])) continue;
                    selected[i] = true;
                    found = true;
                }
                if (found) continue;
                IOFunctions.println(name + " " + entry + " not part of the list of " + name + "s. Ignoring it.");
            }
        }
        catch (ParseException e) {
            IOFunctions.println("Cannot parse pattern '" + defaultSelection + "': " + e);
            return null;
        }
        defaultSelectionArray[0] = defaultSelection;
        return selected;
    }

    protected <E extends Entity> boolean query(int choice, String attribute, List<E> allEntities, List<E> entitiesToProcess) {
        if (choice == 1) {
            int selection;
            int defaultSelection;
            int n = defaultSelection = defaultAttributeEntityIndex.containsKey(attribute) ? defaultAttributeEntityIndex.get(attribute) : 0;
            if (defaultSelection >= allEntities.size()) {
                defaultSelection = 0;
            }
            if ((selection = GenericLoadParseQueryXML.queryIndividualEntry(attribute, GenericLoadParseQueryXML.buildEntityList(attribute, allEntities, true), defaultSelection)) < 0) {
                return false;
            }
            entitiesToProcess.add(allEntities.get(selection));
            defaultAttributeEntityIndex.put(attribute, selection);
        } else if (choice == 2 || choice == 3) {
            String[] defaultPattern = new String[]{defaultAttributePatternString.get(attribute)};
            boolean[] defaultSelectedEntities = defaultAttributeSelectedEntities.get(attribute);
            boolean[] selection = choice == 2 ? GenericLoadParseQueryXML.queryMultipleEntries(attribute + "s", GenericLoadParseQueryXML.buildEntityList(attribute, allEntities, true), defaultSelectedEntities) : GenericLoadParseQueryXML.queryPattern(attribute + "s", GenericLoadParseQueryXML.buildEntityList(attribute, allEntities, false), defaultPattern);
            if (selection == null) {
                return false;
            }
            defaultAttributeSelectedEntities.put(attribute, selection);
            if (choice == 3) {
                defaultAttributePatternString.put(attribute, defaultPattern[0]);
            }
            for (int i = 0; i < selection.length; ++i) {
                if (!selection[i]) continue;
                entitiesToProcess.add(allEntities.get(i));
            }
        } else {
            entitiesToProcess.addAll(allEntities);
        }
        if (entitiesToProcess.size() == 0) {
            throw new RuntimeException("List of " + attribute + "s is empty. Stopping.");
        }
        String selected = "";
        for (int e = 0; e < entitiesToProcess.size(); ++e) {
            selected = entitiesToProcess.get(e) instanceof NamedEntity ? selected + ((NamedEntity)entitiesToProcess.get(e)).getName() : selected + ((Entity)entitiesToProcess.get(e)).getId();
            if (e == entitiesToProcess.size() - 1) continue;
            selected = selected + ", ";
        }
        IOFunctions.println(attribute + "s selected: " + selected);
        return true;
    }

    protected boolean queryDetails() {
        int choice;
        this.attributeInstancesToProcess = new HashMap();
        for (int attributeIndex = 0; attributeIndex < this.attributes.size(); ++attributeIndex) {
            this.attributeInstancesToProcess.put(this.attributes.get(attributeIndex), new ArrayList());
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            int choice2;
            String attribute = this.attributes.get(i);
            int n = choice2 = this.attributeChoice.containsKey(attribute) ? this.attributeChoice.get(attribute) : 0;
            if (this.query(choice2, attribute, this.allAttributeInstances.get(attribute), this.attributeInstancesToProcess.get(attribute))) continue;
            return false;
        }
        this.timepointsToProcess = new ArrayList();
        String attribute = "Timepoint";
        int n = choice = this.attributeChoice.containsKey("Timepoint") ? this.attributeChoice.get("Timepoint") : 0;
        return this.query(choice, "Timepoint", this.data.getSequenceDescription().getTimePoints().getTimePointsOrdered(), this.timepointsToProcess);
    }

    protected static String[] buildTimepointList(List<TimePoint> tpList, boolean addTitle) {
        String[] timepoints = new String[tpList.size()];
        for (int i = 0; i < timepoints.length; ++i) {
            timepoints[i] = addTitle ? "Timepoint " + tpList.get(i).getName() : tpList.get(i).getName();
        }
        return timepoints;
    }

    protected static String[] buildEntityList(String attributeName, List<? extends Entity> entityList, boolean addTitle) {
        String[] entities = new String[entityList.size()];
        for (int i = 0; i < entities.length; ++i) {
            Entity e = entityList.get(i);
            String entityName = e instanceof NamedEntity ? ((NamedEntity)e).getName() : Integer.toString(e.getId());
            entities[i] = addTitle ? attributeName + " " + entityName : entityName;
        }
        return entities;
    }

    protected static String[] makeChoiceList(String attribute) {
        String[] choiceList = new String[attributeChoiceList.length];
        for (int i = 0; i < choiceList.length; ++i) {
            choiceList[i] = attributeChoiceList[i].replace("*", attribute);
        }
        return choiceList;
    }

    protected boolean tryParsing(String xmlfile, boolean parseAllTypes) {
        this.xmlfilename = xmlfile;
        this.message1 = neutralMsg1;
        this.message2 = noMsg2;
        this.color = GUIHelper.neutral;
        this.data = null;
        if (parseAllTypes || !parseAllTypes && xmlfile.endsWith(".xml")) {
            try {
                this.data = this.parseXML(xmlfile);
                this.attributes = new ArrayList();
                this.attributes.addAll(((BasicViewSetup)this.data.getSequenceDescription().getViewSetupsOrdered().get(0)).getAttributes().keySet());
                if (this.comparator == null) {
                    Collections.sort(this.attributes);
                } else {
                    Collections.sort(this.attributes, this.comparator);
                }
                int numAttributes = this.attributes.size();
                this.allAttributeInstances = new HashMap();
                ArrayList numEntitiesPerAttrib = new ArrayList(numAttributes);
                for (int attributeIndex = 0; attributeIndex < numAttributes; ++attributeIndex) {
                    this.allAttributeInstances.put(this.attributes.get(attributeIndex), new ArrayList());
                    numEntitiesPerAttrib.add(new HashSet());
                }
                for (BasicViewSetup basicViewSetup : this.data.getSequenceDescription().getViewSetupsOrdered()) {
                    for (int attributeIndex = 0; attributeIndex < numAttributes; ++attributeIndex) {
                        int id;
                        String attribute = this.attributes.get(attributeIndex);
                        HashSet numEntityIds = (HashSet)numEntitiesPerAttrib.get(attributeIndex);
                        Object e = (Entity)basicViewSetup.getAttributes().get(attribute);
                        if (e == null) {
                            if (attribute.equals("angle")) {
                                IOFunctions.println(new Date(System.currentTimeMillis()) + ": 'angle' attribute undefined, using Angle 0 to support it.");
                                e = new Angle(0);
                                basicViewSetup.setAttribute(e);
                            } else if (attribute.equals("channel")) {
                                IOFunctions.println(new Date(System.currentTimeMillis()) + ": 'channel' attribute undefined, using Channel 0 to support it.");
                                e = new Channel(0);
                                basicViewSetup.setAttribute(e);
                            } else if (attribute.equals("illumination")) {
                                IOFunctions.println(new Date(System.currentTimeMillis()) + ": 'illumination' attribute undefined, using Illumination 0 to support it.");
                                e = new Illumination(0);
                                basicViewSetup.setAttribute(e);
                            } else {
                                IOFunctions.println(new Date(System.currentTimeMillis()) + ": Unknown entity '" + attribute + "', adding placeholder entity to support it.");
                                e = new EmptyEntity(0, attribute);
                                basicViewSetup.getAttributes().put(attribute, e);
                            }
                        }
                        if (numEntityIds.contains(id = e.getId())) continue;
                        numEntityIds.add(id);
                        this.allAttributeInstances.get(attribute).add((Entity)e);
                    }
                }
                for (String string : this.allAttributeInstances.keySet()) {
                    Collections.sort(this.allAttributeInstances.get(string), new Comparator<Entity>(){

                        @Override
                        public int compare(Entity o1, Entity o2) {
                            return o1.getId() - o2.getId();
                        }
                    });
                }
                int countMissingViews = 0;
                for (BasicViewDescription v : this.data.getSequenceDescription().getViewDescriptions().values()) {
                    if (v.isPresent()) continue;
                    ++countMissingViews;
                }
                int n = this.data.getSequenceDescription().getTimePoints().size();
                this.message1 = goodMsg1;
                this.message2 = "";
                for (int attributeIndex = 0; attributeIndex < numAttributes; ++attributeIndex) {
                    int numEntities = ((HashSet)numEntitiesPerAttrib.get(attributeIndex)).size();
                    String entityName = this.attributes.get(attributeIndex);
                    if (numEntities > 1) {
                        entityName = entityName + "s";
                    }
                    this.message2 = this.message2 + numEntities + " " + entityName + ", ";
                }
                this.message2 = n > 1 ? this.message2 + n + " timepoints, " : this.message2 + n + " timepoint, ";
                this.message2 = countMissingViews == 1 ? this.message2 + countMissingViews + " missing view" : this.message2 + countMissingViews + " missing views";
                this.color = GUIHelper.good;
            }
            catch (Exception e) {
                this.message1 = errorMsg1;
                this.message2 = noMsg2;
                this.color = GUIHelper.error;
                IOFunctions.println("Cannot parse '" + xmlfile + "': " + e);
                e.printStackTrace();
                return false;
            }
        } else if (xmlfile.length() > 0) {
            this.message1 = warningMsg1;
            this.message2 = noMsg2;
            this.color = GUIHelper.warning;
            return false;
        }
        return true;
    }

    protected AS parseXML(String xmlFilename) throws SpimDataException {
        return (AS)this.io.load(xmlFilename);
    }

    protected void addListeners(GenericDialog gd, final TextField tf, final Label label1, final Label label2) {
        final GenericLoadParseQueryXML lpq = this;
        tf.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent t) {
                if (t.getID() == 900) {
                    String xmlFilename = tf.getText();
                    GenericLoadParseQueryXML.this.tryParsing(xmlFilename, false);
                    label1.setText(lpq.message1);
                    label2.setText(lpq.message2);
                    label1.setForeground(lpq.color);
                    label2.setForeground(lpq.color);
                }
            }
        });
    }
}

