/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.spimdata.XmlIoSpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBoxes;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class SpimData2
extends SpimData {
    private ViewInterestPoints viewsInterestPoints;
    private BoundingBoxes boundingBoxes;

    public SpimData2(File basePath, SequenceDescription sequenceDescription, ViewRegistrations viewRegistrations, ViewInterestPoints viewsInterestPoints, BoundingBoxes boundingBoxes) {
        super(basePath, sequenceDescription, viewRegistrations);
        this.viewsInterestPoints = viewsInterestPoints;
        this.boundingBoxes = boundingBoxes;
    }

    protected SpimData2() {
    }

    public ViewInterestPoints getViewInterestPoints() {
        return this.viewsInterestPoints;
    }

    public BoundingBoxes getBoundingBoxes() {
        return this.boundingBoxes;
    }

    protected void setViewsInterestPoints(ViewInterestPoints viewsInterestPoints) {
        this.viewsInterestPoints = viewsInterestPoints;
    }

    protected void setBoundingBoxes(BoundingBoxes boundingBoxes) {
        this.boundingBoxes = boundingBoxes;
    }

    public static ViewId getViewId(SequenceDescription seqDesc, TimePoint t, Channel c, Angle a, Illumination i) {
        ViewSetup viewSetup = SpimData2.getViewSetup(seqDesc.getViewSetupsOrdered(), c, a, i);
        if (viewSetup == null) {
            return null;
        }
        return new ViewId(t.getId(), viewSetup.getId());
    }

    public static ViewSetup getViewSetup(List<? extends ViewSetup> list, Channel c, Angle a, Illumination i) {
        for (ViewSetup viewSetup : list) {
            if (viewSetup.getAngle().getId() != a.getId() || viewSetup.getChannel().getId() != c.getId() || viewSetup.getIllumination().getId() != i.getId()) continue;
            return viewSetup;
        }
        return null;
    }

    public static ArrayList<ViewSetup> getAllViewSetupsSorted(SpimData data, List<? extends ViewId> viewIds) {
        HashSet<ViewSetup> setups = new HashSet<ViewSetup>();
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            ViewSetup setup = (ViewSetup)vd.getViewSetup();
            if (!vd.isPresent()) continue;
            setups.add(setup);
        }
        ArrayList<ViewSetup> setupList = new ArrayList<ViewSetup>();
        setupList.addAll(setups);
        Collections.sort(setupList);
        return setupList;
    }

    public static ArrayList<ViewId> getAllViewIdsSorted(SpimData data, List<? extends ViewSetup> setups, List<? extends TimePoint> tps) {
        ArrayList<ViewId> viewIds = new ArrayList<ViewId>();
        for (TimePoint timePoint : tps) {
            for (ViewSetup viewSetup : setups) {
                ViewId v = new ViewId(timePoint.getId(), viewSetup.getId());
                ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(v);
                if (!vd.isPresent()) continue;
                viewIds.add((ViewId)vd);
            }
        }
        Collections.sort(viewIds);
        return viewIds;
    }

    public static ArrayList<Angle> getAllAnglesForChannelTimepointSorted(SpimData data, Collection<? extends ViewId> viewIds, Channel c, TimePoint t) {
        HashSet<Angle> angleSet = new HashSet<Angle>();
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            if (!vd.isPresent() || viewId.getTimePointId() != t.getId() || ((ViewSetup)vd.getViewSetup()).getChannel().getId() != c.getId()) continue;
            angleSet.add(((ViewSetup)vd.getViewSetup()).getAngle());
        }
        ArrayList<Angle> angles = new ArrayList<Angle>();
        angles.addAll(angleSet);
        Collections.sort(angles);
        return angles;
    }

    public static ArrayList<Angle> getAllAnglesSorted(SpimData data, Collection<? extends ViewId> viewIds) {
        HashSet<Angle> angleSet = new HashSet<Angle>();
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            if (!vd.isPresent()) continue;
            angleSet.add(((ViewSetup)vd.getViewSetup()).getAngle());
        }
        ArrayList<Angle> angles = new ArrayList<Angle>();
        angles.addAll(angleSet);
        Collections.sort(angles);
        return angles;
    }

    public static ArrayList<Illumination> getAllIlluminationsForChannelTimepointSorted(SpimData data, Collection<? extends ViewId> viewIds, Channel c, TimePoint t) {
        HashSet<Illumination> illumSet = new HashSet<Illumination>();
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            if (!vd.isPresent() || viewId.getTimePointId() != t.getId() || ((ViewSetup)vd.getViewSetup()).getChannel().getId() != c.getId()) continue;
            illumSet.add(((ViewSetup)vd.getViewSetup()).getIllumination());
        }
        ArrayList<Illumination> illums = new ArrayList<Illumination>();
        illums.addAll(illumSet);
        Collections.sort(illums);
        return illums;
    }

    public static ArrayList<Illumination> getAllIlluminationsSorted(SpimData data, Collection<? extends ViewId> viewIds) {
        HashSet<Illumination> illumSet = new HashSet<Illumination>();
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            if (!vd.isPresent()) continue;
            illumSet.add(((ViewSetup)vd.getViewSetup()).getIllumination());
        }
        ArrayList<Illumination> illums = new ArrayList<Illumination>();
        illums.addAll(illumSet);
        Collections.sort(illums);
        return illums;
    }

    public static ArrayList<Channel> getAllChannelsSorted(SpimData data, Collection<? extends ViewId> viewIds) {
        HashSet<Channel> channelSet = new HashSet<Channel>();
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            if (!vd.isPresent()) continue;
            channelSet.add(((ViewSetup)vd.getViewSetup()).getChannel());
        }
        ArrayList<Channel> channels = new ArrayList<Channel>();
        channels.addAll(channelSet);
        Collections.sort(channels);
        return channels;
    }

    public static ArrayList<ViewDescription> getAllViewIdsForChannelSorted(SpimData data, Collection<? extends ViewId> viewIds, Channel channel) {
        ArrayList<ViewDescription> views = new ArrayList<ViewDescription>();
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            if (!vd.isPresent() || ((ViewSetup)vd.getViewSetup()).getChannel().getId() != channel.getId()) continue;
            views.add(vd);
        }
        Collections.sort(views);
        return views;
    }

    public static ArrayList<ViewDescription> getAllViewIdsForChannelTimePointSorted(SpimData data, Collection<? extends ViewId> viewIds, Channel channel, TimePoint timePoint) {
        ArrayList<ViewDescription> views = new ArrayList<ViewDescription>();
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            if (!vd.isPresent() || ((ViewSetup)vd.getViewSetup()).getChannel().getId() != channel.getId() || viewId.getTimePointId() != timePoint.getId()) continue;
            views.add(vd);
        }
        Collections.sort(views);
        return views;
    }

    public static ArrayList<ViewDescription> getAllViewIdsForTimePointSorted(SpimData data, Collection<? extends ViewId> viewIds, TimePoint timepoint) {
        ArrayList<ViewDescription> views = new ArrayList<ViewDescription>();
        for (ViewId viewId : viewIds) {
            ViewDescription vd = ((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId);
            if (!vd.isPresent() || vd.getTimePointId() != timepoint.getId()) continue;
            views.add(vd);
        }
        Collections.sort(views);
        return views;
    }

    public static ArrayList<ViewSetup> getAllViewSetups(Collection<? extends ViewDescription> vds) {
        HashSet<BasicViewSetup> set = new HashSet<BasicViewSetup>();
        for (ViewDescription viewDescription : vds) {
            if (!viewDescription.isPresent()) continue;
            set.add(viewDescription.getViewSetup());
        }
        ArrayList<ViewSetup> setups = new ArrayList<ViewSetup>();
        setups.addAll(set);
        Collections.sort(setups);
        return setups;
    }

    public static ArrayList<TimePoint> getAllTimePointsSorted(SpimData data, Collection<? extends ViewId> viewIds) {
        ArrayList<ViewDescription> vds = new ArrayList<ViewDescription>();
        for (ViewId viewId : viewIds) {
            vds.add(((SequenceDescription)data.getSequenceDescription()).getViewDescription(viewId));
        }
        return SpimData2.getAllTimePointsSorted(vds);
    }

    public static ArrayList<TimePoint> getAllTimePointsSorted(Collection<? extends ViewDescription> vds) {
        HashSet<TimePoint> timepointSet = new HashSet<TimePoint>();
        for (ViewDescription viewDescription : vds) {
            if (!viewDescription.isPresent()) continue;
            timepointSet.add(viewDescription.getTimePoint());
        }
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>();
        timepoints.addAll(timepointSet);
        Collections.sort(timepoints, new Comparator<TimePoint>(){

            @Override
            public int compare(TimePoint o1, TimePoint o2) {
                return o1.getId() - o2.getId();
            }
        });
        return timepoints;
    }

    public static String saveXML(SpimData2 data, String xmlFileName, String clusterExtension) {
        XmlIoSpimData2 io = new XmlIoSpimData2(clusterExtension);
        String xml = new File(data.getBasePath(), new File(xmlFileName).getName()).getAbsolutePath();
        try {
            io.save(data, xml);
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Saved xml '" + io.lastFileName() + "'.");
            return xml;
        }
        catch (Exception e) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Could not save xml '" + io.lastFileName() + "': " + e);
            e.printStackTrace();
            return null;
        }
    }
}

