/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.interestpoint;

import bdv.BigDataViewer;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.TransformListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import mpicbg.spim.data.generic.XmlIoAbstractSpimData;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.util.Pair;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.explorer.SelectedViewDescriptionListener;
import spim.fiji.spimdata.explorer.ViewSetupExplorer;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.interestpoint.InterestPointExplorerPanel;
import spim.fiji.spimdata.explorer.popup.BDVPopup;
import spim.fiji.spimdata.interestpoints.InterestPointList;

public class InterestPointExplorer<AS extends SpimData2, X extends XmlIoAbstractSpimData<?, AS>>
implements SelectedViewDescriptionListener<AS> {
    final String xml;
    final JFrame frame;
    final InterestPointExplorerPanel panel;
    final ViewSetupExplorer<AS, X> viewSetupExplorer;

    public InterestPointExplorer(String xml, X io, ViewSetupExplorer<AS, X> viewSetupExplorer) {
        this.xml = xml;
        this.viewSetupExplorer = viewSetupExplorer;
        this.frame = new JFrame("Interest Point Explorer");
        this.panel = new InterestPointExplorerPanel(((SpimData2)((Object)viewSetupExplorer.getPanel().getSpimData())).getViewInterestPoints(), viewSetupExplorer);
        this.frame.add((Component)this.panel, "Center");
        this.frame.setSize(this.panel.getPreferredSize());
        this.frame.pack();
        this.frame.setVisible(true);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((dim.width - this.frame.getSize().width) / 2, (dim.height - this.frame.getSize().height) / 4);
        viewSetupExplorer.addListener(this);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InterestPointExplorer.this.quit();
                e.getWindow().dispose();
            }
        });
    }

    public JFrame frame() {
        return this.frame;
    }

    @Override
    public void seletedViewDescription(BasicViewDescription<? extends BasicViewSetup> viewDescription) {
        this.panel.updateViewDescription(viewDescription, false);
    }

    @Override
    public void save() {
        for (Pair<InterestPointList, ViewId> list : this.panel.delete) {
            IOFunctions.println("Deleting correspondences and interestpoints in timepointid=" + ((ViewId)list.getB()).getTimePointId() + ", viewid=" + ((ViewId)list.getB()).getViewSetupId());
            File ip = new File(((InterestPointList)list.getA()).getBaseDir(), ((InterestPointList)list.getA()).getFile().toString() + ((InterestPointList)list.getA()).getInterestPointsExt());
            File corr = new File(((InterestPointList)list.getA()).getBaseDir(), ((InterestPointList)list.getA()).getFile().toString() + ((InterestPointList)list.getA()).getCorrespondencesExt());
            if (ip.delete()) {
                IOFunctions.println("Deleted: " + ip.getAbsolutePath());
            } else {
                IOFunctions.println("FAILED to delete: " + ip.getAbsolutePath());
            }
            if (corr.delete()) {
                IOFunctions.println("Deleted: " + corr.getAbsolutePath());
                continue;
            }
            IOFunctions.println("FAILED to delete: " + corr.getAbsolutePath());
        }
        this.panel.delete.clear();
    }

    @Override
    public void quit() {
        if (BDVPopup.bdvRunning() && this.panel.tableModel.interestPointOverlay != null) {
            BigDataViewer bdv = ViewSetupExplorerPanel.bdvPopup().bdv;
            bdv.getViewer().removeTransformListener((TransformListener)this.panel.tableModel.interestPointOverlay);
            bdv.getViewer().getDisplay().removeOverlayRenderer((OverlayRenderer)this.panel.tableModel.interestPointOverlay);
            ViewSetupExplorerPanel.bdvPopup().updateBDV();
        }
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public InterestPointExplorerPanel panel() {
        return this.panel;
    }

    @Override
    public void updateContent(AS data) {
        this.panel.getTableModel().update(((SpimData2)((Object)data)).getViewInterestPoints());
        this.panel.getTableModel().fireTableDataChanged();
    }
}

