/*
 * Decompiled with CFR 0.152.
 */
package spim.process.cuda;

import java.util.ArrayList;
import net.imglib2.iterator.LocalizingZeroMinIntervalIterator;
import net.imglib2.util.Util;
import spim.process.cuda.Block;
import spim.process.cuda.BlockGenerator;

public class BlockGeneratorVariableSizePrecise
implements BlockGenerator<Block> {
    final long[] numBlocks;

    public BlockGeneratorVariableSizePrecise(long[] numBlocksDim) {
        this.numBlocks = numBlocksDim;
    }

    public Block[] divideIntoBlocks(long[] imgSize, long[] kernelSize) {
        int numDimensions = imgSize.length;
        LocalizingZeroMinIntervalIterator cursor = new LocalizingZeroMinIntervalIterator(this.numBlocks);
        ArrayList<Block> blockList = new ArrayList<Block>();
        long[] currentBlock = new long[numDimensions];
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(currentBlock);
            long[] blockSize = new long[numDimensions];
            long[] offset = new long[numDimensions];
            long[] effectiveOffset = new long[numDimensions];
            long[] effectiveSize = new long[numDimensions];
            long[] effectiveLocalOffset = new long[numDimensions];
            for (int d = 0; d < numDimensions; ++d) {
                effectiveLocalOffset[d] = kernelSize[d] / 2L;
                effectiveSize[d] = currentBlock[d] == this.numBlocks[d] - 1L ? imgSize[d] / this.numBlocks[d] : imgSize[d] / this.numBlocks[d] + imgSize[d] % this.numBlocks[d];
                blockSize[d] = effectiveSize[d] + kernelSize[d] - 1L;
                effectiveOffset[d] = currentBlock[d] * effectiveSize[d];
                offset[d] = effectiveOffset[d] - kernelSize[d] / 2L;
                if (effectiveSize[d] > 0L) continue;
                System.out.println("Blocksize in dimension " + d + " (" + blockSize[d] + ") is smaller than the kernel (" + kernelSize[d] + ") which results in an negative effective size: " + effectiveSize[d] + ". Quitting.");
                return null;
            }
            blockList.add(new Block(blockSize, offset, effectiveSize, effectiveOffset, effectiveLocalOffset, true));
            System.out.println("block " + Util.printCoordinates((long[])currentBlock) + " offset: " + Util.printCoordinates((long[])offset) + " effectiveOffset: " + Util.printCoordinates((long[])effectiveOffset) + " effectiveLocalOffset: " + Util.printCoordinates((long[])effectiveLocalOffset) + " effectiveSize: " + Util.printCoordinates((long[])effectiveSize) + " blocksize: " + Util.printCoordinates((long[])blockSize));
        }
        Block[] blocks = new Block[blockList.size()];
        for (int i = 0; i < blockList.size(); ++i) {
            blocks[i] = (Block)blockList.get(i);
        }
        return blocks;
    }

    public static void main(String[] args) {
        new BlockGeneratorVariableSizePrecise(new long[]{3L, 2L, 1L}).divideIntoBlocks(new long[]{1025L, 1024L, 117L}, new long[]{17L, 17L, 5L});
    }
}

