/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import java.util.concurrent.Callable;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;

public class TransformInput
implements Callable<String> {
    final ImagePortion portion;
    final RandomAccessibleInterval<FloatType> img;
    final AffineTransform3D transform;
    final RandomAccessibleInterval<FloatType> transformedImg;
    final int offsetX;
    final int offsetY;
    final int offsetZ;
    final int imgSizeX;
    final int imgSizeY;
    final int imgSizeZ;

    public TransformInput(ImagePortion portion, RandomAccessibleInterval<FloatType> img, AffineTransform3D transform, RandomAccessibleInterval<FloatType> transformedImg, long[] offset) {
        this.portion = portion;
        this.img = img;
        this.transform = transform;
        this.transformedImg = transformedImg;
        this.offsetX = (int)offset[0];
        this.offsetY = (int)offset[1];
        this.offsetZ = (int)offset[2];
        this.imgSizeX = (int)img.dimension(0);
        this.imgSizeY = (int)img.dimension(1);
        this.imgSizeZ = (int)img.dimension(2);
    }

    @Override
    public String call() throws Exception {
        NLinearInterpolatorFactory f = new NLinearInterpolatorFactory();
        RealRandomAccess ir = Views.interpolate((EuclideanSpace)Views.extendMirrorSingle(this.img), (InterpolatorFactory)f).realRandomAccess();
        Cursor cursor = Views.iterable(this.transformedImg).localizingCursor();
        float[] s = new float[3];
        float[] t = new float[3];
        cursor.jumpFwd(this.portion.getStartPosition());
        int j = 0;
        while ((long)j < this.portion.getLoopSize()) {
            TransformInput.loop((Cursor<FloatType>)cursor, (RealRandomAccess<FloatType>)ir, this.transform, s, t, this.offsetX, this.offsetY, this.offsetZ, this.imgSizeX, this.imgSizeY, this.imgSizeZ);
            ++j;
        }
        return this.portion + " finished successfully (transform input & no weights).";
    }

    private static final void loop(Cursor<FloatType> cursor, RealRandomAccess<FloatType> ir, AffineTransform3D transform, float[] s, float[] t, int offsetX, int offsetY, int offsetZ, int imgSizeX, int imgSizeY, int imgSizeZ) {
        FloatType v = (FloatType)cursor.next();
        cursor.localize(s);
        s[0] = s[0] + (float)offsetX;
        s[1] = s[1] + (float)offsetY;
        s[2] = s[2] + (float)offsetZ;
        transform.applyInverse(t, s);
        if (FusionHelper.intersects(t[0], t[1], t[2], imgSizeX, imgSizeY, imgSizeZ)) {
            ir.setPosition(t);
            v.set(Math.max(1.0E-4f, ((FloatType)ir.get()).get()));
        }
    }
}

