/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import ij.ImageJ;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.Threads;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;
import spim.process.fusion.weights.BlendingRealRandomAccess;
import spim.process.fusion.weights.NormalizingRandomAccessibleInterval;

public class WeightNormalizer {
    final List<RandomAccessibleInterval<FloatType>> weights;
    final Img<FloatType> sumWeights;
    int minOverlappingViews;
    double avgOverlappingViews;

    public WeightNormalizer(List<RandomAccessibleInterval<FloatType>> weights) {
        this.weights = weights;
        this.sumWeights = null;
    }

    public WeightNormalizer(List<RandomAccessibleInterval<FloatType>> weights, ImgFactory<FloatType> factory) {
        this.weights = weights;
        this.sumWeights = factory.create((Dimensions)weights.get(0), (Object)new FloatType());
    }

    public int getMinOverlappingViews() {
        return this.minOverlappingViews;
    }

    public double getAvgOverlappingViews() {
        return this.avgOverlappingViews;
    }

    public Img<FloatType> getSumWeights() {
        return this.sumWeights;
    }

    public boolean process() {
        Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(Views.iterable(this.weights.get(0)).size(), Threads.numThreads() * 2);
        ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
        ArrayList<Callable<double[]>> tasks = new ArrayList<Callable<double[]>>();
        for (ImagePortion imagePortion : portions) {
            if (this.sumWeights == null) {
                tasks.add(new ApplyDirectly(imagePortion));
                continue;
            }
            tasks.add(new ComputeSumImage(imagePortion, this.sumWeights));
        }
        try {
            List futures = taskExecutor.invokeAll(tasks);
            this.minOverlappingViews = this.weights.size();
            this.avgOverlappingViews = 0.0;
            for (Future future : futures) {
                double[] minAvg = (double[])future.get();
                this.minOverlappingViews = Math.min(this.minOverlappingViews, (int)Math.round(minAvg[0]));
                this.avgOverlappingViews += minAvg[1];
            }
            this.avgOverlappingViews /= (double)futures.size();
        }
        catch (Exception e) {
            IOFunctions.println("Failed to compute weight normalization for deconvolution: " + e);
            e.printStackTrace();
            return false;
        }
        taskExecutor.shutdown();
        if (this.sumWeights != null) {
            for (int i = 0; i < this.weights.size(); ++i) {
                RandomAccessibleInterval<FloatType> randomAccessibleInterval = this.weights.get(i);
                NormalizingRandomAccessibleInterval<FloatType> normalizingRandomAccessibleInterval = new NormalizingRandomAccessibleInterval<FloatType>(randomAccessibleInterval, (RandomAccessibleInterval<FloatType>)this.sumWeights, new FloatType());
                this.weights.set(i, normalizingRandomAccessibleInterval);
            }
        }
        return true;
    }

    private static final void apply(ArrayList<Cursor<FloatType>> cursors, double sumW) {
        for (Cursor<FloatType> c : cursors) {
            ((FloatType)c.get()).set((float)((double)((FloatType)c.get()).get() / sumW));
        }
    }

    public static void main(String[] args) {
        new ImageJ();
        ArrayImg img = ArrayImgs.floats((long[])new long[]{500L, 500L});
        BlendingRealRandomAccess blend = new BlendingRealRandomAccess((Interval)img, new float[]{100.0f, 0.0f}, new float[]{12.0f, 150.0f});
        Cursor c = img.localizingCursor();
        while (c.hasNext()) {
            c.fwd();
            blend.setPosition((Localizable)c);
            ((FloatType)c.get()).setReal(blend.get().getRealFloat());
        }
        ImageJFunctions.show((RandomAccessibleInterval)img);
    }

    private final class ComputeSumImage
    implements Callable<double[]> {
        final ImagePortion portion;
        final Img<FloatType> sumWeights;

        public ComputeSumImage(ImagePortion portion, Img<FloatType> sumWeights) {
            this.portion = portion;
            this.sumWeights = sumWeights;
        }

        @Override
        public double[] call() throws Exception {
            ArrayList<Cursor> cursors = new ArrayList<Cursor>();
            RandomAccess ra = this.sumWeights.randomAccess();
            for (int i = 0; i < WeightNormalizer.this.weights.size(); ++i) {
                RandomAccessibleInterval<FloatType> imgW = WeightNormalizer.this.weights.get(i);
                Cursor c = i == 0 ? Views.iterable(imgW).localizingCursor() : Views.iterable(imgW).cursor();
                c.jumpFwd(this.portion.getStartPosition());
                cursors.add(c);
            }
            Cursor firstCursor = (Cursor)cursors.get(0);
            int minNumViews = cursors.size();
            long countViews = 0L;
            for (long j = 0L; j < this.portion.getLoopSize(); ++j) {
                double sumW = 0.0;
                int count = 0;
                for (Cursor c : cursors) {
                    float w = ((FloatType)c.next()).get();
                    sumW += (double)w;
                    if (!(w > 0.0f)) continue;
                    ++count;
                }
                countViews += (long)count;
                minNumViews = Math.min(minNumViews, count);
                ra.setPosition((Localizable)firstCursor);
                if (sumW > 1.0) {
                    ((FloatType)ra.get()).set((float)sumW);
                    continue;
                }
                ((FloatType)ra.get()).setOne();
            }
            double avgNumViews = (double)countViews / (double)this.portion.getLoopSize();
            return new double[]{minNumViews, avgNumViews};
        }
    }

    private final class ApplyDirectly
    implements Callable<double[]> {
        final ImagePortion portion;

        public ApplyDirectly(ImagePortion portion) {
            this.portion = portion;
        }

        @Override
        public double[] call() throws Exception {
            ArrayList<Cursor> cursors = new ArrayList<Cursor>();
            for (RandomAccessibleInterval<FloatType> imgW : WeightNormalizer.this.weights) {
                Cursor c = Views.iterable(imgW).cursor();
                c.jumpFwd(this.portion.getStartPosition());
                cursors.add(c);
            }
            int minNumViews = cursors.size();
            long countViews = 0L;
            for (long j = 0L; j < this.portion.getLoopSize(); ++j) {
                double sumW = 0.0;
                int count = 0;
                for (Cursor c : cursors) {
                    float w = ((FloatType)c.next()).get();
                    sumW += (double)w;
                    if (!(w > 0.0f)) continue;
                    ++count;
                }
                countViews += (long)count;
                minNumViews = Math.min(minNumViews, count);
                WeightNormalizer.apply(cursors, sumW);
            }
            double avgNumViews = (double)countViews / (double)this.portion.getLoopSize();
            return new double[]{minNumViews, avgNumViews};
        }
    }
}

