/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.export;

import ij.gui.GenericDialog;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.TimePointsPattern;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import spim.fiji.plugin.resave.Resave_TIFF;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.XmlIoSpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBoxes;
import spim.fiji.spimdata.imgloaders.StackImgLoaderIJ;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.ImgExport;
import spim.process.fusion.export.Save3dTIFF;
import spim.process.fusion.export.XMLTIFFImgTitler;

public class ExportSpimData2TIFF
implements ImgExport {
    List<TimePoint> newTimepoints;
    List<ViewSetup> newViewSetups;
    Resave_TIFF.Parameters params;
    Save3dTIFF saver;
    SpimData2 spimData;

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs) {
        return this.exportImage(img, bb, tp, vs, Double.NaN, Double.NaN);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> boolean exportImage(RandomAccessibleInterval<T> img, BoundingBoxGUI bb, TimePoint tp, ViewSetup vs, double min, double max) {
        if (!this.saver.exportImage(img, bb, tp, vs, min, max)) {
            return false;
        }
        ViewRegistration vr = this.spimData.getViewRegistrations().getViewRegistration(new ViewId(tp.getId(), vs.getId()));
        double scale = bb.getDownSampling();
        AffineTransform3D m = new AffineTransform3D();
        m.set(scale, 0.0, 0.0, (double)bb.min(0), 0.0, scale, 0.0, (double)bb.min(1), 0.0, 0.0, scale, (double)bb.min(2));
        ViewTransformAffine vt = new ViewTransformAffine("fusion bounding box", m);
        vr.getTransformList().clear();
        vr.getTransformList().add(vt);
        return true;
    }

    @Override
    public boolean finish() {
        XmlIoSpimData2 io = new XmlIoSpimData2("");
        try {
            io.save(this.spimData, new File(this.params.getXMLFile()).getAbsolutePath());
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Saved xml '" + io.lastFileName() + "'.");
            return false;
        }
        catch (SpimDataException e) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Could not save xml '" + io.lastFileName() + "'.");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void setXMLData(List<TimePoint> newTimepoints, List<ViewSetup> newViewSetups) {
        this.newTimepoints = newTimepoints;
        this.newViewSetups = newViewSetups;
    }

    @Override
    public boolean queryParameters(SpimData2 spimData, boolean is16bit) {
        if (this.newTimepoints == null || this.newViewSetups == null) {
            IOFunctions.println("new timepoints and new viewsetup list not set yet ... cannot continue");
            return false;
        }
        if (Resave_TIFF.defaultPath == null) {
            Resave_TIFF.defaultPath = "";
        }
        this.params = Resave_TIFF.getParameters();
        if (this.params == null) {
            return false;
        }
        this.saver = new Save3dTIFF(new File(this.params.getXMLFile()).getParent(), this.params.compress());
        this.saver.setImgTitler(new XMLTIFFImgTitler(this.newTimepoints, this.newViewSetups));
        this.spimData = this.createSpimData2(this.newTimepoints, this.newViewSetups, this.params);
        return true;
    }

    @Override
    public void queryAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
    }

    @Override
    public boolean parseAdditionalParameters(GenericDialog gd, SpimData2 spimData) {
        return true;
    }

    @Override
    public ImgExport newInstance() {
        return new ExportSpimData2TIFF();
    }

    @Override
    public String getDescription() {
        return "Save as new XML Project (TIFF)";
    }

    protected SpimData2 createSpimData2(List<TimePoint> timepointsToProcess, List<ViewSetup> viewSetupsToProcess, Resave_TIFF.Parameters params) {
        FileNamePattern fnp = ExportSpimData2TIFF.getFileNamePattern(timepointsToProcess, viewSetupsToProcess, params.compress());
        SpimData2 newSpimData = ExportSpimData2TIFF.assembleSpimData2(timepointsToProcess, viewSetupsToProcess, new File(params.getXMLFile()).getParentFile());
        StackImgLoaderIJ imgLoader = new StackImgLoaderIJ(new File(params.getXMLFile()).getParentFile(), fnp.fileNamePattern, params.getImgFactory(), fnp.layoutTP, fnp.layoutChannels, fnp.layoutIllum, fnp.layoutAngles, null);
        ((SequenceDescription)newSpimData.getSequenceDescription()).setImgLoader((BasicImgLoader)imgLoader);
        return newSpimData;
    }

    public static FileNamePattern getFileNamePattern(List<TimePoint> timepoints, List<ViewSetup> viewSetups, boolean compress) {
        FileNamePattern fnp = new FileNamePattern();
        fnp.layoutTP = 0;
        fnp.layoutChannels = 0;
        fnp.layoutIllum = 0;
        fnp.layoutAngles = 0;
        fnp.fileNamePattern = "img";
        if (timepoints.size() > 1) {
            fnp.fileNamePattern = fnp.fileNamePattern + "_TL{t}";
            fnp.layoutTP = 1;
        }
        if (XMLTIFFImgTitler.getAllChannels(viewSetups).size() > 1) {
            fnp.fileNamePattern = fnp.fileNamePattern + "_Ch{c}";
            fnp.layoutChannels = 1;
        }
        if (XMLTIFFImgTitler.getAllIlluminations(viewSetups).size() > 1) {
            fnp.fileNamePattern = fnp.fileNamePattern + "_Ill{i}";
            fnp.layoutIllum = 1;
        }
        if (XMLTIFFImgTitler.getAllAngles(viewSetups).size() > 1) {
            fnp.fileNamePattern = fnp.fileNamePattern + "_Angle{a}";
            fnp.layoutAngles = 1;
        }
        fnp.fileNamePattern = fnp.fileNamePattern + ".tif";
        if (compress) {
            fnp.fileNamePattern = fnp.fileNamePattern + ".zip";
        }
        return fnp;
    }

    public static SpimData2 assembleSpimData2(List<TimePoint> timepointsToProcess, List<ViewSetup> viewSetupsToProcess, File basePath) {
        TimePointsPattern timepoints;
        try {
            timepoints = new TimePointsPattern(Resave_TIFF.listAllTimePoints(timepointsToProcess));
        }
        catch (ParseException e) {
            IOFunctions.println("Automatically created list of timepoints failed to parse. This should not happen, really :) -- " + e);
            IOFunctions.println("Here is the list: " + Resave_TIFF.listAllTimePoints(timepointsToProcess));
            e.printStackTrace();
            return null;
        }
        MissingViews missingViews = new MissingViews(new ArrayList());
        SequenceDescription sequenceDescription = new SequenceDescription((TimePoints)timepoints, viewSetupsToProcess, null, missingViews);
        HashMap<ViewRegistration, ViewRegistration> regMap = new HashMap<ViewRegistration, ViewRegistration>();
        for (ViewDescription vDesc : sequenceDescription.getViewDescriptions().values()) {
            ViewRegistration viewRegistration = new ViewRegistration(vDesc.getTimePointId(), vDesc.getViewSetupId());
            viewRegistration.identity();
            regMap.put(viewRegistration, viewRegistration);
        }
        ViewRegistrations viewRegistrations = new ViewRegistrations(regMap);
        ViewInterestPoints viewsInterestPoints = new ViewInterestPoints(new HashMap<ViewId, ViewInterestPointLists>());
        SpimData2 newSpimData = new SpimData2(basePath, sequenceDescription, viewRegistrations, viewsInterestPoints, new BoundingBoxes());
        return newSpimData;
    }

    public static class FileNamePattern {
        public int layoutTP = 0;
        public int layoutChannels = 0;
        public int layoutIllum = 0;
        public int layoutAngles = 0;
        public String fileNamePattern;
    }
}

