/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.geometrichashing;

import fiji.util.KDTree;
import fiji.util.NNearestNeighborSearch;
import fiji.util.node.Leaf;
import java.util.ArrayList;
import mpicbg.models.Point;
import mpicbg.pointdescriptor.LocalCoordinateSystemPointDescriptor;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import spim.process.interestpointregistration.Detection;

public class GeometricHasher {
    public ArrayList<PointMatchGeneric<Detection>> extractCorrespondenceCandidates(ArrayList<Detection> nodeListA, ArrayList<Detection> nodeListB, double differenceThreshold, double ratioOfDistance, boolean useAssociatedBeads) {
        int numNeighbors = 3;
        KDTree tree1 = new KDTree(nodeListA);
        KDTree tree2 = new KDTree(nodeListB);
        ArrayList<LocalCoordinateSystemPointDescriptor<Detection>> descriptors1 = GeometricHasher.createLocalCoordinateSystemPointDescriptors(tree1, nodeListA, 3, false);
        ArrayList<LocalCoordinateSystemPointDescriptor<Detection>> descriptors2 = GeometricHasher.createLocalCoordinateSystemPointDescriptors(tree2, nodeListB, 3, false);
        KDTree lookUpTree2 = new KDTree(descriptors2);
        NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(lookUpTree2);
        ArrayList<PointMatchGeneric<Detection>> correspondences = new ArrayList<PointMatchGeneric<Detection>>();
        this.computeMatching(descriptors1, (NNearestNeighborSearch<LocalCoordinateSystemPointDescriptor<Detection>>)nnsearch, correspondences, differenceThreshold, ratioOfDistance);
        return correspondences;
    }

    protected void computeMatching(ArrayList<LocalCoordinateSystemPointDescriptor<Detection>> descriptors1, NNearestNeighborSearch<LocalCoordinateSystemPointDescriptor<Detection>> nnsearch2, ArrayList<PointMatchGeneric<Detection>> correspondences, double differenceThreshold, double ratioOfDistance) {
        for (LocalCoordinateSystemPointDescriptor<Detection> descriptorA : descriptors1) {
            LocalCoordinateSystemPointDescriptor[] matches = (LocalCoordinateSystemPointDescriptor[])nnsearch2.findNNearestNeighbors(descriptorA, 2);
            double best = descriptorA.descriptorDistance(matches[0]);
            double secondBest = descriptorA.descriptorDistance(matches[1]);
            if (!(best < differenceThreshold) || !(best * ratioOfDistance <= secondBest)) continue;
            Detection detectionA = (Detection)((Object)descriptorA.getBasisPoint());
            Detection detectionB = (Detection)((Object)matches[0].getBasisPoint());
            correspondences.add(new PointMatchGeneric<Detection>(detectionA, detectionB, 1.0));
        }
    }

    public static <P extends Point> ArrayList<LocalCoordinateSystemPointDescriptor<P>> createLocalCoordinateSystemPointDescriptors(KDTree<P> tree, ArrayList<P> basisPoints, int numNeighbors, boolean normalize) {
        NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(tree);
        ArrayList<LocalCoordinateSystemPointDescriptor<P>> descriptors = new ArrayList<LocalCoordinateSystemPointDescriptor<P>>();
        for (Point point : basisPoints) {
            ArrayList<Point> neighbors = new ArrayList<Point>();
            Point[] neighborList = (Point[])nnsearch.findNNearestNeighbors((Leaf)point, numNeighbors + 1);
            for (int n = 1; n < neighborList.length; ++n) {
                neighbors.add(neighborList[n]);
            }
            try {
                descriptors.add(new LocalCoordinateSystemPointDescriptor<Point>(point, neighbors, normalize));
            }
            catch (NoSuitablePointsException e) {
                e.printStackTrace();
            }
        }
        return descriptors;
    }
}

