/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.registrationstatistics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.TextAnchor;
import spim.fiji.plugin.Interest_Point_Registration;
import spim.process.interestpointregistration.registrationstatistics.SelectTimepointEntry;

public class MouseListenerTimelapse
implements ChartMouseListener {
    final ChartPanel panel;
    ValueMarker valueMarker;
    boolean markerShown = false;
    int referenceTimePoint;
    final boolean enableReferenceTimePoint;
    final TimePoints timepoints;
    final ArrayList<SelectTimepointEntry> updateList = new ArrayList();

    MouseListenerTimelapse(TimePoints timepoints, ChartPanel panel) {
        this(timepoints, panel, -1, false);
    }

    MouseListenerTimelapse(TimePoints timepoints, ChartPanel panel, boolean enableReferenceTimePoint) {
        this(timepoints, panel, -1, enableReferenceTimePoint);
    }

    MouseListenerTimelapse(TimePoints timepoints, ChartPanel panel, int referenceTimePoint, boolean enableReferenceTimePoint) {
        this.timepoints = timepoints;
        this.panel = panel;
        this.referenceTimePoint = referenceTimePoint;
        this.enableReferenceTimePoint = enableReferenceTimePoint;
        if (enableReferenceTimePoint || referenceTimePoint != -1) {
            if (timepoints != null) {
                MouseListenerTimelapse.setReferenceTimepoint(timepoints, referenceTimePoint);
            }
            this.valueMarker = this.makeMarker(referenceTimePoint);
            if (referenceTimePoint >= 0) {
                ((XYPlot)panel.getChart().getPlot()).addDomainMarker((Marker)this.valueMarker);
                this.markerShown = true;
            }
        }
    }

    public int getReferenceTimePoint() {
        return this.referenceTimePoint;
    }

    protected ValueMarker makeMarker(int timePoint) {
        ValueMarker valueMarker = new ValueMarker((double)timePoint);
        valueMarker.setStroke((Stroke)new BasicStroke(1.5f));
        valueMarker.setPaint((Paint)new Color(0.0f, 0.3647059f, 0.03529412f));
        valueMarker.setLabel(" Reference\n Timepoint " + timePoint);
        valueMarker.setLabelAnchor(RectangleAnchor.BOTTOM);
        valueMarker.setLabelTextAnchor(TextAnchor.BOTTOM_LEFT);
        return valueMarker;
    }

    public void chartMouseClicked(ChartMouseEvent e) {
        if (e.getTrigger().getButton() == 1 && this.enableReferenceTimePoint) {
            int referenceTimePoint = MouseListenerTimelapse.getChartXLocation(e.getTrigger().getPoint(), this.panel);
            if (this.timepoints != null) {
                if (MouseListenerTimelapse.setReferenceTimepoint(this.timepoints, referenceTimePoint)) {
                    this.referenceTimePoint = referenceTimePoint;
                }
            } else {
                this.referenceTimePoint = referenceTimePoint;
            }
            this.valueMarker.setValue((double)this.referenceTimePoint);
            this.valueMarker.setLabel(" Reference\n Timepoint " + this.referenceTimePoint);
            if (!this.markerShown) {
                ((XYPlot)e.getChart().getPlot()).addDomainMarker((Marker)this.valueMarker);
                this.markerShown = true;
            }
        }
    }

    public static boolean setReferenceTimepoint(TimePoints timepoints, int referenceTimePoint) {
        TimePoint ref = (TimePoint)timepoints.getTimePoints().get(referenceTimePoint);
        if (ref != null) {
            List tps = timepoints.getTimePointsOrdered();
            for (int tp = 0; tp < tps.size(); ++tp) {
                if (((TimePoint)tps.get(tp)).getId() != referenceTimePoint) continue;
                Interest_Point_Registration.defaultReferenceTimepointIndex = tp;
                return true;
            }
        }
        return false;
    }

    public static int getChartXLocation(Point point, ChartPanel panel) {
        Point2D p = panel.translateScreenToJava2D(point);
        Rectangle2D plotArea = panel.getScreenDataArea();
        XYPlot plot = (XYPlot)panel.getChart().getPlot();
        double chartX = plot.getDomainAxis().java2DToValue(p.getX(), plotArea, plot.getDomainAxisEdge());
        return (int)Math.round(chartX);
    }

    public void chartMouseMoved(ChartMouseEvent e) {
    }
}

