/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.imagej.ops.Op;
import net.imagej.ops.OpCandidate;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpRef;
import org.scijava.Context;
import org.scijava.command.CommandInfo;
import org.scijava.module.Module;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.service.Service;
import org.scijava.util.GenericUtils;

public final class OpUtils {
    private OpUtils() {
    }

    public static Object[] args(Object[] latter, Object ... former) {
        Object[] result = new Object[former.length + latter.length];
        int i = 0;
        for (Object o : former) {
            result[i++] = o;
        }
        for (Object o : latter) {
            result[i++] = o;
        }
        return result;
    }

    public static List<ModuleItem<?>> inputs(ModuleInfo info) {
        List inputs = OpUtils.asList(info.inputs());
        return OpUtils.filter(inputs, input -> !OpUtils.isInjectable(input.getType()));
    }

    public static List<ModuleItem<?>> outputs(ModuleInfo info) {
        return OpUtils.asList(info.outputs());
    }

    public static String getNamespace(String opName) {
        if (opName == null) {
            return null;
        }
        int dot = opName.lastIndexOf(".");
        return dot < 0 ? null : opName.substring(0, dot);
    }

    public static String stripNamespace(String opName) {
        if (opName == null) {
            return null;
        }
        int dot = opName.lastIndexOf(".");
        return dot < 0 ? opName : opName.substring(dot + 1);
    }

    public static Op unwrap(Module module, OpRef ref) {
        return OpUtils.unwrap(module, ref.getTypes());
    }

    public static Op unwrap(Module module, Collection<? extends Type> types) {
        if (module == null) {
            return null;
        }
        Object delegate = module.getDelegateObject();
        if (types != null) {
            for (Type type : types) {
                Class raw = GenericUtils.getClass((Type)type);
                if (raw.isInstance(delegate)) continue;
                throw new IllegalStateException(delegate.getClass().getName() + " is not of type " + raw.getName());
            }
        }
        if (!(delegate instanceof Op)) {
            throw new IllegalStateException(delegate.getClass().getName() + " is not an Op");
        }
        Op op = (Op)delegate;
        return op;
    }

    public static String opString(String name, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(name + "(\n\t\t");
        boolean first = true;
        for (Object arg : args) {
            if (first) {
                first = false;
            } else {
                sb.append(",\n\t\t");
            }
            if (arg == null) {
                sb.append("null");
                continue;
            }
            if (arg instanceof Class) {
                sb.append(((Class)arg).getSimpleName());
                continue;
            }
            sb.append(arg.getClass().getSimpleName());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String opString(ModuleInfo info) {
        return OpUtils.opString(info, null);
    }

    public static String opString(ModuleInfo info, ModuleItem<?> special) {
        StringBuilder sb = new StringBuilder();
        String outputString = OpUtils.paramString(OpUtils.outputs(info), null).trim();
        if (!outputString.isEmpty()) {
            sb.append("(" + outputString + ") =\n\t");
        }
        sb.append(info.getDelegateClassName());
        sb.append("(" + OpUtils.paramString(OpUtils.inputs(info), special) + ")");
        return sb.toString();
    }

    public static String simpleString(CommandInfo info) {
        StringBuilder sb = new StringBuilder();
        String outputString = OpUtils.paramString(OpUtils.outputs((ModuleInfo)info), null, ", ").trim();
        if (!outputString.isEmpty()) {
            sb.append("" + outputString + "  <=  ");
        }
        Class type = info.getAnnotation().type();
        sb.append(type.getSimpleName());
        sb.append("(" + OpUtils.paramString(OpUtils.inputs((ModuleInfo)info), null, ", ") + ")");
        return sb.toString().replaceAll("\n|\t", "");
    }

    public static String opCall(CommandInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append("ops.run(");
        try {
            String shortName = OpUtils.getOpName(info);
            sb.append("\"");
            sb.append(shortName);
            sb.append("\"");
        }
        catch (Exception e) {
            sb.append(info.getAnnotation().type().getName());
        }
        for (ModuleItem<?> item : OpUtils.inputs((ModuleInfo)info)) {
            sb.append(", ");
            sb.append(item.getType().getSimpleName());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String matchInfo(List<OpCandidate> candidates, List<OpCandidate> matches) {
        StringBuilder sb = new StringBuilder();
        OpRef ref = candidates.get(0).getRef();
        if (matches.isEmpty()) {
            sb.append("No matching '" + ref.getLabel() + "' op\n");
        } else {
            double priority = matches.get(0).cInfo().getPriority();
            sb.append("Multiple '" + ref.getLabel() + "' ops of priority " + priority + ":\n");
            int count = 0;
            for (OpCandidate match : matches) {
                sb.append(++count + ". ");
                sb.append(OpUtils.opString(match.getModule().getInfo()) + "\n");
            }
        }
        sb.append("\n");
        sb.append("Request:\n");
        sb.append("-\t" + OpUtils.opString(ref.getLabel(), ref.getArgs()) + "\n");
        sb.append("\n");
        sb.append("Candidates:\n");
        int count = 0;
        for (OpCandidate candidate : candidates) {
            CommandInfo info = candidate.opInfo().cInfo();
            sb.append(++count + ". ");
            sb.append("\t" + OpUtils.opString((ModuleInfo)info, candidate.getStatusItem()) + "\n");
            String status = candidate.getStatus();
            if (status != null) {
                sb.append("\t" + status + "\n");
            }
            if (candidate.getStatusCode() != OpCandidate.StatusCode.DOES_NOT_CONFORM) continue;
            for (ModuleItem<?> item : OpUtils.inputs((ModuleInfo)info)) {
                Object value = item.getValue(candidate.getModule());
                sb.append("\t\t" + item.getName() + " = " + value + "\n");
            }
        }
        return sb.toString();
    }

    public static String getOpName(CommandInfo info) {
        return new OpInfo(info).getName();
    }

    private static <T> List<T> asList(Iterable<T> iterable) {
        ArrayList list = new ArrayList();
        iterable.forEach(input -> list.add(input));
        return list;
    }

    private static <T> List<T> filter(List<T> list, Predicate<T> p) {
        return list.stream().filter(p).collect(Collectors.toList());
    }

    private static boolean isInjectable(Class<?> type) {
        return Service.class.isAssignableFrom(type) || Context.class.isAssignableFrom(type);
    }

    private static String paramString(Iterable<ModuleItem<?>> items, ModuleItem<?> special) {
        return OpUtils.paramString(items, special, ",");
    }

    private static String paramString(Iterable<ModuleItem<?>> items, ModuleItem<?> special, String delim) {
        return OpUtils.paramString(items, special, delim, false);
    }

    private static String paramString(Iterable<ModuleItem<?>> items, ModuleItem<?> special, String delim, boolean typeOnly) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ModuleItem<?> item : items) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append("\n");
            if (item == special) {
                sb.append("==>");
            }
            sb.append("\t\t");
            sb.append(item.getType().getSimpleName());
            if (typeOnly) continue;
            sb.append(" " + item.getName());
            if (item.isRequired()) continue;
            sb.append("?");
        }
        return sb.toString();
    }
}

