/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter;

import net.imagej.ops.Ops;
import net.imagej.ops.filter.AbstractFFTFilterC;
import net.imagej.ops.filter.fft.FFTMethodsOpC;
import net.imagej.ops.filter.ifft.IFFTMethodsOpC;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.LinearFilter.class, priority=-100.0)
public class FFTMethodsLinearFFTFilterC<I extends RealType<I>, O extends RealType<O>, K extends RealType<K>, C extends ComplexType<C>>
extends AbstractFFTFilterC<I, O, K, C>
implements Ops.Filter.LinearFilter {
    @Parameter
    private BinaryComputerOp<RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>> frequencyOp;
    private UnaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<C>> fftInOp;
    private UnaryComputerOp<RandomAccessibleInterval<K>, RandomAccessibleInterval<C>> fftKernelOp;
    private UnaryComputerOp<RandomAccessibleInterval<C>, RandomAccessibleInterval<O>> ifftOp;

    @Override
    public void initialize() {
        super.initialize();
        this.fftInOp = Computers.unary(this.ops(), FFTMethodsOpC.class, this.getFFTInput(), RandomAccessibleInterval.class, new Object[0]);
        this.fftKernelOp = Computers.unary(this.ops(), FFTMethodsOpC.class, this.getFFTKernel(), RandomAccessibleInterval.class, new Object[0]);
        this.ifftOp = Computers.unary(this.ops(), IFFTMethodsOpC.class, RandomAccessibleInterval.class, this.getFFTKernel(), new Object[0]);
    }

    @Override
    public void compute(RandomAccessibleInterval<I> in, RandomAccessibleInterval<K> kernel, RandomAccessibleInterval<O> out) {
        if (this.getFFTInput() == null) {
            this.setFFTInput(this.getCreateOp().calculate((Dimensions)in));
        }
        if (this.getFFTKernel() == null) {
            this.setFFTKernel(this.getCreateOp().calculate((Dimensions)in));
        }
        if (this.getPerformInputFFT()) {
            this.fftInOp.compute(in, this.getFFTInput());
        }
        if (this.getPerformKernelFFT()) {
            this.fftKernelOp.compute(kernel, this.getFFTKernel());
        }
        this.frequencyOp.compute(this.getFFTInput(), this.getFFTKernel(), this.getFFTInput());
        this.ifftOp.compute(this.getFFTInput(), out);
    }
}

