/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.findEdges;

import net.imagej.Extents;
import net.imagej.Position;
import net.imagej.ops.Contingent;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.FindEdges.class)
public class DefaultFindEdges<T extends RealType<T>>
extends AbstractUnaryFunctionOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>
implements Ops.Filter.FindEdges,
Contingent {
    @Parameter
    private OpService ops;

    @Override
    public RandomAccessibleInterval<T> calculate(RandomAccessibleInterval<T> input) {
        RandomAccessibleInterval<T> output = this.ops().copy().rai(input);
        long[] planeDims = new long[input.numDimensions() - 2];
        for (int i = 0; i < planeDims.length; ++i) {
            planeDims[i] = input.dimension(i + 2);
        }
        Extents extents = new Extents(planeDims);
        Position planePos = extents.createPosition();
        if (planeDims.length == 0) {
            this.computePlanar(planePos, input, output);
        } else {
            while (planePos.hasNext()) {
                planePos.fwd();
                this.computePlanar(planePos, input, output);
            }
        }
        return output;
    }

    private void computePlanar(Position planePos, RandomAccessibleInterval<T> input, RandomAccessibleInterval<T> output) {
        RealType type = (RealType)Util.getTypeFromInterval(input);
        long[] imageDims = new long[input.numDimensions()];
        input.dimensions(imageDims);
        IntervalView slicedInput = this.ops.copy().rai(input);
        for (int i = planePos.numDimensions() - 1; i >= 0; --i) {
            slicedInput = Views.hyperSlice(slicedInput, (int)(input.numDimensions() - 1 - i), (long)planePos.getLongPosition(i));
        }
        ExtendedRandomAccessibleInterval refactoredInput = Views.extendMirrorSingle(slicedInput);
        RectangleNeighborhoodFactory factory = RectangleNeighborhood.factory();
        FinalInterval neighborhoodSpan = new FinalInterval(new long[]{-1L, -1L}, new long[]{1L, 1L});
        RectangleShape.NeighborhoodsAccessible neighborhoods = new RectangleShape.NeighborhoodsAccessible((RandomAccessible)refactoredInput, (Interval)neighborhoodSpan, factory);
        Cursor cursor = Views.iterable(input).localizingCursor();
        RandomAccess outputRA = output.randomAccess();
        for (int i = 0; i < planePos.numDimensions(); ++i) {
            outputRA.setPosition(planePos.getLongPosition(i), i + 2);
        }
        RandomAccess neighborhoodsRA = neighborhoods.randomAccess();
        int algorithmIndex = 0;
        double[] n = new double[9];
        while (cursor.hasNext()) {
            cursor.fwd();
            neighborhoodsRA.setPosition((Localizable)cursor);
            Neighborhood current = (Neighborhood)neighborhoodsRA.get();
            Cursor neighborhoodCursor = current.cursor();
            algorithmIndex = 0;
            while (algorithmIndex < n.length) {
                neighborhoodCursor.fwd();
                n[algorithmIndex++] = ((RealType)neighborhoodCursor.get()).getRealDouble();
            }
            double sum1 = n[0] + 2.0 * n[1] + n[2] - n[6] - 2.0 * n[7] - n[8];
            double sum2 = n[0] + 2.0 * n[3] + n[6] - n[2] - 2.0 * n[5] - n[8];
            double value = Math.sqrt(sum1 * sum1 + sum2 * sum2);
            outputRA.setPosition(cursor.getLongPosition(0), 0);
            outputRA.setPosition(cursor.getLongPosition(1), 1);
            if (value > type.getMaxValue()) {
                value = type.getMaxValue();
            }
            if (value < type.getMinValue()) {
                value = type.getMinValue();
            }
            ((RealType)outputRA.get()).setReal(value);
        }
    }

    @Override
    public boolean conforms() {
        return ((RandomAccessibleInterval)this.in()).numDimensions() > 1;
    }
}

