/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.inplace.AbstractUnaryInplaceOp;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public final class ConstantToPlanarImage {
    private ConstantToPlanarImage() {
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class DivideUnsignedShort
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedShortType, ShortArray>>
    implements Ops.Math.Divide,
    Contingent {
        @Parameter
        private short value;

        @Override
        public void mutate(PlanarImg<UnsignedShortType, ShortArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                short[] plane = ((ShortArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (short)(plane[n] / this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedShortType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class MultiplyUnsignedShort
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedShortType, ShortArray>>
    implements Ops.Math.Multiply,
    Contingent {
        @Parameter
        private short value;

        @Override
        public void mutate(PlanarImg<UnsignedShortType, ShortArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                short[] plane = ((ShortArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (short)(plane[n] * this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedShortType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class SubtractUnsignedShort
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedShortType, ShortArray>>
    implements Ops.Math.Subtract,
    Contingent {
        @Parameter
        private short value;

        @Override
        public void mutate(PlanarImg<UnsignedShortType, ShortArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                short[] plane = ((ShortArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (short)(plane[n] - this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedShortType;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class AddUnsignedShort
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedShortType, ShortArray>>
    implements Ops.Math.Add,
    Contingent {
        @Parameter
        private short value;

        @Override
        public void mutate(PlanarImg<UnsignedShortType, ShortArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                short[] plane = ((ShortArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (short)(plane[n] + this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedShortType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class DivideUnsignedLong
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedLongType, LongArray>>
    implements Ops.Math.Divide,
    Contingent {
        @Parameter
        private long value;

        @Override
        public void mutate(PlanarImg<UnsignedLongType, LongArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                long[] plane = ((LongArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] / this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedLongType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class MultiplyUnsignedLong
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedLongType, LongArray>>
    implements Ops.Math.Multiply,
    Contingent {
        @Parameter
        private long value;

        @Override
        public void mutate(PlanarImg<UnsignedLongType, LongArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                long[] plane = ((LongArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] * this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedLongType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class SubtractUnsignedLong
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedLongType, LongArray>>
    implements Ops.Math.Subtract,
    Contingent {
        @Parameter
        private long value;

        @Override
        public void mutate(PlanarImg<UnsignedLongType, LongArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                long[] plane = ((LongArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] - this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedLongType;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class AddUnsignedLong
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedLongType, LongArray>>
    implements Ops.Math.Add,
    Contingent {
        @Parameter
        private long value;

        @Override
        public void mutate(PlanarImg<UnsignedLongType, LongArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                long[] plane = ((LongArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] + this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedLongType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class DivideUnsignedInt
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedIntType, IntArray>>
    implements Ops.Math.Divide,
    Contingent {
        @Parameter
        private int value;

        @Override
        public void mutate(PlanarImg<UnsignedIntType, IntArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                int[] plane = ((IntArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] / this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedIntType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class MultiplyUnsignedInt
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedIntType, IntArray>>
    implements Ops.Math.Multiply,
    Contingent {
        @Parameter
        private int value;

        @Override
        public void mutate(PlanarImg<UnsignedIntType, IntArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                int[] plane = ((IntArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] * this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedIntType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class SubtractUnsignedInt
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedIntType, IntArray>>
    implements Ops.Math.Subtract,
    Contingent {
        @Parameter
        private int value;

        @Override
        public void mutate(PlanarImg<UnsignedIntType, IntArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                int[] plane = ((IntArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] - this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedIntType;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class AddUnsignedInt
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedIntType, IntArray>>
    implements Ops.Math.Add,
    Contingent {
        @Parameter
        private int value;

        @Override
        public void mutate(PlanarImg<UnsignedIntType, IntArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                int[] plane = ((IntArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] + this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedIntType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class DivideUnsignedByte
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedByteType, ByteArray>>
    implements Ops.Math.Divide,
    Contingent {
        @Parameter
        private byte value;

        @Override
        public void mutate(PlanarImg<UnsignedByteType, ByteArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                byte[] plane = ((ByteArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (byte)(plane[n] / this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedByteType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class MultiplyUnsignedByte
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedByteType, ByteArray>>
    implements Ops.Math.Multiply,
    Contingent {
        @Parameter
        private byte value;

        @Override
        public void mutate(PlanarImg<UnsignedByteType, ByteArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                byte[] plane = ((ByteArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (byte)(plane[n] * this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedByteType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class SubtractUnsignedByte
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedByteType, ByteArray>>
    implements Ops.Math.Subtract,
    Contingent {
        @Parameter
        private byte value;

        @Override
        public void mutate(PlanarImg<UnsignedByteType, ByteArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                byte[] plane = ((ByteArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (byte)(plane[n] - this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedByteType;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class AddUnsignedByte
    extends AbstractUnaryInplaceOp<PlanarImg<UnsignedByteType, ByteArray>>
    implements Ops.Math.Add,
    Contingent {
        @Parameter
        private byte value;

        @Override
        public void mutate(PlanarImg<UnsignedByteType, ByteArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                byte[] plane = ((ByteArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (byte)(plane[n] + this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof UnsignedByteType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class DivideDouble
    extends AbstractUnaryInplaceOp<PlanarImg<DoubleType, DoubleArray>>
    implements Ops.Math.Divide,
    Contingent {
        @Parameter
        private double value;

        @Override
        public void mutate(PlanarImg<DoubleType, DoubleArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                double[] plane = ((DoubleArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] / this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof DoubleType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class MultiplyDouble
    extends AbstractUnaryInplaceOp<PlanarImg<DoubleType, DoubleArray>>
    implements Ops.Math.Multiply,
    Contingent {
        @Parameter
        private double value;

        @Override
        public void mutate(PlanarImg<DoubleType, DoubleArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                double[] plane = ((DoubleArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] * this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof DoubleType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class SubtractDouble
    extends AbstractUnaryInplaceOp<PlanarImg<DoubleType, DoubleArray>>
    implements Ops.Math.Subtract,
    Contingent {
        @Parameter
        private double value;

        @Override
        public void mutate(PlanarImg<DoubleType, DoubleArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                double[] plane = ((DoubleArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] - this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof DoubleType;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class AddDouble
    extends AbstractUnaryInplaceOp<PlanarImg<DoubleType, DoubleArray>>
    implements Ops.Math.Add,
    Contingent {
        @Parameter
        private double value;

        @Override
        public void mutate(PlanarImg<DoubleType, DoubleArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                double[] plane = ((DoubleArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] + this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof DoubleType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class DivideFloat
    extends AbstractUnaryInplaceOp<PlanarImg<FloatType, FloatArray>>
    implements Ops.Math.Divide,
    Contingent {
        @Parameter
        private float value;

        @Override
        public void mutate(PlanarImg<FloatType, FloatArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                float[] plane = ((FloatArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] / this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof FloatType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class MultiplyFloat
    extends AbstractUnaryInplaceOp<PlanarImg<FloatType, FloatArray>>
    implements Ops.Math.Multiply,
    Contingent {
        @Parameter
        private float value;

        @Override
        public void mutate(PlanarImg<FloatType, FloatArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                float[] plane = ((FloatArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] * this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof FloatType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class SubtractFloat
    extends AbstractUnaryInplaceOp<PlanarImg<FloatType, FloatArray>>
    implements Ops.Math.Subtract,
    Contingent {
        @Parameter
        private float value;

        @Override
        public void mutate(PlanarImg<FloatType, FloatArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                float[] plane = ((FloatArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] - this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof FloatType;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class AddFloat
    extends AbstractUnaryInplaceOp<PlanarImg<FloatType, FloatArray>>
    implements Ops.Math.Add,
    Contingent {
        @Parameter
        private float value;

        @Override
        public void mutate(PlanarImg<FloatType, FloatArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                float[] plane = ((FloatArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] + this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof FloatType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class DivideShort
    extends AbstractUnaryInplaceOp<PlanarImg<ShortType, ShortArray>>
    implements Ops.Math.Divide,
    Contingent {
        @Parameter
        private short value;

        @Override
        public void mutate(PlanarImg<ShortType, ShortArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                short[] plane = ((ShortArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (short)(plane[n] / this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof ShortType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class MultiplyShort
    extends AbstractUnaryInplaceOp<PlanarImg<ShortType, ShortArray>>
    implements Ops.Math.Multiply,
    Contingent {
        @Parameter
        private short value;

        @Override
        public void mutate(PlanarImg<ShortType, ShortArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                short[] plane = ((ShortArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (short)(plane[n] * this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof ShortType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class SubtractShort
    extends AbstractUnaryInplaceOp<PlanarImg<ShortType, ShortArray>>
    implements Ops.Math.Subtract,
    Contingent {
        @Parameter
        private short value;

        @Override
        public void mutate(PlanarImg<ShortType, ShortArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                short[] plane = ((ShortArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (short)(plane[n] - this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof ShortType;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class AddShort
    extends AbstractUnaryInplaceOp<PlanarImg<ShortType, ShortArray>>
    implements Ops.Math.Add,
    Contingent {
        @Parameter
        private short value;

        @Override
        public void mutate(PlanarImg<ShortType, ShortArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                short[] plane = ((ShortArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (short)(plane[n] + this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof ShortType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class DivideLong
    extends AbstractUnaryInplaceOp<PlanarImg<LongType, LongArray>>
    implements Ops.Math.Divide,
    Contingent {
        @Parameter
        private long value;

        @Override
        public void mutate(PlanarImg<LongType, LongArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                long[] plane = ((LongArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] / this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof LongType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class MultiplyLong
    extends AbstractUnaryInplaceOp<PlanarImg<LongType, LongArray>>
    implements Ops.Math.Multiply,
    Contingent {
        @Parameter
        private long value;

        @Override
        public void mutate(PlanarImg<LongType, LongArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                long[] plane = ((LongArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] * this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof LongType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class SubtractLong
    extends AbstractUnaryInplaceOp<PlanarImg<LongType, LongArray>>
    implements Ops.Math.Subtract,
    Contingent {
        @Parameter
        private long value;

        @Override
        public void mutate(PlanarImg<LongType, LongArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                long[] plane = ((LongArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] - this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof LongType;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class AddLong
    extends AbstractUnaryInplaceOp<PlanarImg<LongType, LongArray>>
    implements Ops.Math.Add,
    Contingent {
        @Parameter
        private long value;

        @Override
        public void mutate(PlanarImg<LongType, LongArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                long[] plane = ((LongArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] + this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof LongType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class DivideInt
    extends AbstractUnaryInplaceOp<PlanarImg<IntType, IntArray>>
    implements Ops.Math.Divide,
    Contingent {
        @Parameter
        private int value;

        @Override
        public void mutate(PlanarImg<IntType, IntArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                int[] plane = ((IntArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] / this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof IntType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class MultiplyInt
    extends AbstractUnaryInplaceOp<PlanarImg<IntType, IntArray>>
    implements Ops.Math.Multiply,
    Contingent {
        @Parameter
        private int value;

        @Override
        public void mutate(PlanarImg<IntType, IntArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                int[] plane = ((IntArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] * this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof IntType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class SubtractInt
    extends AbstractUnaryInplaceOp<PlanarImg<IntType, IntArray>>
    implements Ops.Math.Subtract,
    Contingent {
        @Parameter
        private int value;

        @Override
        public void mutate(PlanarImg<IntType, IntArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                int[] plane = ((IntArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] - this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof IntType;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class AddInt
    extends AbstractUnaryInplaceOp<PlanarImg<IntType, IntArray>>
    implements Ops.Math.Add,
    Contingent {
        @Parameter
        private int value;

        @Override
        public void mutate(PlanarImg<IntType, IntArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                int[] plane = ((IntArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = plane[n] + this.value;
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof IntType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class DivideByte
    extends AbstractUnaryInplaceOp<PlanarImg<ByteType, ByteArray>>
    implements Ops.Math.Divide,
    Contingent {
        @Parameter
        private byte value;

        @Override
        public void mutate(PlanarImg<ByteType, ByteArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                byte[] plane = ((ByteArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (byte)(plane[n] / this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof ByteType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class MultiplyByte
    extends AbstractUnaryInplaceOp<PlanarImg<ByteType, ByteArray>>
    implements Ops.Math.Multiply,
    Contingent {
        @Parameter
        private byte value;

        @Override
        public void mutate(PlanarImg<ByteType, ByteArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                byte[] plane = ((ByteArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (byte)(plane[n] * this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof ByteType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class SubtractByte
    extends AbstractUnaryInplaceOp<PlanarImg<ByteType, ByteArray>>
    implements Ops.Math.Subtract,
    Contingent {
        @Parameter
        private byte value;

        @Override
        public void mutate(PlanarImg<ByteType, ByteArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                byte[] plane = ((ByteArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (byte)(plane[n] - this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof ByteType;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class AddByte
    extends AbstractUnaryInplaceOp<PlanarImg<ByteType, ByteArray>>
    implements Ops.Math.Add,
    Contingent {
        @Parameter
        private byte value;

        @Override
        public void mutate(PlanarImg<ByteType, ByteArray> arg) {
            long planeCount = 1L;
            for (int d = 2; d < arg.numDimensions(); ++d) {
                planeCount *= arg.dimension(d);
            }
            int p = 0;
            while ((long)p < planeCount) {
                byte[] plane = ((ByteArray)arg.getPlane(p)).getCurrentStorageArray();
                int i = 0;
                while (i < plane.length) {
                    int n = i++;
                    plane[n] = (byte)(plane[n] + this.value);
                }
                ++p;
            }
        }

        @Override
        public boolean conforms() {
            return ((PlanarImg)this.in()).firstElement() instanceof ByteType;
        }
    }
}

