/*
 * Decompiled with CFR 0.152.
 */
import delaunay.DelaunayTriangulation;
import delaunay.Pnt;
import delaunay.Simplex;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.StackWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.TreeMap;

public class Delaunay_Voronoi
implements PlugIn {
    public final int DELAUNAY = 1;
    public final int VORONOI = 2;
    int mode = 1;
    boolean showMeanDistance = false;
    final boolean drawZoom = IJ.getVersion().compareTo("1.37n") >= 0;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (imp == null) {
            return;
        }
        GenericDialog gd = new GenericDialog("Delaunay/Voronoi parameters");
        gd.addChoice("mode", new String[]{"Delaunay", "Voronoi"}, "Delaunay");
        gd.addCheckbox("interactive", !Interpreter.isBatchMode());
        gd.addCheckbox("make Delaunay ROI", false);
        gd.addCheckbox("showMeanDistance", false);
        ResultsTable results = Analyzer.getResultsTable();
        gd.addCheckbox("inferSelectionFromParticles", imp.getRoi() == null && results != null && results.getColumnIndex("XM") != -1);
        gd.addCheckbox("export into Results", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.mode = gd.getNextChoiceIndex() + 1;
        boolean interactive = gd.getNextBoolean();
        boolean makeROI = gd.getNextBoolean();
        this.showMeanDistance = gd.getNextBoolean();
        boolean fromParticles = gd.getNextBoolean();
        boolean exportResults = gd.getNextBoolean();
        if (fromParticles) {
            Calibration calib = imp.getCalibration();
            int xCol = results.getColumnIndex("XM");
            int yCol = results.getColumnIndex("YM");
            if (xCol < 0 || yCol < 0) {
                IJ.error((String)"You did not select Center of Mass in Analyze>Set Measurements...\nSelect it and try again.");
                return;
            }
            float[] x = results.getColumn(xCol);
            if (x == null || x.length == 0) {
                IJ.error((String)"No results found!");
                return;
            }
            float[] y = results.getColumn(yCol);
            int[] xInt = new int[x.length];
            int[] yInt = new int[x.length];
            for (int i = 0; i < x.length; ++i) {
                xInt[i] = (int)Math.round((double)x[i] / calib.pixelWidth - calib.xOrigin);
                yInt[i] = (int)Math.round((double)y[i] / calib.pixelHeight - calib.yOrigin);
            }
            imp.setRoi((Roi)new PointRoi(xInt, yInt, x.length));
        }
        CustomCanvas cc = new CustomCanvas(imp);
        if (exportResults) {
            if (results == null) {
                results = new ResultsTable();
                Analyzer.setResultsTable((ResultsTable)results);
            }
            this.exportResults(cc.delaunay, cc.inf, results);
        }
        if (makeROI) {
            imp.setRoi(this.getRoi(cc.delaunay, cc.inf));
            imp.updateAndDraw();
            return;
        }
        if (!interactive) {
            cc.drawOverlay(null);
            imp.updateAndDraw();
            return;
        }
        if (imp.getStackSize() > 1) {
            new StackWindow(imp, (ImageCanvas)cc).addKeyListener((KeyListener)cc);
        } else {
            new ImageWindow(imp, (ImageCanvas)cc).addKeyListener((KeyListener)cc);
        }
        Roi roi = imp.getRoi();
        if (roi != null) {
            roi.setImage(imp);
        }
    }

    void exportResults(DelaunayTriangulation delaunay, double inf, ResultsTable results) {
        if (delaunay == null) {
            return;
        }
        if (this.mode != 1) {
            IJ.error((String)"Operation only supported for Delaunay");
            return;
        }
        if (results.getLastColumn() >= 0) {
            if (!IJ.showMessageWithCancel((String)"Clear Results?", (String)"May I clear the results table?")) {
                return;
            }
            results.reset();
        }
        TreeMap shown = new TreeMap();
        for (Simplex triangle : delaunay) {
            if (this.mode == 1) {
                Iterator iter2 = triangle.iterator();
                Pnt a = (Pnt)iter2.next();
                Pnt b = (Pnt)iter2.next();
                Pnt c = (Pnt)iter2.next();
                if (Math.abs(a.coord(0)) >= inf || Math.abs(b.coord(0)) >= inf || Math.abs(c.coord(0)) >= inf) continue;
                this.addOneResult(shown, a, b, results);
                this.addOneResult(shown, a, c, results);
                this.addOneResult(shown, b, c, results);
                continue;
            }
            IJ.error((String)"TODO");
            return;
        }
        results.show("Results");
    }

    private void addOneResult(TreeMap shown, Pnt a, Pnt b, ResultsTable results) {
        PntPair pair = new PntPair(a, b);
        if (shown.containsKey(pair)) {
            return;
        }
        results.incrementCounter();
        results.addValue("x1", pair.a.coord(0));
        results.addValue("y1", pair.a.coord(1));
        results.addValue("x2", pair.b.coord(0));
        results.addValue("y2", pair.b.coord(1));
        shown.put(pair, null);
    }

    Roi getRoi(DelaunayTriangulation delaunay, double inf) {
        if (delaunay == null) {
            return null;
        }
        if (this.mode != 1) {
            IJ.error((String)"Operation only supported for Delaunay");
            return null;
        }
        int i = 0;
        GeneralPath path = new GeneralPath(0);
        Polygon poly = null;
        for (Simplex triangle : delaunay) {
            if (this.mode == 1) {
                Iterator iter2 = triangle.iterator();
                Pnt a = (Pnt)iter2.next();
                Pnt b = (Pnt)iter2.next();
                Pnt c = (Pnt)iter2.next();
                if (Math.abs(a.coord(0)) >= inf || Math.abs(b.coord(0)) >= inf || Math.abs(c.coord(0)) >= inf) continue;
                int[] x = new int[3];
                int[] y = new int[3];
                x[0] = (int)Math.round(a.coord(0));
                y[0] = (int)Math.round(a.coord(1));
                x[1] = (int)Math.round(b.coord(0));
                y[1] = (int)Math.round(b.coord(1));
                x[2] = (int)Math.round(c.coord(0));
                y[2] = (int)Math.round(c.coord(1));
                poly = new Polygon(x, y, 3);
                path.append(poly, false);
                ++i;
                continue;
            }
            return null;
        }
        if (i == 0) {
            return null;
        }
        if (i == 1) {
            return new PolygonRoi(poly, 2);
        }
        return new ShapeRoi((Shape)path);
    }

    class CustomCanvas
    extends ImageCanvas
    implements KeyListener {
        DelaunayTriangulation delaunay;
        final double inf;
        double pixelWidth;
        double pixelHeight;
        double mean;
        double variance;
        int total;

        CustomCanvas(ImagePlus imp) {
            super(imp);
            this.inf = imp.getWidth() + imp.getHeight();
            this.initDelaunay();
            this.addKeyListener(this);
        }

        public void paint(Graphics g) {
            super.paint(g);
            this.drawOverlay(g);
        }

        void drawOverlay(Graphics g) {
            if (this.delaunay == null) {
                return;
            }
            for (Simplex triangle : this.delaunay) {
                Iterator iter2;
                if (Delaunay_Voronoi.this.mode == 1) {
                    iter2 = triangle.iterator();
                    Pnt a = (Pnt)iter2.next();
                    Pnt b = (Pnt)iter2.next();
                    Pnt c = (Pnt)iter2.next();
                    this.draw(g, a, b);
                    this.draw(g, a, c);
                    this.draw(g, b, c);
                    continue;
                }
                iter2 = this.delaunay.neighbors(triangle).iterator();
                while (iter2.hasNext()) {
                    this.draw(g, triangle, (Simplex)iter2.next());
                }
            }
        }

        void draw(Graphics g, Pnt a, Pnt b) {
            if (Delaunay_Voronoi.this.mode != 2 && (Math.abs(a.coord(0)) >= this.inf || Math.abs(b.coord(0)) >= this.inf)) {
                return;
            }
            if (g == null) {
                ImageProcessor ip = this.imp.getProcessor();
                ip.drawLine((int)a.coord(0), (int)a.coord(1), (int)b.coord(0), (int)b.coord(1));
                return;
            }
            double m = this.magnification;
            double x0 = (a.coord(0) - (double)this.srcRect.x) * m;
            double y0 = (a.coord(1) - (double)this.srcRect.y) * m;
            double x1 = (b.coord(0) - (double)this.srcRect.x) * m;
            double y1 = (b.coord(1) - (double)this.srcRect.y) * m;
            this.imp.getRoi();
            g.setColor(Roi.getColor());
            g.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
            if (Delaunay_Voronoi.this.drawZoom && this.srcRect.width != this.imageWidth && g != null) {
                int xOffset = 10;
                int yOffset = 10;
                int w = 64;
                int h = 64;
                if (this.imageHeight > this.imageWidth) {
                    m = 64.0 / (double)this.imageHeight;
                    w = (int)((double)this.imageWidth * m);
                } else {
                    m = 64.0 / (double)this.imageWidth;
                    h = (int)((double)this.imageHeight * m);
                }
                x0 = a.coord(0) * m + (double)xOffset;
                y0 = a.coord(1) * m + (double)yOffset;
                x1 = b.coord(0) * m + (double)xOffset;
                y1 = b.coord(1) * m + (double)yOffset;
                Shape clip = g.getClip();
                g.setColor(new Color(128, 128, 255));
                g.clipRect(xOffset, yOffset, w, h);
                g.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
                g.setClip(clip);
            }
        }

        void draw(Graphics g, Simplex a, Simplex b) {
            this.draw(g, Pnt.circumcenter((Pnt[])((Pnt[])a.toArray((Object[])new Pnt[0]))), Pnt.circumcenter((Pnt[])((Pnt[])b.toArray((Object[])new Pnt[0]))));
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.initDelaunay();
            this.repaint();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 32) {
                Delaunay_Voronoi.this.mode = Delaunay_Voronoi.this.mode == 1 ? 2 : 1;
                this.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        public void initDelaunay() {
            this.delaunay = null;
            Roi roi = this.imp.getRoi();
            if (roi == null || !(roi instanceof PointRoi)) {
                return;
            }
            PointRoi r = (PointRoi)roi;
            Rectangle rect = r.getBounds();
            int n = r.getNCoordinates();
            int[] x = r.getXCoordinates();
            int[] y = r.getYCoordinates();
            Simplex initial = new Simplex((Object[])new Pnt[]{new Pnt(-this.inf, -this.inf), new Pnt(-this.inf, 5.0 * this.inf), new Pnt(5.0 * this.inf, -this.inf)});
            this.delaunay = new DelaunayTriangulation(initial);
            for (int i = 0; i < n; ++i) {
                this.delaunay.delaunayPlace(new Pnt((double)(x[i] + rect.x), (double)(y[i] + rect.y)));
            }
            if (Delaunay_Voronoi.this.showMeanDistance && Delaunay_Voronoi.this.mode == 1) {
                this.showMeanAndVariance();
            }
        }

        private void addToMean(Pnt a, Pnt b) {
            if (Math.abs(a.coord(0)) >= this.inf || Math.abs(b.coord(0)) >= this.inf) {
                return;
            }
            double x = (b.coord(0) - a.coord(0)) * this.pixelWidth;
            double y = (b.coord(1) - a.coord(1)) * this.pixelHeight;
            double d2 = x * x + y * y;
            this.mean += Math.sqrt(d2);
            this.variance += d2;
            ++this.total;
        }

        public void showMeanAndVariance() {
            Calibration calib = this.imp.getCalibration();
            this.pixelWidth = calib.pixelWidth;
            this.pixelHeight = calib.pixelHeight;
            this.total = 0;
            this.mean = this.variance = (double)0;
            for (Simplex triangle : this.delaunay) {
                Iterator iter2 = triangle.iterator();
                Pnt a = (Pnt)iter2.next();
                Pnt b = (Pnt)iter2.next();
                Pnt c = (Pnt)iter2.next();
                this.addToMean(a, b);
                this.addToMean(b, c);
                this.addToMean(c, a);
            }
            if (this.total > 0) {
                this.mean /= (double)this.total;
                this.variance /= (double)this.total;
                this.variance -= this.mean * this.mean;
                ResultsTable rt = Analyzer.getResultsTable();
                if (rt == null) {
                    rt = new ResultsTable();
                    Analyzer.setResultsTable((ResultsTable)rt);
                }
                rt.incrementCounter();
                rt.addValue("Mean Distance", this.mean);
                rt.addValue("Variance", this.variance);
                rt.show("Results");
            }
        }
    }

    private static class PntPair
    implements Comparable {
        Pnt a;
        Pnt b;

        PntPair(Pnt a, Pnt b) {
            if (PntPair.compare(a, b) > 0) {
                this.a = b;
                this.b = a;
            } else {
                this.a = a;
                this.b = b;
            }
        }

        public int compareTo(Object other) {
            PntPair o = (PntPair)other;
            int result = PntPair.compare(this.a, o.a);
            if (result == 0) {
                result = PntPair.compare(this.b, o.b);
            }
            return result;
        }

        public static int compare(Pnt a, Pnt b) {
            double result = a.coord(0) - b.coord(0);
            if (result == 0.0) {
                result = a.coord(1) - b.coord(1);
            }
            return result < 0.0 ? -1 : (result > 0.0 ? 1 : 0);
        }
    }
}

