/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class Seam_Remover
implements PlugInFilter {
    protected ImagePlus image;
    protected int w;
    protected int h;
    protected int[] pixels;
    protected ImageEnergy energy;

    public void run(ImageProcessor ip) {
        int[] seam;
        String[] labels = new String[]{"Remove one Horizontal Seam", "Remove one Vertical Seam", "Mark one Horizontal Seam", "Mark one Vertical Seam", "Resize by removing Seams"};
        GenericDialog gd = new GenericDialog("Seam Remover");
        gd.addChoice("mode", labels, labels[4]);
        gd.addNumericField("width", (double)this.image.getWidth(), 0);
        gd.addNumericField("height", (double)this.image.getHeight(), 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int mode = gd.getNextChoiceIndex();
        int width = (int)gd.getNextNumber();
        int height = (int)gd.getNextNumber();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.pixels = (int[])this.image.getProcessor().getPixels();
        this.energy = new ColorDerivativeEnergy(this.w, this.h, this.pixels);
        if (mode == 4) {
            ImageProcessor n = this.resize(this.energy, width, height);
            new ImagePlus("resized " + this.image.getTitle(), n).show();
            return;
        }
        boolean visualize = mode == 2 || mode == 3;
        boolean vertical = mode == 1 || mode == 3;
        int[] nArray = seam = vertical ? this.energy.getVerticalSeam() : this.energy.getHorizontalSeam();
        if (visualize) {
            this.image.setRoi(this.energy.seam2roi(seam, vertical));
            this.image.updateAndDraw();
        } else {
            ImageProcessor n = this.energy.removeSeam(seam, vertical).getProcessor();
            new ImagePlus("removed seam", n).show();
        }
    }

    public int setup(String args, ImagePlus imp) {
        this.image = imp;
        return 16;
    }

    public ImageProcessor resize(ImageEnergy energy, int w, int h) {
        if (w > energy.w || h > energy.h) {
            throw new RuntimeException("Cannot enlarge image");
        }
        int total = energy.w - w + energy.h - h;
        int count = 0;
        while (w < energy.w || h < energy.h) {
            int[] seam;
            if (energy.w - w < energy.h - h) {
                seam = energy.getHorizontalSeam();
                energy = energy.removeSeam(seam, false);
            } else {
                seam = energy.getVerticalSeam();
                energy = energy.removeSeam(seam, true);
            }
            IJ.showProgress((int)(++count), (int)total);
        }
        return energy.getProcessor();
    }

    private class ColorDerivativeEnergy
    extends ImageEnergy {
        int[] pixels;

        public ColorDerivativeEnergy(int w, int h, int[] pixels) {
            super(w, h);
            this.pixels = pixels;
        }

        int getDiff(int x1, int y1, int x2, int y2) {
            int v1 = this.pixels[x1 + y1 * this.w];
            int v2 = this.pixels[x2 + y2 * this.w];
            int r = (v1 >> 16 & 0xFF) - (v2 >> 16 & 0xFF);
            int g = (v1 >> 8 & 0xFF) - (v2 >> 8 & 0xFF);
            int b = (v1 & 0xFF) - (v2 & 0xFF);
            return r + g + b;
        }

        @Override
        public float get(int x, int y) {
            return (x == 0 ? 2 * this.getDiff(x, y, x + 1, y) : (x == this.w - 1 ? 2 * this.getDiff(x - 1, y, x, y) : this.getDiff(x - 1, y, x + 1, y))) + (y == 0 ? 2 * this.getDiff(x, y, x, y + 1) : (y == this.h - 1 ? 2 * this.getDiff(x, y - 1, x, y) : this.getDiff(x, y - 1, x, y + 1)));
        }

        @Override
        public ImageEnergy removeSeam(int[] seam, boolean vert) {
            if (vert) {
                int[] p = new int[(this.w - 1) * this.h];
                for (int y = 0; y < this.h; ++y) {
                    int x;
                    for (x = 0; x < seam[y]; ++x) {
                        p[x + y * (this.w - 1)] = this.pixels[x + y * this.w];
                    }
                    for (x = seam[y] + 1; x < this.w; ++x) {
                        p[x - 1 + y * (this.w - 1)] = this.pixels[x + y * this.w];
                    }
                }
                return new ColorDerivativeEnergy(this.w - 1, this.h, p);
            }
            int[] p = new int[this.w * (this.h - 1)];
            for (int x = 0; x < this.w; ++x) {
                int y;
                for (y = 0; y < seam[x]; ++y) {
                    p[x + y * this.w] = this.pixels[x + y * this.w];
                }
                for (y = seam[x] + 1; y < this.h; ++y) {
                    p[x + (y - 1) * this.w] = this.pixels[x + y * this.w];
                }
            }
            return new ColorDerivativeEnergy(this.w, this.h - 1, p);
        }

        @Override
        public ImageProcessor getProcessor() {
            return new ColorProcessor(this.w, this.h, this.pixels);
        }
    }

    private static class FlippedImageEnergy
    extends ImageEnergy {
        private ImageEnergy orig;

        public FlippedImageEnergy(ImageEnergy orig) {
            super(orig.h, orig.w);
            this.orig = orig;
        }

        @Override
        public float get(int x, int y) {
            return this.orig.get(y, x);
        }

        @Override
        public ImageEnergy removeSeam(int[] seam, boolean vert) {
            return this.orig.removeSeam(seam, !vert);
        }

        @Override
        public ImageProcessor getProcessor() {
            throw new RuntimeException("Cannot flip arbitrary ImageProcessor");
        }
    }

    private static abstract class ImageEnergy {
        int w;
        int h;

        public ImageEnergy(int w, int h) {
            this.w = w;
            this.h = h;
        }

        public abstract float get(int var1, int var2);

        public int[] getVerticalSeam() {
            int[] seams = new int[this.w * this.h];
            float[] currentLine = new float[this.w];
            float[] previousLine = new float[this.w];
            for (int x = 0; x < this.w; ++x) {
                seams[x] = x;
                previousLine[x] = Math.abs(this.get(x, 0));
            }
            for (int y = 1; y < this.h; ++y) {
                for (int x = 0; x < this.w; ++x) {
                    int offset = x + y * this.w;
                    currentLine[x] = previousLine[x];
                    seams[offset] = x;
                    if (x > 0 && currentLine[x] > previousLine[x - 1]) {
                        currentLine[x] = previousLine[x - 1];
                        seams[offset] = x - 1;
                    }
                    if (x < this.w - 1 && currentLine[x] > previousLine[x + 1]) {
                        currentLine[x] = previousLine[x + 1];
                        seams[offset] = x + 1;
                    }
                    int n = x;
                    currentLine[n] = currentLine[n] + Math.abs(this.get(x, y));
                }
                float[] dummy = previousLine;
                previousLine = currentLine;
                currentLine = dummy;
            }
            int best = 0;
            for (int x = 1; x < this.w; ++x) {
                if (!(previousLine[x] < previousLine[best])) continue;
                best = x;
            }
            int[] result = new int[this.h];
            int x = best;
            for (int y = this.h - 1; y >= 0; --y) {
                result[y] = x;
                x = seams[x + y * this.w];
            }
            return result;
        }

        public int[] getHorizontalSeam() {
            return new FlippedImageEnergy(this).getVerticalSeam();
        }

        public abstract ImageProcessor getProcessor();

        public abstract ImageEnergy removeSeam(int[] var1, boolean var2);

        public ImageProcessor removeVerticalSeam() {
            return this.removeSeam(this.getVerticalSeam(), true).getProcessor();
        }

        public ImageProcessor removeHorizontalSeam() {
            return this.removeSeam(this.getHorizontalSeam(), false).getProcessor();
        }

        public Roi seam2roi(int[] seam, boolean vertical) {
            int[] other = new int[vertical ? this.h : this.w];
            for (int i = 0; i < other.length; ++i) {
                other[i] = i;
            }
            return new PolygonRoi(vertical ? seam : other, vertical ? other : seam, seam.length, 7);
        }
    }
}

