/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.HessianEvalueProcessor;
import features.SigmaPalette;
import features.TubenessProcessor;
import ij.IJ;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Polygon;

public class Sigma_Palette
extends SigmaPalette
implements PlugIn {
    public void run(String ignoredArguments) {
        Roi roi;
        System.out.println("In the run() method...");
        this.image = IJ.getImage();
        if (this.image == null) {
            IJ.error((String)"There is no current image");
            return;
        }
        Calibration calibration = this.image.getCalibration();
        double minimumSeparation = 1.0;
        if (calibration != null) {
            minimumSeparation = Math.min(calibration.pixelWidth, Math.min(calibration.pixelHeight, calibration.pixelDepth));
        }
        if ((roi = this.image.getRoi()) == null) {
            IJ.error((String)"There is no current point selection");
            return;
        }
        if (roi.getType() != 10) {
            IJ.error((String)"You must have a point selection");
            return;
        }
        Polygon p = roi.getPolygon();
        if (p.npoints != 1) {
            IJ.error((String)"You must have exactly one point selected");
            return;
        }
        ImageProcessor processor = this.image.getProcessor();
        int x = p.xpoints[0];
        int y = p.ypoints[0];
        int z = this.image.getCurrentSlice() - 1;
        int either_side = 40;
        int x_min = x - either_side;
        int x_max = x + either_side;
        int y_min = y - either_side;
        int y_max = y + either_side;
        int z_min = z - either_side;
        int z_max = z + either_side;
        int originalWidth = this.image.getWidth();
        int originalHeight = this.image.getHeight();
        int originalDepth = this.image.getStackSize();
        if (x_min < 0) {
            x_min = 0;
        }
        if (y_min < 0) {
            y_min = 0;
        }
        if (z_min < 0) {
            z_min = 0;
        }
        if (x_max >= originalWidth) {
            x_max = originalWidth - 1;
        }
        if (y_max >= originalHeight) {
            y_max = originalHeight - 1;
        }
        if (z_max >= originalDepth) {
            z_max = originalDepth - 1;
        }
        double[] sigmas = new double[9];
        for (int i = 0; i < sigmas.length; ++i) {
            sigmas[i] = (double)(i + 1) * minimumSeparation / 2.0;
        }
        this.makePalette(this.image, x_min, x_max, y_min, y_max, z_min, z_max, (HessianEvalueProcessor)new TubenessProcessor(true), sigmas, 4.0, 3, 3, z);
    }
}

