/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;

public class EdgeDetectors_
implements PlugInFilter {
    ImagePlus image;
    static final double[][] isotropic = new double[][]{{-1.0, -1.4142135623731, -1.0}, {0.0, 0.0, 0.0}, {1.0, 1.4142135623731, 1.0}};
    static double[][] roberts = new double[][]{{0.0, -1.0}, {1.0, 0.0}};
    static double[][] prewitt = new double[][]{{-1.0, -1.0, -1.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
    static double[][] sobel = new double[][]{{-1.0, -2.0, -1.0}, {0.0, 0.0, 0.0}, {1.0, 2.0, 1.0}};

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("Parameters");
        String[] list = new String[]{"Roberts", "Prewitt", "Sobel", "Isotropic"};
        gd.addChoice("detector", list, "Sobel");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int detector = gd.getNextChoiceIndex();
        double[][] matrix = detector == 0 ? roberts : (detector == 1 ? prewitt : (detector == 2 ? sobel : isotropic));
        int N = detector == 0 ? 2 : 3;
        double[][] matrix2 = new double[N][N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                matrix2[i][j] = N == 2 ? matrix[1 - i][j] : matrix[j][i];
            }
        }
        ImageStack stack = this.image.getStack();
        ImageStack res = new ImageStack(stack.getWidth(), stack.getHeight());
        for (int s = 1; s <= stack.getSize(); ++s) {
            res.addSlice("", (ImageProcessor)this.doit(stack.getProcessor(s), matrix, matrix2, N));
        }
        new ImagePlus("Edges" + detector, res).show();
    }

    private ByteProcessor doit(ImageProcessor ip, double[][] matrix1, double[][] matrix2, int N) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        double[] res = new double[w * h];
        double mmax = -1.0E9;
        double mmin = 1.0E9;
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                float res2 = 0.0f;
                float res3 = 0.0f;
                for (int ii = 0; ii < N; ++ii) {
                    for (int jj = 0; jj < N; ++jj) {
                        if (i + ii - 1 < 0 || i + ii - 1 >= w || j + jj - 1 < 0 || j + jj - 1 >= h) continue;
                        float value = ip.getPixel(i + ii - 1, j + jj - 1);
                        res2 = (float)((double)res2 + matrix1[ii][jj] * (double)value);
                        res3 = (float)((double)res3 + matrix2[ii][jj] * (double)value);
                    }
                }
                res[i + w * j] = Math.abs(res2) + Math.abs(res3);
                if (res[i + w * j] > mmax) {
                    mmax = res[i + w * j];
                }
                if (!(res[i + w * j] < mmin)) continue;
                mmin = res[i + w * j];
            }
        }
        byte[] res2 = new byte[w * h];
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                res2[i + w * j] = (byte)((res[i + w * j] - mmin) * 255.999 / (mmax - mmin));
            }
        }
        ByteProcessor ip2 = new ByteProcessor(w, h, res2, null);
        return ip2;
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 13;
    }
}

