/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import amira.AmiraTable;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import vib.app.module.TissueStatistics;

public class TissueStatistics_
implements PlugInFilter {
    ImagePlus image;

    public void run(ImageProcessor ip) {
        AmiraTable table = TissueStatistics_.calculateStatistics(this.image);
        table.show();
    }

    public static AmiraTable calculateStatistics(ImagePlus labelfield) {
        if (!AmiraParameters.isAmiraLabelfield((ImagePlus)labelfield)) {
            IJ.error((String)"Need a labelfield!");
            return null;
        }
        String title = "Statistics for " + labelfield.getTitle();
        String headings = "Nr\tMaterial\tCount\tVolume\tCenterX\tCenterY\tCenterZ\tMinX\tMaxX\tMinY\tMaxY\tMinZ\tMaxZ";
        TissueStatistics.Statistics stat = TissueStatistics.getStatistics((ImagePlus)labelfield);
        AmiraTable table = new AmiraTable(title, headings, stat.getResult(), true);
        return table;
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 3;
    }
}

