/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.Arrays;
import net.imglib2.AbstractInterval;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public final class FinalInterval
extends AbstractInterval {
    public FinalInterval(Interval interval) {
        super(interval);
    }

    public FinalInterval(Dimensions dimensions) {
        super(dimensions);
    }

    protected FinalInterval(long[] min, long[] max, boolean copy) {
        super(min, max, copy);
    }

    public FinalInterval(long[] min, long[] max) {
        this(min, max, true);
    }

    public FinalInterval(Localizable min, Localizable max) {
        super(min, max);
    }

    public FinalInterval(long ... dimensions) {
        super(dimensions);
    }

    public boolean equals(Object obj) {
        return obj instanceof FinalInterval && Intervals.equals(this, (FinalInterval)obj);
    }

    public int hashCode() {
        return Util.combineHash(Arrays.hashCode(this.min), Arrays.hashCode(this.max));
    }

    public static FinalInterval createMinSize(long ... minsize) {
        int n = minsize.length / 2;
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = minsize[d];
            max[d] = min[d] + minsize[d + n] - 1L;
        }
        return new FinalInterval(min, max);
    }

    public static FinalInterval createMinMax(long ... minmax) {
        int n = minmax.length / 2;
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = minmax[d];
            max[d] = minmax[d + n];
        }
        return new FinalInterval(min, max);
    }

    public static FinalInterval createMinSize(long[] min, long[] size) {
        int n = min.length;
        assert (n == size.length);
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            max[d] = min[d] + size[d] - 1L;
        }
        return new FinalInterval(min, max);
    }

    public static FinalInterval wrap(long[] min, long[] max) {
        return new FinalInterval(min, max, false);
    }
}

