/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.randomaccess;

import net.imglib2.RandomAccessible;
import net.imglib2.RealInterval;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolator;
import net.imglib2.interpolation.randomaccess.NLinearInterpolator1D;
import net.imglib2.interpolation.randomaccess.NLinearInterpolator2D;
import net.imglib2.type.numeric.NumericType;

public class NLinearInterpolatorFactory<T extends NumericType<T>>
implements InterpolatorFactory<T, RandomAccessible<T>> {
    @Override
    public NLinearInterpolator<T> create(RandomAccessible<T> randomAccessible) {
        switch (randomAccessible.numDimensions()) {
            case 1: {
                return new NLinearInterpolator1D<T>(randomAccessible);
            }
            case 2: {
                return new NLinearInterpolator2D<T>(randomAccessible);
            }
        }
        return new NLinearInterpolator<T>(randomAccessible);
    }

    @Override
    public NLinearInterpolator<T> create(RandomAccessible<T> randomAccessible, RealInterval interval) {
        return this.create(randomAccessible);
    }
}

