/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer.shear;

import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.transform.integer.BoundingBox;
import net.imglib2.transform.integer.shear.AbstractShearTransform;
import net.imglib2.transform.integer.shear.InverseShearTransform;

public class ShearTransform
extends AbstractShearTransform {
    public ShearTransform(int nDim, int shearDimension, int referenceDimension) {
        super(nDim, shearDimension, referenceDimension);
        this.inverse = new InverseShearTransform(nDim, shearDimension, referenceDimension, this);
    }

    protected ShearTransform(int nDim, int shearDimension, int referenceDimension, AbstractShearTransform inverse) {
        super(nDim, shearDimension, referenceDimension, inverse);
    }

    @Override
    public void apply(long[] source, long[] target) {
        assert (source.length >= this.nDim && target.length >= this.nDim);
        System.arraycopy(source, 0, target, 0, source.length);
        int n = this.shearDimension;
        target[n] = target[n] + target[this.referenceDimension];
    }

    @Override
    public void apply(int[] source, int[] target) {
        assert (source.length >= this.nDim && target.length >= this.nDim);
        System.arraycopy(source, 0, target, 0, source.length);
        int n = this.shearDimension;
        target[n] = target[n] + target[this.referenceDimension];
    }

    @Override
    public void apply(Localizable source, Positionable target) {
        assert (source.numDimensions() >= this.nDim && target.numDimensions() >= this.nDim);
        target.setPosition(source);
        target.setPosition(source.getLongPosition(this.shearDimension) + source.getLongPosition(this.referenceDimension), this.shearDimension);
    }

    @Override
    public ShearTransform copy() {
        return new ShearTransform(this.nDim, this.shearDimension, this.referenceDimension);
    }

    @Override
    public long[] getShear() {
        long[] shear = new long[this.nDim];
        shear[this.shearDimension] = 1L;
        return shear;
    }

    @Override
    public BoundingBox transform(BoundingBox bb) {
        bb.orderMinMax();
        long[] c = bb.corner2;
        long diff = c[this.referenceDimension] - bb.corner1[this.referenceDimension];
        int n = this.shearDimension;
        c[n] = c[n] + diff;
        return bb;
    }
}

